/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.Comparator;
import org.hibernate.HibernateException;
import org.hibernate.engine.jdbc.BinaryStream;
import org.hibernate.engine.jdbc.BlobImplementer;
import org.hibernate.engine.jdbc.BlobProxy;
import org.hibernate.engine.jdbc.WrappedBlob;
import org.hibernate.engine.jdbc.internal.BinaryStreamImpl;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.AbstractTypeDescriptor;
import org.hibernate.type.descriptor.java.DataHelper;
import org.hibernate.type.descriptor.java.IncomparableComparator;
import org.hibernate.type.descriptor.java.MutabilityPlan;
import org.hibernate.type.descriptor.java.PrimitiveByteArrayTypeDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlobTypeDescriptor
extends AbstractTypeDescriptor<Blob> {
    public static final BlobTypeDescriptor INSTANCE = new BlobTypeDescriptor();

    public BlobTypeDescriptor() {
        super(Blob.class, BlobMutabilityPlan.INSTANCE);
    }

    @Override
    public String toString(Blob blob) {
        byte[] byArray;
        try {
            byArray = DataHelper.extractBytes(blob.getBinaryStream());
        }
        catch (SQLException sQLException) {
            throw new HibernateException("Unable to access blob stream", sQLException);
        }
        return PrimitiveByteArrayTypeDescriptor.INSTANCE.toString(byArray);
    }

    @Override
    public Blob fromString(String string) {
        return BlobProxy.generateProxy(PrimitiveByteArrayTypeDescriptor.INSTANCE.fromString(string));
    }

    @Override
    public Comparator<Blob> getComparator() {
        return IncomparableComparator.INSTANCE;
    }

    @Override
    public int extractHashCode(Blob blob) {
        return System.identityHashCode(blob);
    }

    @Override
    public boolean areEqual(Blob blob, Blob blob2) {
        return blob == blob2;
    }

    @Override
    public <X> X unwrap(Blob blob, Class<X> clazz, WrapperOptions wrapperOptions) {
        if (blob == null) {
            return null;
        }
        try {
            if (BinaryStream.class.isAssignableFrom(clazz)) {
                if (BlobImplementer.class.isInstance(blob)) {
                    return (X)((BlobImplementer)((Object)blob)).getUnderlyingStream();
                }
                return (X)new BinaryStreamImpl(DataHelper.extractBytes(blob.getBinaryStream()));
            }
            if (byte[].class.isAssignableFrom(clazz)) {
                if (BlobImplementer.class.isInstance(blob)) {
                    return (X)((BlobImplementer)((Object)blob)).getUnderlyingStream().getBytes();
                }
                return (X)DataHelper.extractBytes(blob.getBinaryStream());
            }
            if (Blob.class.isAssignableFrom(clazz)) {
                Blob blob2 = WrappedBlob.class.isInstance(blob) ? ((WrappedBlob)((Object)blob)).getWrappedBlob() : blob;
                return (X)blob2;
            }
        }
        catch (SQLException sQLException) {
            throw new HibernateException("Unable to access blob stream", sQLException);
        }
        throw this.unknownUnwrap(clazz);
    }

    @Override
    public <X> Blob wrap(X x, WrapperOptions wrapperOptions) {
        if (x == null) {
            return null;
        }
        if (Blob.class.isAssignableFrom(x.getClass())) {
            return wrapperOptions.getLobCreator().wrap((Blob)x);
        }
        if (byte[].class.isAssignableFrom(x.getClass())) {
            return wrapperOptions.getLobCreator().createBlob((byte[])x);
        }
        if (InputStream.class.isAssignableFrom(x.getClass())) {
            InputStream inputStream = (InputStream)x;
            try {
                return wrapperOptions.getLobCreator().createBlob(inputStream, inputStream.available());
            }
            catch (IOException iOException) {
                throw this.unknownWrap(x.getClass());
            }
        }
        throw this.unknownWrap(x.getClass());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BlobMutabilityPlan
    implements MutabilityPlan<Blob> {
        public static final BlobMutabilityPlan INSTANCE = new BlobMutabilityPlan();

        @Override
        public boolean isMutable() {
            return false;
        }

        @Override
        public Blob deepCopy(Blob blob) {
            return blob;
        }

        @Override
        public Serializable disassemble(Blob blob) {
            throw new UnsupportedOperationException("Blobs are not cacheable");
        }

        @Override
        public Blob assemble(Serializable serializable) {
            throw new UnsupportedOperationException("Blobs are not cacheable");
        }
    }
}

