/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.AbstractTypeDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BigIntegerTypeDescriptor
extends AbstractTypeDescriptor<BigInteger> {
    public static final BigIntegerTypeDescriptor INSTANCE = new BigIntegerTypeDescriptor();

    public BigIntegerTypeDescriptor() {
        super(BigInteger.class);
    }

    @Override
    public String toString(BigInteger bigInteger) {
        return bigInteger.toString();
    }

    @Override
    public BigInteger fromString(String string) {
        return new BigInteger(string);
    }

    @Override
    public int extractHashCode(BigInteger bigInteger) {
        return bigInteger.intValue();
    }

    @Override
    public boolean areEqual(BigInteger bigInteger, BigInteger bigInteger2) {
        return bigInteger == bigInteger2 || bigInteger != null && bigInteger2 != null && bigInteger.compareTo(bigInteger2) == 0;
    }

    @Override
    public <X> X unwrap(BigInteger bigInteger, Class<X> clazz, WrapperOptions wrapperOptions) {
        if (bigInteger == null) {
            return null;
        }
        if (BigInteger.class.isAssignableFrom(clazz)) {
            return (X)bigInteger;
        }
        if (BigDecimal.class.isAssignableFrom(clazz)) {
            return (X)new BigDecimal(bigInteger);
        }
        if (Byte.class.isAssignableFrom(clazz)) {
            return (X)Byte.valueOf(bigInteger.byteValue());
        }
        if (Short.class.isAssignableFrom(clazz)) {
            return (X)Short.valueOf(bigInteger.shortValue());
        }
        if (Integer.class.isAssignableFrom(clazz)) {
            return (X)Integer.valueOf(bigInteger.intValue());
        }
        if (Long.class.isAssignableFrom(clazz)) {
            return (X)Long.valueOf(bigInteger.longValue());
        }
        if (Double.class.isAssignableFrom(clazz)) {
            return (X)Double.valueOf(bigInteger.doubleValue());
        }
        if (Float.class.isAssignableFrom(clazz)) {
            return (X)Float.valueOf(bigInteger.floatValue());
        }
        throw this.unknownUnwrap(clazz);
    }

    @Override
    public <X> BigInteger wrap(X x, WrapperOptions wrapperOptions) {
        if (x == null) {
            return null;
        }
        if (BigInteger.class.isInstance(x)) {
            return (BigInteger)x;
        }
        if (BigDecimal.class.isInstance(x)) {
            return ((BigDecimal)x).toBigIntegerExact();
        }
        if (Number.class.isInstance(x)) {
            return BigInteger.valueOf(((Number)x).longValue());
        }
        throw this.unknownWrap(x.getClass());
    }
}

