/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.AbstractTypeDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BigDecimalTypeDescriptor
extends AbstractTypeDescriptor<BigDecimal> {
    public static final BigDecimalTypeDescriptor INSTANCE = new BigDecimalTypeDescriptor();

    public BigDecimalTypeDescriptor() {
        super(BigDecimal.class);
    }

    @Override
    public String toString(BigDecimal bigDecimal) {
        return bigDecimal.toString();
    }

    @Override
    public BigDecimal fromString(String string) {
        return new BigDecimal(string);
    }

    @Override
    public boolean areEqual(BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        return bigDecimal == bigDecimal2 || bigDecimal != null && bigDecimal2 != null && bigDecimal.compareTo(bigDecimal2) == 0;
    }

    @Override
    public int extractHashCode(BigDecimal bigDecimal) {
        return bigDecimal.intValue();
    }

    @Override
    public <X> X unwrap(BigDecimal bigDecimal, Class<X> clazz, WrapperOptions wrapperOptions) {
        if (bigDecimal == null) {
            return null;
        }
        if (BigDecimal.class.isAssignableFrom(clazz)) {
            return (X)bigDecimal;
        }
        if (BigInteger.class.isAssignableFrom(clazz)) {
            return (X)bigDecimal.toBigIntegerExact();
        }
        if (Byte.class.isAssignableFrom(clazz)) {
            return (X)Byte.valueOf(bigDecimal.byteValue());
        }
        if (Short.class.isAssignableFrom(clazz)) {
            return (X)Short.valueOf(bigDecimal.shortValue());
        }
        if (Integer.class.isAssignableFrom(clazz)) {
            return (X)Integer.valueOf(bigDecimal.intValue());
        }
        if (Long.class.isAssignableFrom(clazz)) {
            return (X)Long.valueOf(bigDecimal.longValue());
        }
        if (Double.class.isAssignableFrom(clazz)) {
            return (X)Double.valueOf(bigDecimal.doubleValue());
        }
        if (Float.class.isAssignableFrom(clazz)) {
            return (X)Float.valueOf(bigDecimal.floatValue());
        }
        throw this.unknownUnwrap(clazz);
    }

    @Override
    public <X> BigDecimal wrap(X x, WrapperOptions wrapperOptions) {
        if (x == null) {
            return null;
        }
        if (BigDecimal.class.isInstance(x)) {
            return (BigDecimal)x;
        }
        if (BigInteger.class.isInstance(x)) {
            return new BigDecimal((BigInteger)x);
        }
        if (Number.class.isInstance(x)) {
            return BigDecimal.valueOf(((Number)x).doubleValue());
        }
        throw this.unknownWrap(x.getClass());
    }
}

