/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java;

import java.io.Serializable;
import java.util.Comparator;
import org.hibernate.HibernateException;
import org.hibernate.internal.util.compare.ComparableComparator;
import org.hibernate.internal.util.compare.EqualsHelper;
import org.hibernate.type.descriptor.java.ImmutableMutabilityPlan;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.descriptor.java.MutabilityPlan;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTypeDescriptor<T>
implements JavaTypeDescriptor<T>,
Serializable {
    private final Class<T> type;
    private final MutabilityPlan<T> mutabilityPlan;
    private final Comparator<T> comparator;

    protected AbstractTypeDescriptor(Class<T> clazz) {
        this(clazz, ImmutableMutabilityPlan.INSTANCE);
    }

    protected AbstractTypeDescriptor(Class<T> clazz, MutabilityPlan<T> mutabilityPlan) {
        this.type = clazz;
        this.mutabilityPlan = mutabilityPlan;
        this.comparator = Comparable.class.isAssignableFrom(clazz) ? ComparableComparator.INSTANCE : null;
    }

    @Override
    public MutabilityPlan<T> getMutabilityPlan() {
        return this.mutabilityPlan;
    }

    @Override
    public Class<T> getJavaTypeClass() {
        return this.type;
    }

    @Override
    public int extractHashCode(T t) {
        return t.hashCode();
    }

    @Override
    public boolean areEqual(T t, T t2) {
        return EqualsHelper.equals(t, t2);
    }

    @Override
    public Comparator<T> getComparator() {
        return this.comparator;
    }

    @Override
    public String extractLoggableRepresentation(T t) {
        return t == null ? "null" : t.toString();
    }

    protected HibernateException unknownUnwrap(Class clazz) {
        throw new HibernateException("Unknown unwrap conversion requested: " + this.type.getName() + " to " + clazz.getName());
    }

    protected HibernateException unknownWrap(Class clazz) {
        throw new HibernateException("Unknown wrap conversion requested: " + clazz.getName() + " to " + this.type.getName());
    }
}

