/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor;

import java.lang.reflect.Field;
import java.sql.Types;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.internal.CoreMessageLogger;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcTypeNameMapper {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, JdbcTypeNameMapper.class.getName());
    private static Map<Integer, String> JDBC_TYPE_MAP = JdbcTypeNameMapper.buildJdbcTypeMap();

    private static Map<Integer, String> buildJdbcTypeMap() {
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        Field[] fieldArray = Types.class.getFields();
        if (fieldArray == null) {
            throw new HibernateException("Unexpected problem extracting JDBC type mapping codes from java.sql.Types");
        }
        for (Field field : fieldArray) {
            try {
                int n = field.getInt(null);
                String string = hashMap.put(n, field.getName());
                if (string == null) continue;
                LOG.JavaSqlTypesMappedSameCodeMultipleTimes(n, string, field.getName());
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new HibernateException("Unable to access JDBC type mapping [" + field.getName() + "]", illegalAccessException);
            }
        }
        return Collections.unmodifiableMap(hashMap);
    }

    public static String getTypeName(Integer n) {
        String string = JDBC_TYPE_MAP.get(n);
        if (string == null) {
            return "UNKNOWN(" + n + ")";
        }
        return string;
    }
}

