/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.io.Serializable;
import java.util.Properties;
import org.hibernate.MappingException;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.type.BasicType;
import org.hibernate.type.BasicTypeRegistry;
import org.hibernate.type.Type;
import org.hibernate.type.TypeFactory;
import org.hibernate.usertype.CompositeUserType;
import org.hibernate.usertype.UserType;

public class TypeResolver
implements Serializable {
    private final BasicTypeRegistry basicTypeRegistry;
    private final TypeFactory typeFactory;

    public TypeResolver() {
        this(new BasicTypeRegistry(), new TypeFactory());
    }

    public TypeResolver(BasicTypeRegistry basicTypeRegistry, TypeFactory typeFactory) {
        this.basicTypeRegistry = basicTypeRegistry;
        this.typeFactory = typeFactory;
    }

    public TypeResolver scope(SessionFactoryImplementor sessionFactoryImplementor) {
        this.typeFactory.injectSessionFactory(sessionFactoryImplementor);
        return new TypeResolver(this.basicTypeRegistry.shallowCopy(), this.typeFactory);
    }

    public void registerTypeOverride(BasicType basicType) {
        this.basicTypeRegistry.register(basicType);
    }

    public void registerTypeOverride(UserType userType, String[] stringArray) {
        this.basicTypeRegistry.register(userType, stringArray);
    }

    public void registerTypeOverride(CompositeUserType compositeUserType, String[] stringArray) {
        this.basicTypeRegistry.register(compositeUserType, stringArray);
    }

    public TypeFactory getTypeFactory() {
        return this.typeFactory;
    }

    public BasicType basic(String string) {
        return this.basicTypeRegistry.getRegisteredType(string);
    }

    public Type heuristicType(String string) throws MappingException {
        return this.heuristicType(string, null);
    }

    public Type heuristicType(String string, Properties properties) throws MappingException {
        BasicType basicType = this.basic(string);
        if (basicType != null) {
            return basicType;
        }
        try {
            Class clazz = ReflectHelper.classForName(string);
            if (clazz != null) {
                return this.typeFactory.byClass(clazz, properties);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return null;
    }
}

