/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.io.Serializable;
import java.util.Map;
import org.hibernate.bytecode.instrumentation.spi.LazyPropertyInitializer;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.property.BackrefPropertyAccessor;
import org.hibernate.tuple.StandardProperty;
import org.hibernate.type.CompositeType;
import org.hibernate.type.ForeignKeyDirection;
import org.hibernate.type.Type;

public class TypeHelper {
    private TypeHelper() {
    }

    public static void deepCopy(Object[] objectArray, Type[] typeArray, boolean[] blArray, Object[] objectArray2, SessionImplementor sessionImplementor) {
        for (int i = 0; i < typeArray.length; ++i) {
            if (!blArray[i]) continue;
            objectArray2[i] = objectArray[i] == LazyPropertyInitializer.UNFETCHED_PROPERTY || objectArray[i] == BackrefPropertyAccessor.UNKNOWN ? objectArray[i] : typeArray[i].deepCopy(objectArray[i], sessionImplementor.getFactory());
        }
    }

    public static void beforeAssemble(Serializable[] serializableArray, Type[] typeArray, SessionImplementor sessionImplementor) {
        for (int i = 0; i < typeArray.length; ++i) {
            if (serializableArray[i] == LazyPropertyInitializer.UNFETCHED_PROPERTY || serializableArray[i] == BackrefPropertyAccessor.UNKNOWN) continue;
            typeArray[i].beforeAssemble(serializableArray[i], sessionImplementor);
        }
    }

    public static Object[] assemble(Serializable[] serializableArray, Type[] typeArray, SessionImplementor sessionImplementor, Object object) {
        Object[] objectArray = new Object[serializableArray.length];
        for (int i = 0; i < typeArray.length; ++i) {
            objectArray[i] = serializableArray[i] == LazyPropertyInitializer.UNFETCHED_PROPERTY || serializableArray[i] == BackrefPropertyAccessor.UNKNOWN ? serializableArray[i] : typeArray[i].assemble(serializableArray[i], sessionImplementor, object);
        }
        return objectArray;
    }

    public static Serializable[] disassemble(Object[] objectArray, Type[] typeArray, boolean[] blArray, SessionImplementor sessionImplementor, Object object) {
        Serializable[] serializableArray = new Serializable[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            serializableArray[i] = blArray != null && blArray[i] ? LazyPropertyInitializer.UNFETCHED_PROPERTY : (objectArray[i] == LazyPropertyInitializer.UNFETCHED_PROPERTY || objectArray[i] == BackrefPropertyAccessor.UNKNOWN ? (Serializable)objectArray[i] : typeArray[i].disassemble(objectArray[i], sessionImplementor, object));
        }
        return serializableArray;
    }

    public static Object[] replace(Object[] objectArray, Object[] objectArray2, Type[] typeArray, SessionImplementor sessionImplementor, Object object, Map map) {
        Object[] objectArray3 = new Object[objectArray.length];
        for (int i = 0; i < typeArray.length; ++i) {
            objectArray3[i] = objectArray[i] == LazyPropertyInitializer.UNFETCHED_PROPERTY || objectArray[i] == BackrefPropertyAccessor.UNKNOWN ? objectArray2[i] : typeArray[i].replace(objectArray[i], objectArray2[i], sessionImplementor, object, map);
        }
        return objectArray3;
    }

    public static Object[] replace(Object[] objectArray, Object[] objectArray2, Type[] typeArray, SessionImplementor sessionImplementor, Object object, Map map, ForeignKeyDirection foreignKeyDirection) {
        Object[] objectArray3 = new Object[objectArray.length];
        for (int i = 0; i < typeArray.length; ++i) {
            objectArray3[i] = objectArray[i] == LazyPropertyInitializer.UNFETCHED_PROPERTY || objectArray[i] == BackrefPropertyAccessor.UNKNOWN ? objectArray2[i] : typeArray[i].replace(objectArray[i], objectArray2[i], sessionImplementor, object, map, foreignKeyDirection);
        }
        return objectArray3;
    }

    public static Object[] replaceAssociations(Object[] objectArray, Object[] objectArray2, Type[] typeArray, SessionImplementor sessionImplementor, Object object, Map map, ForeignKeyDirection foreignKeyDirection) {
        Object[] objectArray3 = new Object[objectArray.length];
        for (int i = 0; i < typeArray.length; ++i) {
            if (objectArray[i] == LazyPropertyInitializer.UNFETCHED_PROPERTY || objectArray[i] == BackrefPropertyAccessor.UNKNOWN) {
                objectArray3[i] = objectArray2[i];
                continue;
            }
            if (typeArray[i].isComponentType()) {
                CompositeType compositeType = (CompositeType)typeArray[i];
                Type[] typeArray2 = compositeType.getSubtypes();
                Object[] objectArray4 = objectArray[i] == null ? new Object[typeArray2.length] : compositeType.getPropertyValues(objectArray[i], sessionImplementor);
                Object[] objectArray5 = objectArray2[i] == null ? new Object[typeArray2.length] : compositeType.getPropertyValues(objectArray2[i], sessionImplementor);
                TypeHelper.replaceAssociations(objectArray4, objectArray5, typeArray2, sessionImplementor, null, map, foreignKeyDirection);
                objectArray3[i] = objectArray2[i];
                continue;
            }
            objectArray3[i] = !typeArray[i].isAssociationType() ? objectArray2[i] : typeArray[i].replace(objectArray[i], objectArray2[i], sessionImplementor, object, map, foreignKeyDirection);
        }
        return objectArray3;
    }

    public static int[] findDirty(StandardProperty[] standardPropertyArray, Object[] objectArray, Object[] objectArray2, boolean[][] blArray, boolean bl, SessionImplementor sessionImplementor) {
        int[] nArray = null;
        int n = 0;
        int n2 = standardPropertyArray.length;
        for (int i = 0; i < n2; ++i) {
            boolean bl2;
            boolean bl3 = bl2 = objectArray[i] != LazyPropertyInitializer.UNFETCHED_PROPERTY && standardPropertyArray[i].isDirtyCheckable(bl) && standardPropertyArray[i].getType().isDirty(objectArray2[i], objectArray[i], blArray[i], sessionImplementor);
            if (!bl2) continue;
            if (nArray == null) {
                nArray = new int[n2];
            }
            nArray[n++] = i;
        }
        if (n == 0) {
            return null;
        }
        int[] nArray2 = new int[n];
        System.arraycopy(nArray, 0, nArray2, 0, n);
        return nArray2;
    }

    public static int[] findModified(StandardProperty[] standardPropertyArray, Object[] objectArray, Object[] objectArray2, boolean[][] blArray, boolean bl, SessionImplementor sessionImplementor) {
        int[] nArray = null;
        int n = 0;
        int n2 = standardPropertyArray.length;
        for (int i = 0; i < n2; ++i) {
            boolean bl2;
            boolean bl3 = bl2 = objectArray[i] != LazyPropertyInitializer.UNFETCHED_PROPERTY && standardPropertyArray[i].isDirtyCheckable(bl) && standardPropertyArray[i].getType().isModified(objectArray2[i], objectArray[i], blArray[i], sessionImplementor);
            if (!bl2) continue;
            if (nArray == null) {
                nArray = new int[n2];
            }
            nArray[n++] = i;
        }
        if (n == 0) {
            return null;
        }
        int[] nArray2 = new int[n];
        System.arraycopy(nArray, 0, nArray2, 0, n);
        return nArray2;
    }
}

