/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.classic.Lifecycle;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.tuple.component.ComponentMetamodel;
import org.hibernate.type.AnyType;
import org.hibernate.type.ArrayType;
import org.hibernate.type.BagType;
import org.hibernate.type.CollectionType;
import org.hibernate.type.ComponentType;
import org.hibernate.type.CompositeCustomType;
import org.hibernate.type.CustomCollectionType;
import org.hibernate.type.CustomType;
import org.hibernate.type.EmbeddedComponentType;
import org.hibernate.type.EntityType;
import org.hibernate.type.ForeignKeyDirection;
import org.hibernate.type.IdentifierBagType;
import org.hibernate.type.ListType;
import org.hibernate.type.ManyToOneType;
import org.hibernate.type.MapType;
import org.hibernate.type.OneToOneType;
import org.hibernate.type.OrderedMapType;
import org.hibernate.type.OrderedSetType;
import org.hibernate.type.SerializableType;
import org.hibernate.type.SetType;
import org.hibernate.type.SortedMapType;
import org.hibernate.type.SortedSetType;
import org.hibernate.type.SpecialOneToOneType;
import org.hibernate.type.Type;
import org.hibernate.usertype.CompositeUserType;
import org.hibernate.usertype.ParameterizedType;
import org.hibernate.usertype.UserType;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TypeFactory
implements Serializable {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, TypeFactory.class.getName());
    private final TypeScopeImpl typeScope = new TypeScopeImpl();

    public void injectSessionFactory(SessionFactoryImplementor sessionFactoryImplementor) {
        this.typeScope.injectSessionFactory(sessionFactoryImplementor);
    }

    public SessionFactoryImplementor resolveSessionFactory() {
        return this.typeScope.resolveFactory();
    }

    public Type byClass(Class clazz, Properties properties) {
        if (Type.class.isAssignableFrom(clazz)) {
            return this.type(clazz, properties);
        }
        if (CompositeUserType.class.isAssignableFrom(clazz)) {
            return this.customComponent(clazz, properties);
        }
        if (UserType.class.isAssignableFrom(clazz)) {
            return this.custom(clazz, properties);
        }
        if (Lifecycle.class.isAssignableFrom(clazz)) {
            return this.manyToOne(clazz.getName());
        }
        if (Serializable.class.isAssignableFrom(clazz)) {
            return TypeFactory.serializable(clazz);
        }
        return null;
    }

    public Type type(Class<Type> clazz, Properties properties) {
        try {
            Type type = clazz.newInstance();
            TypeFactory.injectParameters(type, properties);
            return type;
        }
        catch (Exception exception) {
            throw new MappingException("Could not instantiate Type: " + clazz.getName(), exception);
        }
    }

    public static void injectParameters(Object object, Properties properties) {
        if (ParameterizedType.class.isInstance(object)) {
            ((ParameterizedType)object).setParameterValues(properties);
        } else if (properties != null && !properties.isEmpty()) {
            throw new MappingException("type is not parameterized: " + object.getClass().getName());
        }
    }

    public CompositeCustomType customComponent(Class<CompositeUserType> clazz, Properties properties) {
        return TypeFactory.customComponent(clazz, properties, this.typeScope);
    }

    @Deprecated
    public static CompositeCustomType customComponent(Class<CompositeUserType> clazz, Properties properties, TypeScope typeScope) {
        try {
            CompositeUserType compositeUserType = clazz.newInstance();
            TypeFactory.injectParameters(compositeUserType, properties);
            return new CompositeCustomType(compositeUserType);
        }
        catch (Exception exception) {
            throw new MappingException("Unable to instantiate custom type: " + clazz.getName(), exception);
        }
    }

    @Deprecated
    public CollectionType customCollection(String string, Properties properties, String string2, String string3, boolean bl) {
        Class clazz;
        try {
            clazz = ReflectHelper.classForName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new MappingException("user collection type class not found: " + string, classNotFoundException);
        }
        CustomCollectionType customCollectionType = new CustomCollectionType(this.typeScope, clazz, string2, string3, bl);
        if (properties != null) {
            TypeFactory.injectParameters(customCollectionType.getUserType(), properties);
        }
        return customCollectionType;
    }

    public CollectionType customCollection(String string, Properties properties, String string2, String string3) {
        Class clazz;
        try {
            clazz = ReflectHelper.classForName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new MappingException("user collection type class not found: " + string, classNotFoundException);
        }
        CustomCollectionType customCollectionType = new CustomCollectionType((TypeScope)this.typeScope, clazz, string2, string3);
        if (properties != null) {
            TypeFactory.injectParameters(customCollectionType.getUserType(), properties);
        }
        return customCollectionType;
    }

    public CustomType custom(Class<UserType> clazz, Properties properties) {
        return TypeFactory.custom(clazz, properties, this.typeScope);
    }

    @Deprecated
    public static CustomType custom(Class<UserType> clazz, Properties properties, TypeScope typeScope) {
        try {
            UserType userType = clazz.newInstance();
            TypeFactory.injectParameters(userType, properties);
            return new CustomType(userType);
        }
        catch (Exception exception) {
            throw new MappingException("Unable to instantiate custom type: " + clazz.getName(), exception);
        }
    }

    public static <T extends Serializable> SerializableType<T> serializable(Class<T> clazz) {
        return new SerializableType<T>(clazz);
    }

    @Deprecated
    public EntityType oneToOne(String string, ForeignKeyDirection foreignKeyDirection, String string2, boolean bl, boolean bl2, boolean bl3, String string3, String string4) {
        return this.oneToOne(string, foreignKeyDirection, string2 == null, string2, bl, bl2, string3, string4);
    }

    @Deprecated
    public EntityType oneToOne(String string, ForeignKeyDirection foreignKeyDirection, String string2, boolean bl, boolean bl2, String string3, String string4) {
        return this.oneToOne(string, foreignKeyDirection, string2 == null, string2, bl, bl2, string3, string4);
    }

    public EntityType oneToOne(String string, ForeignKeyDirection foreignKeyDirection, boolean bl, String string2, boolean bl2, boolean bl3, String string3, String string4) {
        return new OneToOneType((TypeScope)this.typeScope, string, foreignKeyDirection, bl, string2, bl2, bl3, string3, string4);
    }

    @Deprecated
    public EntityType specialOneToOne(String string, ForeignKeyDirection foreignKeyDirection, String string2, boolean bl, boolean bl2, String string3, String string4) {
        return this.specialOneToOne(string, foreignKeyDirection, string2 == null, string2, bl, bl2, string3, string4);
    }

    public EntityType specialOneToOne(String string, ForeignKeyDirection foreignKeyDirection, boolean bl, String string2, boolean bl2, boolean bl3, String string3, String string4) {
        return new SpecialOneToOneType((TypeScope)this.typeScope, string, foreignKeyDirection, bl, string2, bl2, bl3, string3, string4);
    }

    public EntityType manyToOne(String string) {
        return new ManyToOneType(this.typeScope, string);
    }

    public EntityType manyToOne(String string, boolean bl) {
        return new ManyToOneType(this.typeScope, string, bl);
    }

    @Deprecated
    public EntityType manyToOne(String string, String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        return this.manyToOne(string, string2 == null, string2, bl, bl2, bl4, bl5);
    }

    @Deprecated
    public EntityType manyToOne(String string, String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        return this.manyToOne(string, string2 == null, string2, bl, bl2, bl3, bl4);
    }

    public EntityType manyToOne(String string, boolean bl, String string2, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        return new ManyToOneType((TypeScope)this.typeScope, string, bl, string2, bl2, bl3, bl4, bl5);
    }

    @Deprecated
    public CollectionType array(String string, String string2, boolean bl, Class clazz) {
        return new ArrayType(this.typeScope, string, string2, clazz, bl);
    }

    public CollectionType array(String string, String string2, Class clazz) {
        return new ArrayType((TypeScope)this.typeScope, string, string2, clazz);
    }

    @Deprecated
    public CollectionType list(String string, String string2, boolean bl) {
        return new ListType(this.typeScope, string, string2, bl);
    }

    public CollectionType list(String string, String string2) {
        return new ListType(this.typeScope, string, string2);
    }

    @Deprecated
    public CollectionType bag(String string, String string2, boolean bl) {
        return new BagType(this.typeScope, string, string2, bl);
    }

    public CollectionType bag(String string, String string2) {
        return new BagType(this.typeScope, string, string2);
    }

    @Deprecated
    public CollectionType idbag(String string, String string2, boolean bl) {
        return new IdentifierBagType(this.typeScope, string, string2, bl);
    }

    public CollectionType idbag(String string, String string2) {
        return new IdentifierBagType(this.typeScope, string, string2);
    }

    @Deprecated
    public CollectionType map(String string, String string2, boolean bl) {
        return new MapType(this.typeScope, string, string2, bl);
    }

    public CollectionType map(String string, String string2) {
        return new MapType(this.typeScope, string, string2);
    }

    @Deprecated
    public CollectionType orderedMap(String string, String string2, boolean bl) {
        return new OrderedMapType(this.typeScope, string, string2, bl);
    }

    public CollectionType orderedMap(String string, String string2) {
        return new OrderedMapType(this.typeScope, string, string2);
    }

    @Deprecated
    public CollectionType sortedMap(String string, String string2, boolean bl, Comparator comparator) {
        return new SortedMapType(this.typeScope, string, string2, comparator, bl);
    }

    public CollectionType sortedMap(String string, String string2, Comparator comparator) {
        return new SortedMapType((TypeScope)this.typeScope, string, string2, comparator);
    }

    @Deprecated
    public CollectionType set(String string, String string2, boolean bl) {
        return new SetType(this.typeScope, string, string2, bl);
    }

    public CollectionType set(String string, String string2) {
        return new SetType(this.typeScope, string, string2);
    }

    @Deprecated
    public CollectionType orderedSet(String string, String string2, boolean bl) {
        return new OrderedSetType(this.typeScope, string, string2, bl);
    }

    public CollectionType orderedSet(String string, String string2) {
        return new OrderedSetType(this.typeScope, string, string2);
    }

    @Deprecated
    public CollectionType sortedSet(String string, String string2, boolean bl, Comparator comparator) {
        return new SortedSetType(this.typeScope, string, string2, comparator, bl);
    }

    public CollectionType sortedSet(String string, String string2, Comparator comparator) {
        return new SortedSetType((TypeScope)this.typeScope, string, string2, comparator);
    }

    public ComponentType component(ComponentMetamodel componentMetamodel) {
        return new ComponentType(this.typeScope, componentMetamodel);
    }

    public EmbeddedComponentType embeddedComponent(ComponentMetamodel componentMetamodel) {
        return new EmbeddedComponentType(this.typeScope, componentMetamodel);
    }

    public Type any(Type type, Type type2) {
        return new AnyType(type, type2);
    }

    private static class TypeScopeImpl
    implements TypeScope {
        private SessionFactoryImplementor factory;

        private TypeScopeImpl() {
        }

        public void injectSessionFactory(SessionFactoryImplementor sessionFactoryImplementor) {
            if (this.factory != null) {
                LOG.scopingTypesToSessionFactoryAfterAlreadyScoped(this.factory, sessionFactoryImplementor);
            } else {
                LOG.tracev("Scoping types to session factory {0}", (Object)sessionFactoryImplementor);
            }
            this.factory = sessionFactoryImplementor;
        }

        public SessionFactoryImplementor resolveFactory() {
            if (this.factory == null) {
                throw new HibernateException("SessionFactory for type scoping not yet known");
            }
            return this.factory;
        }
    }

    public static interface TypeScope
    extends Serializable {
        public SessionFactoryImplementor resolveFactory();
    }
}

