/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import javax.persistence.Enumerated;
import javax.persistence.MapKeyEnumerated;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.usertype.DynamicParameterizedType;
import org.hibernate.usertype.EnhancedUserType;
import org.hibernate.usertype.LoggableUserType;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumType
implements EnhancedUserType,
DynamicParameterizedType,
LoggableUserType,
Serializable {
    private static final Logger LOG = Logger.getLogger(EnumType.class.getName());
    public static final String ENUM = "enumClass";
    public static final String NAMED = "useNamed";
    public static final String TYPE = "type";
    private Class<? extends Enum> enumClass;
    private EnumValueMapper enumValueMapper;
    private int sqlType = 4;

    @Override
    public int[] sqlTypes() {
        return new int[]{this.sqlType};
    }

    @Override
    public Class<? extends Enum> returnedClass() {
        return this.enumClass;
    }

    @Override
    public boolean equals(Object object, Object object2) throws HibernateException {
        return object == object2;
    }

    @Override
    public int hashCode(Object object) throws HibernateException {
        return object == null ? 0 : object.hashCode();
    }

    @Override
    public Object nullSafeGet(ResultSet resultSet, String[] stringArray, SessionImplementor sessionImplementor, Object object) throws SQLException {
        if (this.enumValueMapper == null) {
            this.resolveEnumValueMapper(resultSet, stringArray[0]);
        }
        return this.enumValueMapper.getValue(resultSet, stringArray);
    }

    private void resolveEnumValueMapper(ResultSet resultSet, String string) {
        if (this.enumValueMapper == null) {
            try {
                this.resolveEnumValueMapper(resultSet.getMetaData().getColumnType(resultSet.findColumn(string)));
            }
            catch (Exception exception) {
                LOG.debugf("JDBC driver threw exception calling java.sql.ResultSetMetaData.getColumnType; using fallback determination [%s] : %s", (Object)this.enumClass.getName(), (Object)exception.getMessage());
                try {
                    Object object = resultSet.getObject(string);
                    if (Number.class.isInstance(object)) {
                        this.treatAsOrdinal();
                    } else {
                        this.treatAsNamed();
                    }
                }
                catch (SQLException sQLException) {
                    this.treatAsOrdinal();
                }
            }
        }
    }

    private void resolveEnumValueMapper(int n) {
        if (this.isOrdinal(n)) {
            this.treatAsOrdinal();
        } else {
            this.treatAsNamed();
        }
    }

    @Override
    public void nullSafeSet(PreparedStatement preparedStatement, Object object, int n, SessionImplementor sessionImplementor) throws HibernateException, SQLException {
        if (this.enumValueMapper == null) {
            this.resolveEnumValueMapper(preparedStatement, n);
        }
        this.enumValueMapper.setValue(preparedStatement, (Enum)object, n);
    }

    private void resolveEnumValueMapper(PreparedStatement preparedStatement, int n) {
        if (this.enumValueMapper == null) {
            try {
                this.resolveEnumValueMapper(preparedStatement.getParameterMetaData().getParameterType(n));
            }
            catch (Exception exception) {
                LOG.debugf("JDBC driver threw exception calling java.sql.ParameterMetaData#getParameterType; falling back to ordinal-based enum mapping [%s] : %s", (Object)this.enumClass.getName(), (Object)exception.getMessage());
                this.treatAsOrdinal();
            }
        }
    }

    @Override
    public Object deepCopy(Object object) throws HibernateException {
        return object;
    }

    @Override
    public boolean isMutable() {
        return false;
    }

    @Override
    public Serializable disassemble(Object object) throws HibernateException {
        return (Serializable)object;
    }

    @Override
    public Object assemble(Serializable serializable, Object object) throws HibernateException {
        return serializable;
    }

    @Override
    public Object replace(Object object, Object object2, Object object3) throws HibernateException {
        return object;
    }

    @Override
    public void setParameterValues(Properties properties) {
        DynamicParameterizedType.ParameterType parameterType = (DynamicParameterizedType.ParameterType)properties.get("org.hibernate.type.ParameterType");
        if (parameterType != null) {
            boolean bl;
            this.enumClass = parameterType.getReturnedClass().asSubclass(Enum.class);
            javax.persistence.EnumType enumType = this.getEnumType(parameterType);
            if (enumType == null) {
                bl = true;
            } else if (javax.persistence.EnumType.ORDINAL.equals((Object)enumType)) {
                bl = true;
            } else if (javax.persistence.EnumType.STRING.equals((Object)enumType)) {
                bl = false;
            } else {
                throw new AssertionFailure("Unknown EnumType: " + (Object)((Object)enumType));
            }
            if (bl) {
                this.treatAsOrdinal();
            } else {
                this.treatAsNamed();
            }
            this.sqlType = this.enumValueMapper.getSqlType();
        } else {
            String string = (String)properties.get(ENUM);
            try {
                this.enumClass = ReflectHelper.classForName(string, this.getClass()).asSubclass(Enum.class);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new HibernateException("Enum class not found", classNotFoundException);
            }
            Object object = properties.get(NAMED);
            if (object != null) {
                boolean bl = ConfigurationHelper.getBoolean(NAMED, properties);
                if (bl) {
                    this.treatAsNamed();
                } else {
                    this.treatAsOrdinal();
                }
                this.sqlType = this.enumValueMapper.getSqlType();
            }
        }
        String string = (String)properties.get(TYPE);
        if (string != null) {
            this.sqlType = Integer.decode(string);
        }
    }

    private void treatAsOrdinal() {
        if (this.enumValueMapper == null || !OrdinalEnumValueMapper.class.isInstance(this.enumValueMapper)) {
            this.enumValueMapper = new OrdinalEnumValueMapper();
            this.sqlType = this.enumValueMapper.getSqlType();
        }
    }

    private void treatAsNamed() {
        if (this.enumValueMapper == null || !NamedEnumValueMapper.class.isInstance(this.enumValueMapper)) {
            this.enumValueMapper = new NamedEnumValueMapper();
            this.sqlType = this.enumValueMapper.getSqlType();
        }
    }

    private javax.persistence.EnumType getEnumType(DynamicParameterizedType.ParameterType parameterType) {
        javax.persistence.EnumType enumType = null;
        if (parameterType.isPrimaryKey()) {
            MapKeyEnumerated mapKeyEnumerated = this.getAnnotation(parameterType.getAnnotationsMethod(), MapKeyEnumerated.class);
            if (mapKeyEnumerated != null) {
                enumType = mapKeyEnumerated.value();
            }
        } else {
            Enumerated enumerated = this.getAnnotation(parameterType.getAnnotationsMethod(), Enumerated.class);
            if (enumerated != null) {
                enumType = enumerated.value();
            }
        }
        return enumType;
    }

    private <T extends Annotation> T getAnnotation(Annotation[] annotationArray, Class<T> clazz) {
        for (Annotation annotation : annotationArray) {
            if (!clazz.isInstance(annotation)) continue;
            return (T)annotation;
        }
        return null;
    }

    @Override
    public String objectToSQLString(Object object) {
        return this.enumValueMapper.objectToSQLString((Enum)object);
    }

    @Override
    public String toXMLString(Object object) {
        return this.enumValueMapper.toXMLString((Enum)object);
    }

    @Override
    public Object fromXMLString(String string) {
        return this.enumValueMapper.fromXMLString(string);
    }

    @Override
    public String toLoggableString(Object object, SessionFactoryImplementor sessionFactoryImplementor) {
        if (this.enumValueMapper != null) {
            return this.enumValueMapper.toXMLString((Enum)object);
        }
        return object.toString();
    }

    public boolean isOrdinal() {
        return this.isOrdinal(this.sqlType);
    }

    private boolean isOrdinal(int n) {
        switch (n) {
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                return true;
            }
            case -1: 
            case 1: 
            case 12: {
                return false;
            }
        }
        throw new HibernateException("Unable to persist an Enum in a column of SQL Type: " + n);
    }

    private class NamedEnumValueMapper
    extends EnumValueMapperSupport
    implements EnumValueMapper,
    Serializable {
        private NamedEnumValueMapper() {
        }

        public int getSqlType() {
            return 12;
        }

        public Enum getValue(ResultSet resultSet, String[] stringArray) throws SQLException {
            String string = resultSet.getString(stringArray[0]);
            boolean bl = LOG.isTraceEnabled();
            if (resultSet.wasNull()) {
                if (bl) {
                    LOG.trace(String.format("Returning null as column [%s]", stringArray[0]));
                }
                return null;
            }
            Enum enum_ = this.fromName(string);
            if (bl) {
                LOG.trace(String.format("Returning [%s] as column [%s]", enum_, stringArray[0]));
            }
            return enum_;
        }

        private Enum fromName(String string) {
            try {
                return Enum.valueOf(EnumType.this.enumClass, string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IllegalArgumentException(String.format("Unknown name value [%s] for enum class [%s]", string, EnumType.this.enumClass.getName()));
            }
        }

        public String objectToSQLString(Enum enum_) {
            return '\'' + this.toXMLString(enum_) + '\'';
        }

        public String toXMLString(Enum enum_) {
            return enum_.name();
        }

        public Enum fromXMLString(String string) {
            return this.fromName(string);
        }

        protected Object extractJdbcValue(Enum enum_) {
            return enum_.name();
        }
    }

    private class OrdinalEnumValueMapper
    extends EnumValueMapperSupport
    implements EnumValueMapper,
    Serializable {
        private transient Enum[] enumsByOrdinal;

        private OrdinalEnumValueMapper() {
        }

        public int getSqlType() {
            return 4;
        }

        public Enum getValue(ResultSet resultSet, String[] stringArray) throws SQLException {
            int n = resultSet.getInt(stringArray[0]);
            boolean bl = LOG.isTraceEnabled();
            if (resultSet.wasNull()) {
                if (bl) {
                    LOG.trace(String.format("Returning null as column [%s]", stringArray[0]));
                }
                return null;
            }
            Enum enum_ = this.fromOrdinal(n);
            if (bl) {
                LOG.trace(String.format("Returning [%s] as column [%s]", enum_, stringArray[0]));
            }
            return enum_;
        }

        private Enum fromOrdinal(int n) {
            Enum[] enumArray = this.enumsByOrdinal();
            if (n < 0 || n >= enumArray.length) {
                throw new IllegalArgumentException(String.format("Unknown ordinal value [%s] for enum class [%s]", n, EnumType.this.enumClass.getName()));
            }
            return enumArray[n];
        }

        private Enum[] enumsByOrdinal() {
            if (this.enumsByOrdinal == null) {
                this.enumsByOrdinal = (Enum[])EnumType.this.enumClass.getEnumConstants();
                if (this.enumsByOrdinal == null) {
                    throw new HibernateException("Failed to init enum values");
                }
            }
            return this.enumsByOrdinal;
        }

        public String objectToSQLString(Enum enum_) {
            return this.toXMLString(enum_);
        }

        public String toXMLString(Enum enum_) {
            return Integer.toString(enum_.ordinal());
        }

        public Enum fromXMLString(String string) {
            return this.fromOrdinal(Integer.parseInt(string));
        }

        protected Object extractJdbcValue(Enum enum_) {
            return enum_.ordinal();
        }
    }

    public abstract class EnumValueMapperSupport
    implements EnumValueMapper {
        protected abstract Object extractJdbcValue(Enum var1);

        public void setValue(PreparedStatement preparedStatement, Enum enum_, int n) throws SQLException {
            Object object = enum_ == null ? null : this.extractJdbcValue(enum_);
            boolean bl = LOG.isTraceEnabled();
            if (object == null) {
                if (bl) {
                    LOG.trace(String.format("Binding null to parameter: [%s]", n));
                }
                preparedStatement.setNull(n, this.getSqlType());
                return;
            }
            if (bl) {
                LOG.trace(String.format("Binding [%s] to parameter: [%s]", object, n));
            }
            preparedStatement.setObject(n, object, EnumType.this.sqlType);
        }
    }

    private static interface EnumValueMapper
    extends Serializable {
        public int getSqlType();

        public Enum getValue(ResultSet var1, String[] var2) throws SQLException;

        public void setValue(PreparedStatement var1, Enum var2, int var3) throws SQLException;

        public String objectToSQLString(Enum var1);

        public String toXMLString(Enum var1);

        public Enum fromXMLString(String var1);
    }
}

