/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import org.dom4j.Element;
import org.dom4j.Node;
import org.hibernate.AssertionFailure;
import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.engine.internal.ForeignKeys;
import org.hibernate.engine.spi.EntityUniqueKey;
import org.hibernate.engine.spi.Mapping;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.Joinable;
import org.hibernate.persister.entity.UniqueKeyLoadable;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.tuple.ElementWrapper;
import org.hibernate.type.AbstractType;
import org.hibernate.type.AssociationType;
import org.hibernate.type.Type;
import org.hibernate.type.TypeFactory;

public abstract class EntityType
extends AbstractType
implements AssociationType {
    private final TypeFactory.TypeScope scope;
    private final String associatedEntityName;
    protected final String uniqueKeyPropertyName;
    protected final boolean isEmbeddedInXML;
    private final boolean eager;
    private final boolean unwrapProxy;
    private final boolean referenceToPrimaryKey;
    private transient Class returnedClass;

    @Deprecated
    protected EntityType(TypeFactory.TypeScope typeScope, String string, String string2, boolean bl, boolean bl2, boolean bl3) {
        this(typeScope, string, string2 == null, string2, bl, bl3);
    }

    @Deprecated
    protected EntityType(TypeFactory.TypeScope typeScope, String string, String string2, boolean bl, boolean bl2) {
        this(typeScope, string, string2 == null, string2, bl, bl2);
    }

    protected EntityType(TypeFactory.TypeScope typeScope, String string, boolean bl, String string2, boolean bl2, boolean bl3) {
        this.scope = typeScope;
        this.associatedEntityName = string;
        this.uniqueKeyPropertyName = string2;
        this.isEmbeddedInXML = true;
        this.eager = bl2;
        this.unwrapProxy = bl3;
        this.referenceToPrimaryKey = bl;
    }

    protected TypeFactory.TypeScope scope() {
        return this.scope;
    }

    public boolean isAssociationType() {
        return true;
    }

    public final boolean isEntityType() {
        return true;
    }

    public boolean isMutable() {
        return false;
    }

    public String toString() {
        return this.getClass().getName() + '(' + this.getAssociatedEntityName() + ')';
    }

    public String getName() {
        return this.associatedEntityName;
    }

    public boolean isReferenceToPrimaryKey() {
        return this.referenceToPrimaryKey;
    }

    public String getRHSUniqueKeyPropertyName() {
        return this.referenceToPrimaryKey ? null : this.uniqueKeyPropertyName;
    }

    public String getLHSPropertyName() {
        return null;
    }

    public String getPropertyName() {
        return null;
    }

    public final String getAssociatedEntityName() {
        return this.associatedEntityName;
    }

    public String getAssociatedEntityName(SessionFactoryImplementor sessionFactoryImplementor) {
        return this.getAssociatedEntityName();
    }

    public Joinable getAssociatedJoinable(SessionFactoryImplementor sessionFactoryImplementor) throws MappingException {
        return (Joinable)((Object)sessionFactoryImplementor.getEntityPersister(this.associatedEntityName));
    }

    public final Class getReturnedClass() {
        if (this.returnedClass == null) {
            this.returnedClass = this.determineAssociatedEntityClass();
        }
        return this.returnedClass;
    }

    private Class determineAssociatedEntityClass() {
        String string = this.getAssociatedEntityName();
        try {
            return ReflectHelper.classForName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return this.scope.resolveFactory().getEntityPersister(string).getEntityTuplizer().getMappedClass();
        }
    }

    public Object nullSafeGet(ResultSet resultSet, String string, SessionImplementor sessionImplementor, Object object) throws HibernateException, SQLException {
        return this.nullSafeGet(resultSet, new String[]{string}, sessionImplementor, object);
    }

    public final Object nullSafeGet(ResultSet resultSet, String[] stringArray, SessionImplementor sessionImplementor, Object object) throws HibernateException, SQLException {
        return this.resolve(this.hydrate(resultSet, stringArray, sessionImplementor, object), sessionImplementor, object);
    }

    public final boolean isSame(Object object, Object object2) {
        return object == object2;
    }

    public int compare(Object object, Object object2) {
        return 0;
    }

    public Object deepCopy(Object object, SessionFactoryImplementor sessionFactoryImplementor) {
        return object;
    }

    public Object replace(Object object, Object object2, SessionImplementor sessionImplementor, Object object3, Map map) throws HibernateException {
        if (object == null) {
            return null;
        }
        Object v = map.get(object);
        if (v != null) {
            return v;
        }
        if (object == object2) {
            return object2;
        }
        if (sessionImplementor.getContextEntityIdentifier(object) == null && ForeignKeys.isTransient(this.associatedEntityName, object, Boolean.FALSE, sessionImplementor)) {
            Object object4 = sessionImplementor.getFactory().getEntityPersister(this.associatedEntityName).instantiate(null, sessionImplementor);
            map.put(object, object4);
            return object4;
        }
        Object object5 = this.getIdentifier(object, sessionImplementor);
        if (object5 == null) {
            throw new AssertionFailure("non-transient entity has a null id");
        }
        object5 = this.getIdentifierOrUniqueKeyType(sessionImplementor.getFactory()).replace(object5, null, sessionImplementor, object3, map);
        return this.resolve(object5, sessionImplementor, object3);
    }

    public int getHashCode(Object object, SessionFactoryImplementor sessionFactoryImplementor) {
        Class clazz;
        EntityPersister entityPersister = sessionFactoryImplementor.getEntityPersister(this.associatedEntityName);
        if (!entityPersister.canExtractIdOutOfEntity()) {
            return super.getHashCode(object);
        }
        Serializable serializable = object instanceof HibernateProxy ? ((HibernateProxy)object).getHibernateLazyInitializer().getIdentifier() : ((clazz = entityPersister.getMappedClass()).isAssignableFrom(object.getClass()) ? entityPersister.getIdentifier(object) : (Serializable)object);
        return entityPersister.getIdentifierType().getHashCode(serializable, sessionFactoryImplementor);
    }

    public boolean isEqual(Object object, Object object2, SessionFactoryImplementor sessionFactoryImplementor) {
        if (object == null || object2 == null) {
            return object == object2;
        }
        EntityPersister entityPersister = sessionFactoryImplementor.getEntityPersister(this.associatedEntityName);
        if (!entityPersister.canExtractIdOutOfEntity()) {
            return super.isEqual(object, object2);
        }
        Class clazz = entityPersister.getMappedClass();
        Serializable serializable = object instanceof HibernateProxy ? ((HibernateProxy)object).getHibernateLazyInitializer().getIdentifier() : (clazz.isAssignableFrom(object.getClass()) ? entityPersister.getIdentifier(object) : (Serializable)object);
        Serializable serializable2 = object2 instanceof HibernateProxy ? ((HibernateProxy)object2).getHibernateLazyInitializer().getIdentifier() : (clazz.isAssignableFrom(object2.getClass()) ? entityPersister.getIdentifier(object2) : (Serializable)object2);
        return entityPersister.getIdentifierType().isEqual(serializable, serializable2, sessionFactoryImplementor);
    }

    public boolean isEmbeddedInXML() {
        return this.isEmbeddedInXML;
    }

    public boolean isXMLElement() {
        return this.isEmbeddedInXML;
    }

    public Object fromXMLNode(Node node, Mapping mapping) throws HibernateException {
        if (!this.isEmbeddedInXML) {
            return this.getIdentifierType(mapping).fromXMLNode(node, mapping);
        }
        return node;
    }

    public void setToXMLNode(Node node, Object object, SessionFactoryImplementor sessionFactoryImplementor) throws HibernateException {
        if (!this.isEmbeddedInXML) {
            this.getIdentifierType(sessionFactoryImplementor).setToXMLNode(node, object, sessionFactoryImplementor);
        } else {
            Element element = (Element)object;
            EntityType.replaceNode(node, new ElementWrapper(element));
        }
    }

    public String getOnCondition(String string, SessionFactoryImplementor sessionFactoryImplementor, Map map) throws MappingException {
        if (this.isReferenceToPrimaryKey()) {
            return "";
        }
        return this.getAssociatedJoinable(sessionFactoryImplementor).filterFragment(string, map);
    }

    public Object resolve(Object object, SessionImplementor sessionImplementor, Object object2) throws HibernateException {
        if (this.isNotEmbedded(sessionImplementor)) {
            return object;
        }
        if (object != null && !this.isNull(object2, sessionImplementor)) {
            if (this.isReferenceToPrimaryKey()) {
                return this.resolveIdentifier((Serializable)object, sessionImplementor);
            }
            if (this.uniqueKeyPropertyName != null) {
                return this.loadByUniqueKey(this.getAssociatedEntityName(), this.uniqueKeyPropertyName, object, sessionImplementor);
            }
        }
        return null;
    }

    public Type getSemiResolvedType(SessionFactoryImplementor sessionFactoryImplementor) {
        return sessionFactoryImplementor.getEntityPersister(this.associatedEntityName).getIdentifierType();
    }

    protected final Object getIdentifier(Object object, SessionImplementor sessionImplementor) throws HibernateException {
        if (this.isNotEmbedded(sessionImplementor)) {
            return object;
        }
        if (this.isReferenceToPrimaryKey() || this.uniqueKeyPropertyName == null) {
            return ForeignKeys.getEntityIdentifierIfNotUnsaved(this.getAssociatedEntityName(), object, sessionImplementor);
        }
        if (object == null) {
            return null;
        }
        EntityPersister entityPersister = sessionImplementor.getFactory().getEntityPersister(this.getAssociatedEntityName());
        Object object2 = entityPersister.getPropertyValue(object, this.uniqueKeyPropertyName);
        Type type = entityPersister.getPropertyType(this.uniqueKeyPropertyName);
        if (type.isEntityType()) {
            object2 = ((EntityType)type).getIdentifier(object2, sessionImplementor);
        }
        return object2;
    }

    @Deprecated
    protected boolean isNotEmbedded(SessionImplementor sessionImplementor) {
        return false;
    }

    public String toLoggableString(Object object, SessionFactoryImplementor sessionFactoryImplementor) {
        if (object == null) {
            return "null";
        }
        EntityPersister entityPersister = sessionFactoryImplementor.getEntityPersister(this.associatedEntityName);
        StringBuilder stringBuilder = new StringBuilder().append(this.associatedEntityName);
        if (entityPersister.hasIdentifierProperty()) {
            Serializable serializable;
            EntityMode entityMode = entityPersister.getEntityMode();
            if (entityMode == null) {
                if (this.isEmbeddedInXML) {
                    throw new ClassCastException(object.getClass().getName());
                }
                serializable = (Serializable)object;
            } else if (object instanceof HibernateProxy) {
                HibernateProxy hibernateProxy = (HibernateProxy)object;
                serializable = hibernateProxy.getHibernateLazyInitializer().getIdentifier();
            } else {
                serializable = entityPersister.getIdentifier(object);
            }
            stringBuilder.append('#').append(entityPersister.getIdentifierType().toLoggableString(serializable, sessionFactoryImplementor));
        }
        return stringBuilder.toString();
    }

    public abstract boolean isOneToOne();

    public boolean isLogicalOneToOne() {
        return this.isOneToOne();
    }

    Type getIdentifierType(Mapping mapping) {
        return mapping.getIdentifierType(this.getAssociatedEntityName());
    }

    Type getIdentifierType(SessionImplementor sessionImplementor) {
        return this.getIdentifierType(sessionImplementor.getFactory());
    }

    public final Type getIdentifierOrUniqueKeyType(Mapping mapping) throws MappingException {
        if (this.isReferenceToPrimaryKey() || this.uniqueKeyPropertyName == null) {
            return this.getIdentifierType(mapping);
        }
        Type type = mapping.getReferencedPropertyType(this.getAssociatedEntityName(), this.uniqueKeyPropertyName);
        if (type.isEntityType()) {
            type = ((EntityType)type).getIdentifierOrUniqueKeyType(mapping);
        }
        return type;
    }

    public final String getIdentifierOrUniqueKeyPropertyName(Mapping mapping) throws MappingException {
        if (this.isReferenceToPrimaryKey() || this.uniqueKeyPropertyName == null) {
            return mapping.getIdentifierPropertyName(this.getAssociatedEntityName());
        }
        return this.uniqueKeyPropertyName;
    }

    protected abstract boolean isNullable();

    protected final Object resolveIdentifier(Serializable serializable, SessionImplementor sessionImplementor) throws HibernateException {
        boolean bl = this.unwrapProxy && sessionImplementor.getFactory().getEntityPersister(this.getAssociatedEntityName()).isInstrumented();
        Object object = sessionImplementor.internalLoad(this.getAssociatedEntityName(), serializable, this.eager, this.isNullable() && !bl);
        if (object instanceof HibernateProxy) {
            ((HibernateProxy)object).getHibernateLazyInitializer().setUnwrap(bl);
        }
        return object;
    }

    protected boolean isNull(Object object, SessionImplementor sessionImplementor) {
        return false;
    }

    public Object loadByUniqueKey(String string, String string2, Object object, SessionImplementor sessionImplementor) throws HibernateException {
        SessionFactoryImplementor sessionFactoryImplementor = sessionImplementor.getFactory();
        UniqueKeyLoadable uniqueKeyLoadable = (UniqueKeyLoadable)sessionFactoryImplementor.getEntityPersister(string);
        EntityUniqueKey entityUniqueKey = new EntityUniqueKey(string, string2, object, this.getIdentifierOrUniqueKeyType(sessionFactoryImplementor), uniqueKeyLoadable.getEntityMode(), sessionImplementor.getFactory());
        PersistenceContext persistenceContext = sessionImplementor.getPersistenceContext();
        Object object2 = persistenceContext.getEntity(entityUniqueKey);
        if (object2 == null) {
            object2 = uniqueKeyLoadable.loadByUniqueKey(string2, object, sessionImplementor);
        }
        return object2 == null ? null : persistenceContext.proxyFor(object2);
    }
}

