/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.type.TimestampType;
import org.jboss.logging.Logger;

public class DbTimestampType
extends TimestampType {
    public static final DbTimestampType INSTANCE = new DbTimestampType();
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, DbTimestampType.class.getName());

    public String getName() {
        return "dbtimestamp";
    }

    public String[] getRegistrationKeys() {
        return new String[]{this.getName()};
    }

    public Date seed(SessionImplementor sessionImplementor) {
        if (sessionImplementor == null) {
            LOG.trace("Incoming session was null; using current jvm time");
            return super.seed(sessionImplementor);
        }
        if (!sessionImplementor.getFactory().getDialect().supportsCurrentTimestampSelection()) {
            LOG.debug("Falling back to vm-based timestamp, as dialect does not support current timestamp selection");
            return super.seed(sessionImplementor);
        }
        return this.getCurrentTimestamp(sessionImplementor);
    }

    private Date getCurrentTimestamp(SessionImplementor sessionImplementor) {
        Dialect dialect = sessionImplementor.getFactory().getDialect();
        String string = dialect.getCurrentTimestampSelectString();
        if (dialect.isCurrentTimestampSelectStringCallable()) {
            return this.useCallableStatement(string, sessionImplementor);
        }
        return this.usePreparedStatement(string, sessionImplementor);
    }

    private Timestamp usePreparedStatement(String string, SessionImplementor sessionImplementor) {
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = sessionImplementor.getTransactionCoordinator().getJdbcCoordinator().getStatementPreparer().prepareStatement(string, false);
            ResultSet resultSet = sessionImplementor.getTransactionCoordinator().getJdbcCoordinator().getResultSetReturn().extract(preparedStatement);
            resultSet.next();
            Timestamp timestamp = resultSet.getTimestamp(1);
            if (LOG.isTraceEnabled()) {
                LOG.tracev("Current timestamp retreived from db : {0} (nanos={1}, time={2})", (Object)timestamp, (Object)timestamp.getNanos(), (Object)timestamp.getTime());
            }
            Timestamp timestamp2 = timestamp;
            return timestamp2;
        }
        catch (SQLException sQLException) {
            throw sessionImplementor.getFactory().getSQLExceptionHelper().convert(sQLException, "could not select current db timestamp", string);
        }
        finally {
            if (preparedStatement != null) {
                sessionImplementor.getTransactionCoordinator().getJdbcCoordinator().release(preparedStatement);
            }
        }
    }

    private Timestamp useCallableStatement(String string, SessionImplementor sessionImplementor) {
        CallableStatement callableStatement = null;
        try {
            callableStatement = (CallableStatement)sessionImplementor.getTransactionCoordinator().getJdbcCoordinator().getStatementPreparer().prepareStatement(string, true);
            callableStatement.registerOutParameter(1, 93);
            sessionImplementor.getTransactionCoordinator().getJdbcCoordinator().getResultSetReturn().execute(callableStatement);
            Timestamp timestamp = callableStatement.getTimestamp(1);
            if (LOG.isTraceEnabled()) {
                LOG.tracev("Current timestamp retreived from db : {0} (nanos={1}, time={2})", (Object)timestamp, (Object)timestamp.getNanos(), (Object)timestamp.getTime());
            }
            Timestamp timestamp2 = timestamp;
            return timestamp2;
        }
        catch (SQLException sQLException) {
            throw sessionImplementor.getFactory().getSQLExceptionHelper().convert(sQLException, "could not call current db timestamp function", string);
        }
        finally {
            if (callableStatement != null) {
                sessionImplementor.getTransactionCoordinator().getJdbcCoordinator().release(callableStatement);
            }
        }
    }
}

