/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.util.Date;
import org.hibernate.dialect.Dialect;
import org.hibernate.type.AbstractSingleColumnStandardBasicType;
import org.hibernate.type.IdentifierType;
import org.hibernate.type.LiteralType;
import org.hibernate.type.StringType;
import org.hibernate.type.descriptor.java.JdbcDateTypeDescriptor;
import org.hibernate.type.descriptor.sql.DateTypeDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateType
extends AbstractSingleColumnStandardBasicType<Date>
implements IdentifierType<Date>,
LiteralType<Date> {
    public static final DateType INSTANCE = new DateType();

    public DateType() {
        super(DateTypeDescriptor.INSTANCE, JdbcDateTypeDescriptor.INSTANCE);
    }

    @Override
    public String getName() {
        return "date";
    }

    @Override
    public String[] getRegistrationKeys() {
        return new String[]{this.getName(), java.sql.Date.class.getName()};
    }

    @Override
    public String objectToSQLString(Date date, Dialect dialect) throws Exception {
        java.sql.Date date2 = java.sql.Date.class.isInstance(date) ? (java.sql.Date)date : new java.sql.Date(date.getTime());
        return StringType.INSTANCE.objectToSQLString(date2.toString(), dialect);
    }

    @Override
    public Date stringToObject(String string) {
        return (Date)this.fromString(string);
    }
}

