/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import org.dom4j.Node;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.Mapping;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.metamodel.relational.Size;
import org.hibernate.type.AbstractType;
import org.hibernate.type.BasicType;
import org.hibernate.type.DiscriminatorType;
import org.hibernate.type.IdentifierType;
import org.hibernate.type.StringRepresentableType;
import org.hibernate.type.VersionType;
import org.hibernate.usertype.EnhancedUserType;
import org.hibernate.usertype.LoggableUserType;
import org.hibernate.usertype.Sized;
import org.hibernate.usertype.UserType;
import org.hibernate.usertype.UserVersionType;

public class CustomType
extends AbstractType
implements IdentifierType,
DiscriminatorType,
VersionType,
BasicType,
StringRepresentableType {
    private final UserType userType;
    private final String name;
    private final int[] types;
    private final Size[] dictatedSizes;
    private final Size[] defaultSizes;
    private final boolean customLogging;
    private final String[] registrationKeys;

    public CustomType(UserType userType) throws MappingException {
        this(userType, ArrayHelper.EMPTY_STRING_ARRAY);
    }

    public CustomType(UserType userType, String[] stringArray) throws MappingException {
        this.userType = userType;
        this.name = userType.getClass().getName();
        this.types = userType.sqlTypes();
        this.dictatedSizes = Sized.class.isInstance(userType) ? ((Sized)((Object)userType)).dictatedSizes() : new Size[this.types.length];
        this.defaultSizes = Sized.class.isInstance(userType) ? ((Sized)((Object)userType)).defaultSizes() : new Size[this.types.length];
        this.customLogging = LoggableUserType.class.isInstance(userType);
        this.registrationKeys = stringArray;
    }

    public UserType getUserType() {
        return this.userType;
    }

    public String[] getRegistrationKeys() {
        return this.registrationKeys;
    }

    public int[] sqlTypes(Mapping mapping) {
        return this.types;
    }

    public Size[] dictatedSizes(Mapping mapping) throws MappingException {
        return this.dictatedSizes;
    }

    public Size[] defaultSizes(Mapping mapping) throws MappingException {
        return this.defaultSizes;
    }

    public int getColumnSpan(Mapping mapping) {
        return this.types.length;
    }

    public Class getReturnedClass() {
        return this.userType.returnedClass();
    }

    public boolean isEqual(Object object, Object object2) throws HibernateException {
        return this.userType.equals(object, object2);
    }

    public int getHashCode(Object object) {
        return this.userType.hashCode(object);
    }

    public Object nullSafeGet(ResultSet resultSet, String[] stringArray, SessionImplementor sessionImplementor, Object object) throws HibernateException, SQLException {
        return this.userType.nullSafeGet(resultSet, stringArray, sessionImplementor, object);
    }

    public Object nullSafeGet(ResultSet resultSet, String string, SessionImplementor sessionImplementor, Object object) throws HibernateException, SQLException {
        return this.nullSafeGet(resultSet, new String[]{string}, sessionImplementor, object);
    }

    public Object assemble(Serializable serializable, SessionImplementor sessionImplementor, Object object) throws HibernateException {
        return this.userType.assemble(serializable, object);
    }

    public Serializable disassemble(Object object, SessionImplementor sessionImplementor, Object object2) throws HibernateException {
        return this.userType.disassemble(object);
    }

    public Object replace(Object object, Object object2, SessionImplementor sessionImplementor, Object object3, Map map) throws HibernateException {
        return this.userType.replace(object, object2, object3);
    }

    public void nullSafeSet(PreparedStatement preparedStatement, Object object, int n, boolean[] blArray, SessionImplementor sessionImplementor) throws HibernateException, SQLException {
        if (blArray[0]) {
            this.userType.nullSafeSet(preparedStatement, object, n, sessionImplementor);
        }
    }

    public void nullSafeSet(PreparedStatement preparedStatement, Object object, int n, SessionImplementor sessionImplementor) throws HibernateException, SQLException {
        this.userType.nullSafeSet(preparedStatement, object, n, sessionImplementor);
    }

    public String toXMLString(Object object, SessionFactoryImplementor sessionFactoryImplementor) {
        return this.toString(object);
    }

    public Object fromXMLString(String string, Mapping mapping) {
        return this.fromStringValue(string);
    }

    public String getName() {
        return this.name;
    }

    public Object deepCopy(Object object, SessionFactoryImplementor sessionFactoryImplementor) throws HibernateException {
        return this.userType.deepCopy(object);
    }

    public boolean isMutable() {
        return this.userType.isMutable();
    }

    public Object stringToObject(String string) {
        return this.fromStringValue(string);
    }

    public String objectToSQLString(Object object, Dialect dialect) throws Exception {
        return ((EnhancedUserType)this.userType).objectToSQLString(object);
    }

    public Comparator getComparator() {
        return (Comparator)((Object)this.userType);
    }

    public Object next(Object object, SessionImplementor sessionImplementor) {
        return ((UserVersionType)this.userType).next(object, sessionImplementor);
    }

    public Object seed(SessionImplementor sessionImplementor) {
        return ((UserVersionType)this.userType).seed(sessionImplementor);
    }

    public Object fromXMLNode(Node node, Mapping mapping) throws HibernateException {
        return this.fromXMLString(node.getText(), mapping);
    }

    public void setToXMLNode(Node node, Object object, SessionFactoryImplementor sessionFactoryImplementor) throws HibernateException {
        node.setText(this.toXMLString(object, sessionFactoryImplementor));
    }

    public String toLoggableString(Object object, SessionFactoryImplementor sessionFactoryImplementor) throws HibernateException {
        if (object == null) {
            return "null";
        }
        if (this.customLogging) {
            return ((LoggableUserType)((Object)this.userType)).toLoggableString(object, sessionFactoryImplementor);
        }
        return this.toXMLString(object, sessionFactoryImplementor);
    }

    public boolean[] toColumnNullness(Object object, Mapping mapping) {
        boolean[] blArray = new boolean[this.getColumnSpan(mapping)];
        if (object != null) {
            Arrays.fill(blArray, true);
        }
        return blArray;
    }

    public boolean isDirty(Object object, Object object2, boolean[] blArray, SessionImplementor sessionImplementor) throws HibernateException {
        return blArray[0] && this.isDirty(object, object2, sessionImplementor);
    }

    public String toString(Object object) throws HibernateException {
        if (StringRepresentableType.class.isInstance(this.userType)) {
            return ((StringRepresentableType)((Object)this.userType)).toString(object);
        }
        if (object == null) {
            return null;
        }
        if (EnhancedUserType.class.isInstance(this.userType)) {
            return ((EnhancedUserType)this.userType).toXMLString(object);
        }
        return object.toString();
    }

    public Object fromStringValue(String string) throws HibernateException {
        if (StringRepresentableType.class.isInstance(this.userType)) {
            return ((StringRepresentableType)((Object)this.userType)).fromStringValue(string);
        }
        if (EnhancedUserType.class.isInstance(this.userType)) {
            return ((EnhancedUserType)this.userType).fromXMLString(string);
        }
        throw new HibernateException(String.format("Could not process #fromStringValue, UserType class [%s] did not implement %s or %s", this.name, StringRepresentableType.class.getName(), EnhancedUserType.class.getName()));
    }
}

