/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import org.dom4j.Element;
import org.dom4j.Node;
import org.hibernate.EntityMode;
import org.hibernate.FetchMode;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.engine.spi.CascadeStyle;
import org.hibernate.engine.spi.Mapping;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.metamodel.relational.Size;
import org.hibernate.type.AbstractType;
import org.hibernate.type.BasicType;
import org.hibernate.type.CompositeType;
import org.hibernate.type.Type;
import org.hibernate.usertype.CompositeUserType;
import org.hibernate.usertype.LoggableUserType;

public class CompositeCustomType
extends AbstractType
implements CompositeType,
BasicType {
    private final CompositeUserType userType;
    private final String[] registrationKeys;
    private final String name;
    private final boolean customLogging;

    public CompositeCustomType(CompositeUserType compositeUserType) {
        this(compositeUserType, ArrayHelper.EMPTY_STRING_ARRAY);
    }

    public CompositeCustomType(CompositeUserType compositeUserType, String[] stringArray) {
        this.userType = compositeUserType;
        this.name = compositeUserType.getClass().getName();
        this.customLogging = LoggableUserType.class.isInstance(compositeUserType);
        this.registrationKeys = stringArray;
    }

    public String[] getRegistrationKeys() {
        return this.registrationKeys;
    }

    public CompositeUserType getUserType() {
        return this.userType;
    }

    public boolean isMethodOf(Method method) {
        return false;
    }

    public Type[] getSubtypes() {
        return this.userType.getPropertyTypes();
    }

    public String[] getPropertyNames() {
        return this.userType.getPropertyNames();
    }

    public Object[] getPropertyValues(Object object, SessionImplementor sessionImplementor) throws HibernateException {
        return this.getPropertyValues(object, EntityMode.POJO);
    }

    public Object[] getPropertyValues(Object object, EntityMode entityMode) throws HibernateException {
        int n = this.getSubtypes().length;
        Object[] objectArray = new Object[n];
        for (int i = 0; i < n; ++i) {
            objectArray[i] = this.getPropertyValue(object, i);
        }
        return objectArray;
    }

    public void setPropertyValues(Object object, Object[] objectArray, EntityMode entityMode) throws HibernateException {
        for (int i = 0; i < objectArray.length; ++i) {
            this.userType.setPropertyValue(object, i, objectArray[i]);
        }
    }

    public Object getPropertyValue(Object object, int n, SessionImplementor sessionImplementor) throws HibernateException {
        return this.getPropertyValue(object, n);
    }

    public Object getPropertyValue(Object object, int n) throws HibernateException {
        return this.userType.getPropertyValue(object, n);
    }

    public CascadeStyle getCascadeStyle(int n) {
        return CascadeStyle.NONE;
    }

    public FetchMode getFetchMode(int n) {
        return FetchMode.DEFAULT;
    }

    public boolean isComponentType() {
        return true;
    }

    public Object deepCopy(Object object, SessionFactoryImplementor sessionFactoryImplementor) throws HibernateException {
        return this.userType.deepCopy(object);
    }

    public Object assemble(Serializable serializable, SessionImplementor sessionImplementor, Object object) throws HibernateException {
        return this.userType.assemble(serializable, sessionImplementor, object);
    }

    public Serializable disassemble(Object object, SessionImplementor sessionImplementor, Object object2) throws HibernateException {
        return this.userType.disassemble(object, sessionImplementor);
    }

    public Object replace(Object object, Object object2, SessionImplementor sessionImplementor, Object object3, Map map) throws HibernateException {
        return this.userType.replace(object, object2, sessionImplementor, object3);
    }

    public boolean isEqual(Object object, Object object2) throws HibernateException {
        return this.userType.equals(object, object2);
    }

    public int getHashCode(Object object) {
        return this.userType.hashCode(object);
    }

    public int getColumnSpan(Mapping mapping) throws MappingException {
        Type[] typeArray = this.userType.getPropertyTypes();
        int n = 0;
        for (Type type : typeArray) {
            n += type.getColumnSpan(mapping);
        }
        return n;
    }

    public String getName() {
        return this.name;
    }

    public Class getReturnedClass() {
        return this.userType.returnedClass();
    }

    public boolean isMutable() {
        return this.userType.isMutable();
    }

    public Object nullSafeGet(ResultSet resultSet, String string, SessionImplementor sessionImplementor, Object object) throws HibernateException, SQLException {
        return this.userType.nullSafeGet(resultSet, new String[]{string}, sessionImplementor, object);
    }

    public Object nullSafeGet(ResultSet resultSet, String[] stringArray, SessionImplementor sessionImplementor, Object object) throws HibernateException, SQLException {
        return this.userType.nullSafeGet(resultSet, stringArray, sessionImplementor, object);
    }

    public void nullSafeSet(PreparedStatement preparedStatement, Object object, int n, SessionImplementor sessionImplementor) throws HibernateException, SQLException {
        this.userType.nullSafeSet(preparedStatement, object, n, sessionImplementor);
    }

    public void nullSafeSet(PreparedStatement preparedStatement, Object object, int n, boolean[] blArray, SessionImplementor sessionImplementor) throws HibernateException, SQLException {
        this.userType.nullSafeSet(preparedStatement, object, n, sessionImplementor);
    }

    public int[] sqlTypes(Mapping mapping) throws MappingException {
        int[] nArray = new int[this.getColumnSpan(mapping)];
        int n = 0;
        for (Type type : this.userType.getPropertyTypes()) {
            for (int n2 : type.sqlTypes(mapping)) {
                nArray[n++] = n2;
            }
        }
        return nArray;
    }

    public Size[] dictatedSizes(Mapping mapping) throws MappingException {
        Size[] sizeArray = new Size[this.getColumnSpan(mapping)];
        int n = 0;
        for (Type type : this.userType.getPropertyTypes()) {
            Size[] sizeArray2 = type.dictatedSizes(mapping);
            System.arraycopy(sizeArray2, 0, sizeArray, n, sizeArray2.length);
            n += sizeArray2.length;
        }
        return sizeArray;
    }

    public Size[] defaultSizes(Mapping mapping) throws MappingException {
        Size[] sizeArray = new Size[this.getColumnSpan(mapping)];
        int n = 0;
        for (Type type : this.userType.getPropertyTypes()) {
            Size[] sizeArray2 = type.defaultSizes(mapping);
            System.arraycopy(sizeArray2, 0, sizeArray, n, sizeArray2.length);
            n += sizeArray2.length;
        }
        return sizeArray;
    }

    public String toLoggableString(Object object, SessionFactoryImplementor sessionFactoryImplementor) throws HibernateException {
        if (object == null) {
            return "null";
        }
        if (this.customLogging) {
            return ((LoggableUserType)((Object)this.userType)).toLoggableString(object, sessionFactoryImplementor);
        }
        return object.toString();
    }

    public boolean[] getPropertyNullability() {
        return null;
    }

    public Object fromXMLNode(Node node, Mapping mapping) throws HibernateException {
        return node;
    }

    public void setToXMLNode(Node node, Object object, SessionFactoryImplementor sessionFactoryImplementor) throws HibernateException {
        CompositeCustomType.replaceNode(node, (Element)object);
    }

    public boolean[] toColumnNullness(Object object, Mapping mapping) {
        boolean[] blArray = new boolean[this.getColumnSpan(mapping)];
        if (object == null) {
            return blArray;
        }
        Object[] objectArray = this.getPropertyValues(object, EntityMode.POJO);
        int n = 0;
        Type[] typeArray = this.getSubtypes();
        for (int i = 0; i < typeArray.length; ++i) {
            boolean[] blArray2 = typeArray[i].toColumnNullness(objectArray[i], mapping);
            System.arraycopy(blArray2, 0, blArray, n, blArray2.length);
            n += blArray2.length;
        }
        return blArray;
    }

    public boolean isDirty(Object object, Object object2, boolean[] blArray, SessionImplementor sessionImplementor) throws HibernateException {
        return this.isDirty(object, object2, sessionImplementor);
    }

    public boolean isEmbedded() {
        return false;
    }
}

