/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.dom4j.Element;
import org.dom4j.Node;
import org.hibernate.EntityMode;
import org.hibernate.FetchMode;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.PropertyNotFoundException;
import org.hibernate.engine.spi.CascadeStyle;
import org.hibernate.engine.spi.Mapping;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.metamodel.relational.Size;
import org.hibernate.tuple.StandardProperty;
import org.hibernate.tuple.component.ComponentMetamodel;
import org.hibernate.tuple.component.ComponentTuplizer;
import org.hibernate.type.AbstractType;
import org.hibernate.type.CompositeType;
import org.hibernate.type.ForeignKeyDirection;
import org.hibernate.type.Type;
import org.hibernate.type.TypeFactory;
import org.hibernate.type.TypeHelper;

public class ComponentType
extends AbstractType
implements CompositeType {
    private final TypeFactory.TypeScope typeScope;
    private final String[] propertyNames;
    private final Type[] propertyTypes;
    private final boolean[] propertyNullability;
    protected final int propertySpan;
    private final CascadeStyle[] cascade;
    private final FetchMode[] joinedFetch;
    private final boolean isKey;
    protected final EntityMode entityMode;
    protected final ComponentTuplizer componentTuplizer;

    public ComponentType(TypeFactory.TypeScope typeScope, ComponentMetamodel componentMetamodel) {
        this.typeScope = typeScope;
        this.isKey = componentMetamodel.isKey();
        this.propertySpan = componentMetamodel.getPropertySpan();
        this.propertyNames = new String[this.propertySpan];
        this.propertyTypes = new Type[this.propertySpan];
        this.propertyNullability = new boolean[this.propertySpan];
        this.cascade = new CascadeStyle[this.propertySpan];
        this.joinedFetch = new FetchMode[this.propertySpan];
        for (int i = 0; i < this.propertySpan; ++i) {
            StandardProperty standardProperty = componentMetamodel.getProperty(i);
            this.propertyNames[i] = standardProperty.getName();
            this.propertyTypes[i] = standardProperty.getType();
            this.propertyNullability[i] = standardProperty.isNullable();
            this.cascade[i] = standardProperty.getCascadeStyle();
            this.joinedFetch[i] = standardProperty.getFetchMode();
        }
        this.entityMode = componentMetamodel.getEntityMode();
        this.componentTuplizer = componentMetamodel.getComponentTuplizer();
    }

    public boolean isKey() {
        return this.isKey;
    }

    public EntityMode getEntityMode() {
        return this.entityMode;
    }

    public ComponentTuplizer getComponentTuplizer() {
        return this.componentTuplizer;
    }

    public int getColumnSpan(Mapping mapping) throws MappingException {
        int n = 0;
        for (int i = 0; i < this.propertySpan; ++i) {
            n += this.propertyTypes[i].getColumnSpan(mapping);
        }
        return n;
    }

    public int[] sqlTypes(Mapping mapping) throws MappingException {
        int[] nArray = new int[this.getColumnSpan(mapping)];
        int n = 0;
        for (int i = 0; i < this.propertySpan; ++i) {
            int[] nArray2;
            for (int n2 : nArray2 = this.propertyTypes[i].sqlTypes(mapping)) {
                nArray[n++] = n2;
            }
        }
        return nArray;
    }

    public Size[] dictatedSizes(Mapping mapping) throws MappingException {
        Size[] sizeArray = new Size[this.getColumnSpan(mapping)];
        int n = 0;
        for (Type type : this.propertyTypes) {
            Size[] sizeArray2 = type.dictatedSizes(mapping);
            System.arraycopy(sizeArray2, 0, sizeArray, n, sizeArray2.length);
            n += sizeArray2.length;
        }
        return sizeArray;
    }

    public Size[] defaultSizes(Mapping mapping) throws MappingException {
        Size[] sizeArray = new Size[this.getColumnSpan(mapping)];
        int n = 0;
        for (Type type : this.propertyTypes) {
            Size[] sizeArray2 = type.defaultSizes(mapping);
            System.arraycopy(sizeArray2, 0, sizeArray, n, sizeArray2.length);
            n += sizeArray2.length;
        }
        return sizeArray;
    }

    public final boolean isComponentType() {
        return true;
    }

    public Class getReturnedClass() {
        return this.componentTuplizer.getMappedClass();
    }

    public boolean isSame(Object object, Object object2) throws HibernateException {
        if (object == object2) {
            return true;
        }
        if (object == null || object2 == null) {
            return false;
        }
        Object[] objectArray = this.getPropertyValues(object, this.entityMode);
        Object[] objectArray2 = this.getPropertyValues(object2, this.entityMode);
        for (int i = 0; i < this.propertySpan; ++i) {
            if (this.propertyTypes[i].isSame(objectArray[i], objectArray2[i])) continue;
            return false;
        }
        return true;
    }

    public boolean isEqual(Object object, Object object2) throws HibernateException {
        if (object == object2) {
            return true;
        }
        if (object == null || object2 == null) {
            return false;
        }
        Object[] objectArray = this.getPropertyValues(object, this.entityMode);
        Object[] objectArray2 = this.getPropertyValues(object2, this.entityMode);
        for (int i = 0; i < this.propertySpan; ++i) {
            if (this.propertyTypes[i].isEqual(objectArray[i], objectArray2[i])) continue;
            return false;
        }
        return true;
    }

    public boolean isEqual(Object object, Object object2, SessionFactoryImplementor sessionFactoryImplementor) throws HibernateException {
        if (object == object2) {
            return true;
        }
        if (object == null || object2 == null) {
            return false;
        }
        Object[] objectArray = this.getPropertyValues(object, this.entityMode);
        Object[] objectArray2 = this.getPropertyValues(object2, this.entityMode);
        for (int i = 0; i < this.propertySpan; ++i) {
            if (this.propertyTypes[i].isEqual(objectArray[i], objectArray2[i], sessionFactoryImplementor)) continue;
            return false;
        }
        return true;
    }

    public int compare(Object object, Object object2) {
        if (object == object2) {
            return 0;
        }
        Object[] objectArray = this.getPropertyValues(object, this.entityMode);
        Object[] objectArray2 = this.getPropertyValues(object2, this.entityMode);
        for (int i = 0; i < this.propertySpan; ++i) {
            int n = this.propertyTypes[i].compare(objectArray[i], objectArray2[i]);
            if (n == 0) continue;
            return n;
        }
        return 0;
    }

    public boolean isMethodOf(Method method) {
        return false;
    }

    public int getHashCode(Object object) {
        int n = 17;
        Object[] objectArray = this.getPropertyValues(object, this.entityMode);
        for (int i = 0; i < this.propertySpan; ++i) {
            Object object2 = objectArray[i];
            n *= 37;
            if (object2 == null) continue;
            n += this.propertyTypes[i].getHashCode(object2);
        }
        return n;
    }

    public int getHashCode(Object object, SessionFactoryImplementor sessionFactoryImplementor) {
        int n = 17;
        Object[] objectArray = this.getPropertyValues(object, this.entityMode);
        for (int i = 0; i < this.propertySpan; ++i) {
            Object object2 = objectArray[i];
            n *= 37;
            if (object2 == null) continue;
            n += this.propertyTypes[i].getHashCode(object2, sessionFactoryImplementor);
        }
        return n;
    }

    public boolean isDirty(Object object, Object object2, SessionImplementor sessionImplementor) throws HibernateException {
        if (object == object2) {
            return false;
        }
        if (object == null || object2 == null) {
            return true;
        }
        Object[] objectArray = this.getPropertyValues(object, this.entityMode);
        Object[] objectArray2 = this.getPropertyValues(object2, this.entityMode);
        for (int i = 0; i < objectArray.length; ++i) {
            if (!this.propertyTypes[i].isDirty(objectArray[i], objectArray2[i], sessionImplementor)) continue;
            return true;
        }
        return false;
    }

    public boolean isDirty(Object object, Object object2, boolean[] blArray, SessionImplementor sessionImplementor) throws HibernateException {
        if (object == object2) {
            return false;
        }
        if (object == null || object2 == null) {
            return true;
        }
        Object[] objectArray = this.getPropertyValues(object, this.entityMode);
        Object[] objectArray2 = this.getPropertyValues(object2, this.entityMode);
        int n = 0;
        for (int i = 0; i < objectArray.length; ++i) {
            int n2 = this.propertyTypes[i].getColumnSpan(sessionImplementor.getFactory());
            if (n2 <= 1) {
                boolean bl;
                boolean bl2 = bl = (n2 == 0 || blArray[n]) && this.propertyTypes[i].isDirty(objectArray[i], objectArray2[i], sessionImplementor);
                if (bl) {
                    return true;
                }
            } else {
                boolean[] blArray2 = new boolean[n2];
                System.arraycopy(blArray, n, blArray2, 0, n2);
                boolean bl = this.propertyTypes[i].isDirty(objectArray[i], objectArray2[i], blArray2, sessionImplementor);
                if (bl) {
                    return true;
                }
            }
            n += n2;
        }
        return false;
    }

    public boolean isModified(Object object, Object object2, boolean[] blArray, SessionImplementor sessionImplementor) throws HibernateException {
        if (object2 == null) {
            return object != null;
        }
        if (object == null) {
            return true;
        }
        Object[] objectArray = this.getPropertyValues(object2, sessionImplementor);
        Object[] objectArray2 = (Object[])object;
        int n = 0;
        for (int i = 0; i < objectArray.length; ++i) {
            int n2 = this.propertyTypes[i].getColumnSpan(sessionImplementor.getFactory());
            boolean[] blArray2 = new boolean[n2];
            System.arraycopy(blArray, n, blArray2, 0, n2);
            if (this.propertyTypes[i].isModified(objectArray2[i], objectArray[i], blArray2, sessionImplementor)) {
                return true;
            }
            n += n2;
        }
        return false;
    }

    public Object nullSafeGet(ResultSet resultSet, String[] stringArray, SessionImplementor sessionImplementor, Object object) throws HibernateException, SQLException {
        return this.resolve(this.hydrate(resultSet, stringArray, sessionImplementor, object), sessionImplementor, object);
    }

    public void nullSafeSet(PreparedStatement preparedStatement, Object object, int n, SessionImplementor sessionImplementor) throws HibernateException, SQLException {
        Object[] objectArray = this.nullSafeGetValues(object, this.entityMode);
        for (int i = 0; i < this.propertySpan; ++i) {
            this.propertyTypes[i].nullSafeSet(preparedStatement, objectArray[i], n, sessionImplementor);
            n += this.propertyTypes[i].getColumnSpan(sessionImplementor.getFactory());
        }
    }

    public void nullSafeSet(PreparedStatement preparedStatement, Object object, int n, boolean[] blArray, SessionImplementor sessionImplementor) throws HibernateException, SQLException {
        Object[] objectArray = this.nullSafeGetValues(object, this.entityMode);
        int n2 = 0;
        for (int i = 0; i < this.propertySpan; ++i) {
            int n3 = this.propertyTypes[i].getColumnSpan(sessionImplementor.getFactory());
            if (n3 != 0) {
                if (n3 == 1) {
                    if (blArray[n2]) {
                        this.propertyTypes[i].nullSafeSet(preparedStatement, objectArray[i], n, sessionImplementor);
                        ++n;
                    }
                } else {
                    boolean[] blArray2 = new boolean[n3];
                    System.arraycopy(blArray, n2, blArray2, 0, n3);
                    this.propertyTypes[i].nullSafeSet(preparedStatement, objectArray[i], n, blArray2, sessionImplementor);
                    n += ArrayHelper.countTrue(blArray2);
                }
            }
            n2 += n3;
        }
    }

    private Object[] nullSafeGetValues(Object object, EntityMode entityMode) throws HibernateException {
        if (object == null) {
            return new Object[this.propertySpan];
        }
        return this.getPropertyValues(object, entityMode);
    }

    public Object nullSafeGet(ResultSet resultSet, String string, SessionImplementor sessionImplementor, Object object) throws HibernateException, SQLException {
        return this.nullSafeGet(resultSet, new String[]{string}, sessionImplementor, object);
    }

    public Object getPropertyValue(Object object, int n, SessionImplementor sessionImplementor) throws HibernateException {
        return this.getPropertyValue(object, n, this.entityMode);
    }

    public Object getPropertyValue(Object object, int n, EntityMode entityMode) throws HibernateException {
        return this.componentTuplizer.getPropertyValue(object, n);
    }

    public Object[] getPropertyValues(Object object, SessionImplementor sessionImplementor) throws HibernateException {
        return this.getPropertyValues(object, this.entityMode);
    }

    public Object[] getPropertyValues(Object object, EntityMode entityMode) throws HibernateException {
        if (object instanceof Object[]) {
            return (Object[])object;
        }
        return this.componentTuplizer.getPropertyValues(object);
    }

    public void setPropertyValues(Object object, Object[] objectArray, EntityMode entityMode) throws HibernateException {
        this.componentTuplizer.setPropertyValues(object, objectArray);
    }

    public Type[] getSubtypes() {
        return this.propertyTypes;
    }

    public String getName() {
        return "component" + ArrayHelper.toString(this.propertyNames);
    }

    public String toLoggableString(Object object, SessionFactoryImplementor sessionFactoryImplementor) throws HibernateException {
        if (object == null) {
            return "null";
        }
        if (this.entityMode == null) {
            throw new ClassCastException(object.getClass().getName());
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Object[] objectArray = this.getPropertyValues(object, this.entityMode);
        for (int i = 0; i < this.propertyTypes.length; ++i) {
            hashMap.put(this.propertyNames[i], this.propertyTypes[i].toLoggableString(objectArray[i], sessionFactoryImplementor));
        }
        return StringHelper.unqualify(this.getName()) + ((Object)hashMap).toString();
    }

    public String[] getPropertyNames() {
        return this.propertyNames;
    }

    public Object deepCopy(Object object, SessionFactoryImplementor sessionFactoryImplementor) throws HibernateException {
        if (object == null) {
            return null;
        }
        Object[] objectArray = this.getPropertyValues(object, this.entityMode);
        for (int i = 0; i < this.propertySpan; ++i) {
            objectArray[i] = this.propertyTypes[i].deepCopy(objectArray[i], sessionFactoryImplementor);
        }
        Object object2 = this.instantiate(this.entityMode);
        this.setPropertyValues(object2, objectArray, this.entityMode);
        if (this.componentTuplizer.hasParentProperty()) {
            this.componentTuplizer.setParent(object2, this.componentTuplizer.getParent(object), sessionFactoryImplementor);
        }
        return object2;
    }

    public Object replace(Object object, Object object2, SessionImplementor sessionImplementor, Object object3, Map map) throws HibernateException {
        if (object == null) {
            return null;
        }
        Object object4 = object2 == null ? this.instantiate(object3, sessionImplementor) : object2;
        Object[] objectArray = TypeHelper.replace(this.getPropertyValues(object, this.entityMode), this.getPropertyValues(object4, this.entityMode), this.propertyTypes, sessionImplementor, object3, map);
        this.setPropertyValues(object4, objectArray, this.entityMode);
        return object4;
    }

    public Object replace(Object object, Object object2, SessionImplementor sessionImplementor, Object object3, Map map, ForeignKeyDirection foreignKeyDirection) throws HibernateException {
        if (object == null) {
            return null;
        }
        Object object4 = object2 == null ? this.instantiate(object3, sessionImplementor) : object2;
        Object[] objectArray = TypeHelper.replace(this.getPropertyValues(object, this.entityMode), this.getPropertyValues(object4, this.entityMode), this.propertyTypes, sessionImplementor, object3, map, foreignKeyDirection);
        this.setPropertyValues(object4, objectArray, this.entityMode);
        return object4;
    }

    public Object instantiate(EntityMode entityMode) throws HibernateException {
        return this.componentTuplizer.instantiate();
    }

    public Object instantiate(Object object, SessionImplementor sessionImplementor) throws HibernateException {
        Object object2 = this.instantiate(this.entityMode);
        if (this.componentTuplizer.hasParentProperty() && object != null) {
            this.componentTuplizer.setParent(object2, sessionImplementor.getPersistenceContext().proxyFor(object), sessionImplementor.getFactory());
        }
        return object2;
    }

    public CascadeStyle getCascadeStyle(int n) {
        return this.cascade[n];
    }

    public boolean isMutable() {
        return true;
    }

    public Serializable disassemble(Object object, SessionImplementor sessionImplementor, Object object2) throws HibernateException {
        if (object == null) {
            return null;
        }
        Object[] objectArray = this.getPropertyValues(object, this.entityMode);
        for (int i = 0; i < this.propertyTypes.length; ++i) {
            objectArray[i] = this.propertyTypes[i].disassemble(objectArray[i], sessionImplementor, object2);
        }
        return objectArray;
    }

    public Object assemble(Serializable serializable, SessionImplementor sessionImplementor, Object object) throws HibernateException {
        if (serializable == null) {
            return null;
        }
        Object[] objectArray = (Object[])serializable;
        Object[] objectArray2 = new Object[objectArray.length];
        for (int i = 0; i < this.propertyTypes.length; ++i) {
            objectArray2[i] = this.propertyTypes[i].assemble((Serializable)objectArray[i], sessionImplementor, object);
        }
        Object object2 = this.instantiate(object, sessionImplementor);
        this.setPropertyValues(object2, objectArray2, this.entityMode);
        return object2;
    }

    public FetchMode getFetchMode(int n) {
        return this.joinedFetch[n];
    }

    public Object hydrate(ResultSet resultSet, String[] stringArray, SessionImplementor sessionImplementor, Object object) throws HibernateException, SQLException {
        int n = 0;
        boolean bl = false;
        Object[] objectArray = new Object[this.propertySpan];
        for (int i = 0; i < this.propertySpan; ++i) {
            int n2 = this.propertyTypes[i].getColumnSpan(sessionImplementor.getFactory());
            String[] stringArray2 = ArrayHelper.slice(stringArray, n, n2);
            Object object2 = this.propertyTypes[i].hydrate(resultSet, stringArray2, sessionImplementor, object);
            if (object2 == null) {
                if (this.isKey) {
                    return null;
                }
            } else {
                bl = true;
            }
            objectArray[i] = object2;
            n += n2;
        }
        return bl ? objectArray : null;
    }

    public Object resolve(Object object, SessionImplementor sessionImplementor, Object object2) throws HibernateException {
        if (object != null) {
            Object object3 = this.instantiate(object2, sessionImplementor);
            Object[] objectArray = (Object[])object;
            Object[] objectArray2 = new Object[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray2[i] = this.propertyTypes[i].resolve(objectArray[i], sessionImplementor, object2);
            }
            this.setPropertyValues(object3, objectArray2, this.entityMode);
            return object3;
        }
        return null;
    }

    public Object semiResolve(Object object, SessionImplementor sessionImplementor, Object object2) throws HibernateException {
        return this.resolve(object, sessionImplementor, object2);
    }

    public boolean[] getPropertyNullability() {
        return this.propertyNullability;
    }

    public boolean isXMLElement() {
        return true;
    }

    public Object fromXMLNode(Node node, Mapping mapping) throws HibernateException {
        return node;
    }

    public void setToXMLNode(Node node, Object object, SessionFactoryImplementor sessionFactoryImplementor) throws HibernateException {
        ComponentType.replaceNode(node, (Element)object);
    }

    public boolean[] toColumnNullness(Object object, Mapping mapping) {
        boolean[] blArray = new boolean[this.getColumnSpan(mapping)];
        if (object == null) {
            return blArray;
        }
        Object[] objectArray = this.getPropertyValues(object, EntityMode.POJO);
        int n = 0;
        for (int i = 0; i < this.propertyTypes.length; ++i) {
            boolean[] blArray2 = this.propertyTypes[i].toColumnNullness(objectArray[i], mapping);
            System.arraycopy(blArray2, 0, blArray, n, blArray2.length);
            n += blArray2.length;
        }
        return blArray;
    }

    public boolean isEmbedded() {
        return false;
    }

    public int getPropertyIndex(String string) {
        String[] stringArray = this.getPropertyNames();
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            if (!stringArray[i].equals(string)) continue;
            return i;
        }
        throw new PropertyNotFoundException("Unable to locate property named " + string + " on " + this.getReturnedClass().getName());
    }
}

