/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import org.dom4j.Node;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.cfg.Environment;
import org.hibernate.engine.jdbc.LobCreator;
import org.hibernate.engine.spi.Mapping;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.metamodel.relational.Size;
import org.hibernate.type.BasicType;
import org.hibernate.type.ForeignKeyDirection;
import org.hibernate.type.StringRepresentableType;
import org.hibernate.type.Type;
import org.hibernate.type.XmlRepresentableType;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.descriptor.java.MutabilityPlan;
import org.hibernate.type.descriptor.sql.SqlTypeDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractStandardBasicType<T>
implements BasicType,
StringRepresentableType<T>,
XmlRepresentableType<T> {
    private static final Size DEFAULT_SIZE = new Size(19, 2, 255L, Size.LobMultiplier.NONE);
    private final Size dictatedSize = new Size();
    private SqlTypeDescriptor sqlTypeDescriptor;
    private JavaTypeDescriptor<T> javaTypeDescriptor;

    public AbstractStandardBasicType(SqlTypeDescriptor sqlTypeDescriptor, JavaTypeDescriptor<T> javaTypeDescriptor) {
        this.sqlTypeDescriptor = sqlTypeDescriptor;
        this.javaTypeDescriptor = javaTypeDescriptor;
    }

    public T fromString(String string) {
        return this.javaTypeDescriptor.fromString(string);
    }

    @Override
    public String toString(T t) {
        return this.javaTypeDescriptor.toString(t);
    }

    @Override
    public T fromStringValue(String string) throws HibernateException {
        return this.fromString(string);
    }

    @Override
    public String toXMLString(T t, SessionFactoryImplementor sessionFactoryImplementor) throws HibernateException {
        return this.toString(t);
    }

    @Override
    public T fromXMLString(String string, Mapping mapping) throws HibernateException {
        return StringHelper.isEmpty(string) ? null : (T)this.fromStringValue(string);
    }

    protected MutabilityPlan<T> getMutabilityPlan() {
        return this.javaTypeDescriptor.getMutabilityPlan();
    }

    protected T getReplacement(T t, T t2, SessionImplementor sessionImplementor) {
        if (!this.isMutable()) {
            return t;
        }
        if (this.isEqual(t, t2)) {
            return t;
        }
        return this.deepCopy(t);
    }

    @Override
    public boolean[] toColumnNullness(Object object, Mapping mapping) {
        return object == null ? ArrayHelper.FALSE : ArrayHelper.TRUE;
    }

    @Override
    public String[] getRegistrationKeys() {
        String[] stringArray;
        if (this.registerUnderJavaType()) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = this.getName();
            stringArray = stringArray2;
            stringArray2[1] = this.javaTypeDescriptor.getJavaTypeClass().getName();
        } else {
            String[] stringArray3 = new String[1];
            stringArray = stringArray3;
            stringArray3[0] = this.getName();
        }
        return stringArray;
    }

    protected boolean registerUnderJavaType() {
        return false;
    }

    protected static Size getDefaultSize() {
        return DEFAULT_SIZE;
    }

    protected Size getDictatedSize() {
        return this.dictatedSize;
    }

    public final JavaTypeDescriptor<T> getJavaTypeDescriptor() {
        return this.javaTypeDescriptor;
    }

    public final void setJavaTypeDescriptor(JavaTypeDescriptor<T> javaTypeDescriptor) {
        this.javaTypeDescriptor = javaTypeDescriptor;
    }

    public final SqlTypeDescriptor getSqlTypeDescriptor() {
        return this.sqlTypeDescriptor;
    }

    public final void setSqlTypeDescriptor(SqlTypeDescriptor sqlTypeDescriptor) {
        this.sqlTypeDescriptor = sqlTypeDescriptor;
    }

    @Override
    public final Class getReturnedClass() {
        return this.javaTypeDescriptor.getJavaTypeClass();
    }

    @Override
    public final int getColumnSpan(Mapping mapping) throws MappingException {
        return this.sqlTypes(mapping).length;
    }

    @Override
    public final int[] sqlTypes(Mapping mapping) throws MappingException {
        return new int[]{this.sqlTypeDescriptor.getSqlType()};
    }

    @Override
    public Size[] dictatedSizes(Mapping mapping) throws MappingException {
        return new Size[]{this.getDictatedSize()};
    }

    @Override
    public Size[] defaultSizes(Mapping mapping) throws MappingException {
        return new Size[]{AbstractStandardBasicType.getDefaultSize()};
    }

    @Override
    public final boolean isAssociationType() {
        return false;
    }

    @Override
    public final boolean isCollectionType() {
        return false;
    }

    @Override
    public final boolean isComponentType() {
        return false;
    }

    @Override
    public final boolean isEntityType() {
        return false;
    }

    @Override
    public final boolean isAnyType() {
        return false;
    }

    @Override
    public final boolean isXMLElement() {
        return false;
    }

    @Override
    public final boolean isSame(Object object, Object object2) {
        return this.isEqual(object, object2);
    }

    @Override
    public final boolean isEqual(Object object, Object object2, SessionFactoryImplementor sessionFactoryImplementor) {
        return this.isEqual(object, object2);
    }

    @Override
    public final boolean isEqual(Object object, Object object2) {
        return this.javaTypeDescriptor.areEqual(object, object2);
    }

    @Override
    public final int getHashCode(Object object) {
        return this.javaTypeDescriptor.extractHashCode(object);
    }

    @Override
    public final int getHashCode(Object object, SessionFactoryImplementor sessionFactoryImplementor) {
        return this.getHashCode(object);
    }

    @Override
    public final int compare(Object object, Object object2) {
        return this.javaTypeDescriptor.getComparator().compare(object, object2);
    }

    @Override
    public final boolean isDirty(Object object, Object object2, SessionImplementor sessionImplementor) {
        return this.isDirty(object, object2);
    }

    @Override
    public final boolean isDirty(Object object, Object object2, boolean[] blArray, SessionImplementor sessionImplementor) {
        return blArray[0] && this.isDirty(object, object2);
    }

    protected final boolean isDirty(Object object, Object object2) {
        return !this.isSame(object, object2);
    }

    @Override
    public final boolean isModified(Object object, Object object2, boolean[] blArray, SessionImplementor sessionImplementor) {
        return this.isDirty(object, object2);
    }

    @Override
    public final Object nullSafeGet(ResultSet resultSet, String[] stringArray, SessionImplementor sessionImplementor, Object object) throws SQLException {
        return this.nullSafeGet(resultSet, stringArray[0], sessionImplementor);
    }

    @Override
    public final Object nullSafeGet(ResultSet resultSet, String string, SessionImplementor sessionImplementor, Object object) throws SQLException {
        return this.nullSafeGet(resultSet, string, sessionImplementor);
    }

    public final T nullSafeGet(ResultSet resultSet, String string, SessionImplementor sessionImplementor) throws SQLException {
        WrapperOptions wrapperOptions = this.getOptions(sessionImplementor);
        return this.nullSafeGet(resultSet, string, wrapperOptions);
    }

    protected final T nullSafeGet(ResultSet resultSet, String string, WrapperOptions wrapperOptions) throws SQLException {
        return this.remapSqlTypeDescriptor(wrapperOptions).getExtractor(this.javaTypeDescriptor).extract(resultSet, string, wrapperOptions);
    }

    public Object get(ResultSet resultSet, String string, SessionImplementor sessionImplementor) throws HibernateException, SQLException {
        return this.nullSafeGet(resultSet, string, sessionImplementor);
    }

    @Override
    public final void nullSafeSet(PreparedStatement preparedStatement, Object object, int n, SessionImplementor sessionImplementor) throws SQLException {
        WrapperOptions wrapperOptions = this.getOptions(sessionImplementor);
        this.nullSafeSet(preparedStatement, object, n, wrapperOptions);
    }

    protected final void nullSafeSet(PreparedStatement preparedStatement, Object object, int n, WrapperOptions wrapperOptions) throws SQLException {
        this.remapSqlTypeDescriptor(wrapperOptions).getBinder(this.javaTypeDescriptor).bind(preparedStatement, object, n, wrapperOptions);
    }

    protected SqlTypeDescriptor remapSqlTypeDescriptor(WrapperOptions wrapperOptions) {
        return wrapperOptions.remapSqlTypeDescriptor(this.sqlTypeDescriptor);
    }

    public void set(PreparedStatement preparedStatement, T t, int n, SessionImplementor sessionImplementor) throws HibernateException, SQLException {
        this.nullSafeSet(preparedStatement, t, n, sessionImplementor);
    }

    @Override
    public final String toLoggableString(Object object, SessionFactoryImplementor sessionFactoryImplementor) {
        return this.javaTypeDescriptor.extractLoggableRepresentation(object);
    }

    @Override
    public final void setToXMLNode(Node node, Object object, SessionFactoryImplementor sessionFactoryImplementor) {
        node.setText(this.toString(object));
    }

    @Override
    public final Object fromXMLNode(Node node, Mapping mapping) {
        return this.fromString(node.getText());
    }

    @Override
    public final boolean isMutable() {
        return this.getMutabilityPlan().isMutable();
    }

    @Override
    public final Object deepCopy(Object object, SessionFactoryImplementor sessionFactoryImplementor) {
        return this.deepCopy(object);
    }

    protected final T deepCopy(T t) {
        return this.getMutabilityPlan().deepCopy(t);
    }

    @Override
    public final Serializable disassemble(Object object, SessionImplementor sessionImplementor, Object object2) throws HibernateException {
        return this.getMutabilityPlan().disassemble(object);
    }

    @Override
    public final Object assemble(Serializable serializable, SessionImplementor sessionImplementor, Object object) throws HibernateException {
        return this.getMutabilityPlan().assemble(serializable);
    }

    @Override
    public final void beforeAssemble(Serializable serializable, SessionImplementor sessionImplementor) {
    }

    @Override
    public final Object hydrate(ResultSet resultSet, String[] stringArray, SessionImplementor sessionImplementor, Object object) throws HibernateException, SQLException {
        return this.nullSafeGet(resultSet, stringArray, sessionImplementor, object);
    }

    @Override
    public final Object resolve(Object object, SessionImplementor sessionImplementor, Object object2) throws HibernateException {
        return object;
    }

    @Override
    public final Object semiResolve(Object object, SessionImplementor sessionImplementor, Object object2) throws HibernateException {
        return object;
    }

    @Override
    public final Type getSemiResolvedType(SessionFactoryImplementor sessionFactoryImplementor) {
        return this;
    }

    @Override
    public final Object replace(Object object, Object object2, SessionImplementor sessionImplementor, Object object3, Map map) {
        return this.getReplacement(object, object2, sessionImplementor);
    }

    @Override
    public Object replace(Object object, Object object2, SessionImplementor sessionImplementor, Object object3, Map map, ForeignKeyDirection foreignKeyDirection) {
        return ForeignKeyDirection.FOREIGN_KEY_FROM_PARENT == foreignKeyDirection ? this.getReplacement(object, object2, sessionImplementor) : object2;
    }

    private WrapperOptions getOptions(final SessionImplementor sessionImplementor) {
        return new WrapperOptions(){

            public boolean useStreamForLobBinding() {
                return Environment.useStreamsForBinary() || sessionImplementor.getFactory().getDialect().useInputStreamToInsertBlob();
            }

            public LobCreator getLobCreator() {
                return Hibernate.getLobCreator(sessionImplementor);
            }

            public SqlTypeDescriptor remapSqlTypeDescriptor(SqlTypeDescriptor sqlTypeDescriptor) {
                SqlTypeDescriptor sqlTypeDescriptor2 = sqlTypeDescriptor.canBeRemapped() ? sessionImplementor.getFactory().getDialect().remapSqlTypeDescriptor(sqlTypeDescriptor) : sqlTypeDescriptor;
                return sqlTypeDescriptor2 == null ? sqlTypeDescriptor : sqlTypeDescriptor2;
            }
        };
    }
}

