/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Comparator;
import org.hibernate.HibernateException;
import org.hibernate.cfg.Environment;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.type.MutableType;
import org.hibernate.type.VersionType;

public abstract class AbstractBynaryType
extends MutableType
implements VersionType,
Comparator {
    protected abstract Object toExternalFormat(byte[] var1);

    protected abstract byte[] toInternalFormat(Object var1);

    public void set(PreparedStatement preparedStatement, Object object, int n) throws HibernateException, SQLException {
        byte[] byArray = this.toInternalFormat(object);
        if (Environment.useStreamsForBinary()) {
            preparedStatement.setBinaryStream(n, (InputStream)new ByteArrayInputStream(byArray), byArray.length);
        } else {
            preparedStatement.setBytes(n, byArray);
        }
    }

    public Object get(ResultSet resultSet, String string) throws HibernateException, SQLException {
        if (Environment.useStreamsForBinary()) {
            InputStream inputStream = resultSet.getBinaryStream(string);
            if (inputStream == null) {
                return this.toExternalFormat(null);
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(2048);
            byte[] byArray = new byte[2048];
            try {
                int n;
                while ((n = inputStream.read(byArray)) != -1) {
                    byteArrayOutputStream.write(byArray, 0, n);
                }
                inputStream.close();
                byteArrayOutputStream.close();
            }
            catch (IOException iOException) {
                throw new HibernateException("IOException occurred reading a binary value", iOException);
            }
            return this.toExternalFormat(byteArrayOutputStream.toByteArray());
        }
        return this.toExternalFormat(resultSet.getBytes(string));
    }

    public int sqlType() {
        return -3;
    }

    public Object seed(SessionImplementor sessionImplementor) {
        return null;
    }

    public Object next(Object object, SessionImplementor sessionImplementor) {
        return object;
    }

    public Comparator getComparator() {
        return this;
    }

    public boolean isEqual(Object object, Object object2) {
        return object == object2 || object != null && object2 != null && Arrays.equals(this.toInternalFormat(object), this.toInternalFormat(object2));
    }

    public int getHashCode(Object object) {
        byte[] byArray = this.toInternalFormat(object);
        int n = 1;
        for (int i = 0; i < byArray.length; ++i) {
            n = 31 * n + byArray[i];
        }
        return n;
    }

    public int compare(Object object, Object object2) {
        byte[] byArray;
        byte[] byArray2 = this.toInternalFormat(object);
        if (byArray2.length < (byArray = this.toInternalFormat(object2)).length) {
            return -1;
        }
        if (byArray2.length > byArray.length) {
            return 1;
        }
        for (int i = 0; i < byArray2.length; ++i) {
            if (byArray2[i] < byArray[i]) {
                return -1;
            }
            if (byArray2[i] <= byArray[i]) continue;
            return 1;
        }
        return 0;
    }

    public abstract String getName();

    public String toString(Object object) {
        byte[] byArray = this.toInternalFormat(object);
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < byArray.length; ++i) {
            String string = Integer.toHexString(byArray[i] - -128);
            if (string.length() == 1) {
                stringBuilder.append('0');
            }
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public Object deepCopyNotNull(Object object) {
        byte[] byArray = this.toInternalFormat(object);
        byte[] byArray2 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        return this.toExternalFormat(byArray2);
    }

    public Object fromStringValue(String string) throws HibernateException {
        if (string == null) {
            return null;
        }
        if (string.length() % 2 != 0) {
            throw new IllegalArgumentException("The string is not a valid xml representation of a binary content.");
        }
        byte[] byArray = new byte[string.length() / 2];
        for (int i = 0; i < byArray.length; ++i) {
            String string2 = string.substring(i * 2, (i + 1) * 2);
            byArray[i] = (byte)(Integer.parseInt(string2, 16) + -128);
        }
        return this.toExternalFormat(byArray);
    }
}

