/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tuple.entity;

import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.hibernate.EntityMode;
import org.hibernate.EntityNameResolver;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.PropertyNotFoundException;
import org.hibernate.bytecode.instrumentation.internal.FieldInterceptionHelper;
import org.hibernate.bytecode.instrumentation.spi.FieldInterceptor;
import org.hibernate.bytecode.spi.ReflectionOptimizer;
import org.hibernate.cfg.Environment;
import org.hibernate.classic.Lifecycle;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Subclass;
import org.hibernate.metamodel.binding.AttributeBinding;
import org.hibernate.metamodel.binding.EntityBinding;
import org.hibernate.property.Getter;
import org.hibernate.property.PropertyAccessor;
import org.hibernate.property.PropertyAccessorFactory;
import org.hibernate.property.Setter;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.ProxyFactory;
import org.hibernate.tuple.Instantiator;
import org.hibernate.tuple.PojoInstantiator;
import org.hibernate.tuple.entity.AbstractEntityTuplizer;
import org.hibernate.tuple.entity.EntityMetamodel;
import org.hibernate.type.CompositeType;
import org.jboss.logging.Logger;

public class PojoEntityTuplizer
extends AbstractEntityTuplizer {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, PojoEntityTuplizer.class.getName());
    private final Class mappedClass;
    private final Class proxyInterface;
    private final boolean lifecycleImplementor;
    private final Set lazyPropertyNames = new HashSet();
    private final ReflectionOptimizer optimizer;
    private final boolean isInstrumented;

    public PojoEntityTuplizer(EntityMetamodel entityMetamodel, PersistentClass persistentClass) {
        super(entityMetamodel, persistentClass);
        String[] stringArray;
        this.mappedClass = persistentClass.getMappedClass();
        this.proxyInterface = persistentClass.getProxyInterface();
        this.lifecycleImplementor = Lifecycle.class.isAssignableFrom(this.mappedClass);
        this.isInstrumented = entityMetamodel.isInstrumented();
        Iterator iterator = persistentClass.getPropertyClosureIterator();
        while (iterator.hasNext()) {
            stringArray = (String[])iterator.next();
            if (!stringArray.isLazy()) continue;
            this.lazyPropertyNames.add(stringArray.getName());
        }
        stringArray = new String[this.propertySpan];
        String[] stringArray2 = new String[this.propertySpan];
        Class[] classArray = new Class[this.propertySpan];
        for (int i = 0; i < this.propertySpan; ++i) {
            stringArray[i] = this.getters[i].getMethodName();
            stringArray2[i] = this.setters[i].getMethodName();
            classArray[i] = this.getters[i].getReturnType();
        }
        this.optimizer = this.hasCustomAccessors || !Environment.useReflectionOptimizer() ? null : Environment.getBytecodeProvider().getReflectionOptimizer(this.mappedClass, stringArray, stringArray2, classArray);
    }

    public PojoEntityTuplizer(EntityMetamodel entityMetamodel, EntityBinding entityBinding) {
        super(entityMetamodel, entityBinding);
        this.mappedClass = entityBinding.getEntity().getClassReference();
        this.proxyInterface = entityBinding.getProxyInterfaceType().getValue();
        this.lifecycleImplementor = Lifecycle.class.isAssignableFrom(this.mappedClass);
        this.isInstrumented = entityMetamodel.isInstrumented();
        for (AttributeBinding stringArray2 : entityBinding.getAttributeBindingClosure()) {
            if (!stringArray2.isLazy()) continue;
            this.lazyPropertyNames.add(stringArray2.getAttribute().getName());
        }
        String[] stringArray3 = new String[this.propertySpan];
        String[] stringArray = new String[this.propertySpan];
        Class[] classArray = new Class[this.propertySpan];
        for (int i = 0; i < this.propertySpan; ++i) {
            stringArray3[i] = this.getters[i].getMethodName();
            stringArray[i] = this.setters[i].getMethodName();
            classArray[i] = this.getters[i].getReturnType();
        }
        this.optimizer = this.hasCustomAccessors || !Environment.useReflectionOptimizer() ? null : Environment.getBytecodeProvider().getReflectionOptimizer(this.mappedClass, stringArray3, stringArray, classArray);
    }

    protected ProxyFactory buildProxyFactory(PersistentClass persistentClass, Getter getter, Setter setter) {
        Method method;
        Object object;
        Class clazz;
        Object object2;
        LinkedHashSet<Class<HibernateProxy>> linkedHashSet = new LinkedHashSet<Class<HibernateProxy>>();
        Class clazz2 = persistentClass.getMappedClass();
        Class clazz3 = persistentClass.getProxyInterface();
        if (clazz3 != null && !clazz2.equals(clazz3)) {
            if (!clazz3.isInterface()) {
                throw new MappingException("proxy must be either an interface, or the class itself: " + this.getEntityName());
            }
            linkedHashSet.add(clazz3);
        }
        if (clazz2.isInterface()) {
            linkedHashSet.add(clazz2);
        }
        Iterator iterator = persistentClass.getSubclassIterator();
        while (iterator.hasNext()) {
            object2 = (Subclass)iterator.next();
            clazz = ((PersistentClass)object2).getProxyInterface();
            object = ((PersistentClass)object2).getMappedClass();
            if (clazz == null || object.equals(clazz)) continue;
            if (!clazz.isInterface()) {
                throw new MappingException("proxy must be either an interface, or the class itself: " + ((PersistentClass)object2).getEntityName());
            }
            linkedHashSet.add(clazz);
        }
        linkedHashSet.add(HibernateProxy.class);
        object2 = persistentClass.getPropertyIterator();
        clazz = persistentClass.getMappedClass();
        while (object2.hasNext()) {
            object = (Property)object2.next();
            method = ((Property)object).getGetter(clazz).getMethod();
            if (method != null && Modifier.isFinal(method.getModifiers())) {
                LOG.gettersOfLazyClassesCannotBeFinal(persistentClass.getEntityName(), ((Property)object).getName());
            }
            if ((method = ((Property)object).getSetter(clazz).getMethod()) == null || !Modifier.isFinal(method.getModifiers())) continue;
            LOG.settersOfLazyClassesCannotBeFinal(persistentClass.getEntityName(), ((Property)object).getName());
        }
        object = getter == null ? null : getter.getMethod();
        method = setter == null ? null : setter.getMethod();
        Method method2 = object == null || clazz3 == null ? null : ReflectHelper.getMethod(clazz3, (Method)object);
        Method method3 = method == null || clazz3 == null ? null : ReflectHelper.getMethod(clazz3, method);
        ProxyFactory proxyFactory = this.buildProxyFactoryInternal(persistentClass, getter, setter);
        try {
            proxyFactory.postInstantiate(this.getEntityName(), clazz2, linkedHashSet, method2, method3, persistentClass.hasEmbeddedIdentifier() ? (CompositeType)persistentClass.getIdentifier().getType() : null);
        }
        catch (HibernateException hibernateException) {
            LOG.unableToCreateProxyFactory(this.getEntityName(), hibernateException);
            proxyFactory = null;
        }
        return proxyFactory;
    }

    protected ProxyFactory buildProxyFactoryInternal(PersistentClass persistentClass, Getter getter, Setter setter) {
        return Environment.getBytecodeProvider().getProxyFactoryFactory().buildProxyFactory();
    }

    protected Instantiator buildInstantiator(PersistentClass persistentClass) {
        if (this.optimizer == null) {
            return new PojoInstantiator(persistentClass, null);
        }
        return new PojoInstantiator(persistentClass, this.optimizer.getInstantiationOptimizer());
    }

    protected ProxyFactory buildProxyFactory(EntityBinding entityBinding, Getter getter, Setter setter) {
        Class<?> clazz;
        GenericDeclaration genericDeclaration;
        HashSet<GenericDeclaration> hashSet = new HashSet<GenericDeclaration>();
        hashSet.add((GenericDeclaration)((Object)HibernateProxy.class));
        Class<?> clazz2 = entityBinding.getEntity().getClassReference();
        Class<?> clazz3 = entityBinding.getProxyInterfaceType().getValue();
        if (clazz3 != null && !clazz2.equals(clazz3)) {
            if (!clazz3.isInterface()) {
                throw new MappingException("proxy must be either an interface, or the class itself: " + this.getEntityName());
            }
            hashSet.add(clazz3);
        }
        if (clazz2.isInterface()) {
            hashSet.add(clazz2);
        }
        for (EntityBinding object2 : entityBinding.getPostOrderSubEntityBindingClosure()) {
            genericDeclaration = object2.getProxyInterfaceType().getValue();
            clazz = object2.getClassReference();
            if (genericDeclaration == null || clazz.equals(genericDeclaration)) continue;
            if (!((Class)genericDeclaration).isInterface()) {
                throw new MappingException("proxy must be either an interface, or the class itself: " + object2.getEntity().getName());
            }
            hashSet.add(genericDeclaration);
        }
        for (AttributeBinding attributeBinding : entityBinding.attributeBindings()) {
            genericDeclaration = this.getGetter(attributeBinding).getMethod();
            if (genericDeclaration != null && Modifier.isFinal(((Method)genericDeclaration).getModifiers())) {
                LOG.gettersOfLazyClassesCannotBeFinal(entityBinding.getEntity().getName(), attributeBinding.getAttribute().getName());
            }
            if ((genericDeclaration = this.getSetter(attributeBinding).getMethod()) == null || !Modifier.isFinal(((Method)genericDeclaration).getModifiers())) continue;
            LOG.settersOfLazyClassesCannotBeFinal(entityBinding.getEntity().getName(), attributeBinding.getAttribute().getName());
        }
        Method method = getter == null ? null : getter.getMethod();
        Method method2 = setter == null ? null : setter.getMethod();
        genericDeclaration = method == null || clazz3 == null ? null : ReflectHelper.getMethod(clazz3, method);
        clazz = method2 == null || clazz3 == null ? null : ReflectHelper.getMethod(clazz3, method2);
        ProxyFactory proxyFactory = this.buildProxyFactoryInternal(entityBinding, getter, setter);
        try {
            proxyFactory.postInstantiate(this.getEntityName(), clazz2, hashSet, (Method)genericDeclaration, (Method)((Object)clazz), entityBinding.getHierarchyDetails().getEntityIdentifier().isEmbedded() ? (CompositeType)entityBinding.getHierarchyDetails().getEntityIdentifier().getValueBinding().getHibernateTypeDescriptor().getResolvedTypeMapping() : null);
        }
        catch (HibernateException hibernateException) {
            LOG.unableToCreateProxyFactory(this.getEntityName(), hibernateException);
            proxyFactory = null;
        }
        return proxyFactory;
    }

    protected ProxyFactory buildProxyFactoryInternal(EntityBinding entityBinding, Getter getter, Setter setter) {
        return Environment.getBytecodeProvider().getProxyFactoryFactory().buildProxyFactory();
    }

    protected Instantiator buildInstantiator(EntityBinding entityBinding) {
        if (this.optimizer == null) {
            return new PojoInstantiator(entityBinding, null);
        }
        return new PojoInstantiator(entityBinding, this.optimizer.getInstantiationOptimizer());
    }

    public void setPropertyValues(Object object, Object[] objectArray) throws HibernateException {
        if (!this.getEntityMetamodel().hasLazyProperties() && this.optimizer != null && this.optimizer.getAccessOptimizer() != null) {
            this.setPropertyValuesWithOptimizer(object, objectArray);
        } else {
            super.setPropertyValues(object, objectArray);
        }
    }

    public Object[] getPropertyValues(Object object) throws HibernateException {
        if (this.shouldGetAllProperties(object) && this.optimizer != null && this.optimizer.getAccessOptimizer() != null) {
            return this.getPropertyValuesWithOptimizer(object);
        }
        return super.getPropertyValues(object);
    }

    public Object[] getPropertyValuesToInsert(Object object, Map map, SessionImplementor sessionImplementor) throws HibernateException {
        if (this.shouldGetAllProperties(object) && this.optimizer != null && this.optimizer.getAccessOptimizer() != null) {
            return this.getPropertyValuesWithOptimizer(object);
        }
        return super.getPropertyValuesToInsert(object, map, sessionImplementor);
    }

    protected void setPropertyValuesWithOptimizer(Object object, Object[] objectArray) {
        this.optimizer.getAccessOptimizer().setPropertyValues(object, objectArray);
    }

    protected Object[] getPropertyValuesWithOptimizer(Object object) {
        return this.optimizer.getAccessOptimizer().getPropertyValues(object);
    }

    public EntityMode getEntityMode() {
        return EntityMode.POJO;
    }

    public Class getMappedClass() {
        return this.mappedClass;
    }

    public boolean isLifecycleImplementor() {
        return this.lifecycleImplementor;
    }

    protected Getter buildPropertyGetter(Property property, PersistentClass persistentClass) {
        return property.getGetter(persistentClass.getMappedClass());
    }

    protected Setter buildPropertySetter(Property property, PersistentClass persistentClass) {
        return property.getSetter(persistentClass.getMappedClass());
    }

    protected Getter buildPropertyGetter(AttributeBinding attributeBinding) {
        return this.getGetter(attributeBinding);
    }

    protected Setter buildPropertySetter(AttributeBinding attributeBinding) {
        return this.getSetter(attributeBinding);
    }

    private Getter getGetter(AttributeBinding attributeBinding) throws PropertyNotFoundException, MappingException {
        return this.getPropertyAccessor(attributeBinding).getGetter(attributeBinding.getContainer().getClassReference(), attributeBinding.getAttribute().getName());
    }

    private Setter getSetter(AttributeBinding attributeBinding) throws PropertyNotFoundException, MappingException {
        return this.getPropertyAccessor(attributeBinding).getSetter(attributeBinding.getContainer().getClassReference(), attributeBinding.getAttribute().getName());
    }

    private PropertyAccessor getPropertyAccessor(AttributeBinding attributeBinding) throws MappingException {
        return PropertyAccessorFactory.getPropertyAccessor(attributeBinding.getContainer().getClassReference(), attributeBinding.getPropertyAccessorName());
    }

    public Class getConcreteProxyClass() {
        return this.proxyInterface;
    }

    public void afterInitialize(Object object, boolean bl, SessionImplementor sessionImplementor) {
        if (this.isInstrumented()) {
            Set set = bl && this.getEntityMetamodel().hasLazyProperties() ? this.lazyPropertyNames : null;
            FieldInterceptionHelper.injectFieldInterceptor(object, this.getEntityName(), set, sessionImplementor);
        }
    }

    public boolean hasUninitializedLazyProperties(Object object) {
        if (this.getEntityMetamodel().hasLazyProperties()) {
            FieldInterceptor fieldInterceptor = FieldInterceptionHelper.extractFieldInterceptor(object);
            return fieldInterceptor != null && !fieldInterceptor.isInitialized();
        }
        return false;
    }

    public boolean isInstrumented() {
        return this.isInstrumented;
    }

    public String determineConcreteSubclassEntityName(Object object, SessionFactoryImplementor sessionFactoryImplementor) {
        Class<?> clazz = object.getClass();
        if (clazz == this.getMappedClass()) {
            return this.getEntityName();
        }
        String string = this.getEntityMetamodel().findEntityNameByEntityClass(clazz);
        if (string == null) {
            throw new HibernateException("Unable to resolve entity name from Class [" + clazz.getName() + "]" + " expected instance/subclass of [" + this.getEntityName() + "]");
        }
        return string;
    }

    public EntityNameResolver[] getEntityNameResolvers() {
        return null;
    }
}

