/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tuple.entity;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.metamodel.binding.EntityBinding;
import org.hibernate.tuple.entity.DynamicMapEntityTuplizer;
import org.hibernate.tuple.entity.EntityMetamodel;
import org.hibernate.tuple.entity.EntityTuplizer;
import org.hibernate.tuple.entity.PojoEntityTuplizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityTuplizerFactory
implements Serializable {
    public static final Class[] ENTITY_TUP_CTOR_SIG = new Class[]{EntityMetamodel.class, PersistentClass.class};
    public static final Class[] ENTITY_TUP_CTOR_SIG_NEW = new Class[]{EntityMetamodel.class, EntityBinding.class};
    private Map<EntityMode, Class<? extends EntityTuplizer>> defaultImplClassByMode = EntityTuplizerFactory.buildBaseMapping();

    public void registerDefaultTuplizerClass(EntityMode entityMode, Class<? extends EntityTuplizer> clazz) {
        assert (this.isEntityTuplizerImplementor(clazz)) : "Specified tuplizer class [" + clazz.getName() + "] does not implement " + EntityTuplizer.class.getName();
        assert (this.hasProperConstructor(clazz, ENTITY_TUP_CTOR_SIG)) : "Specified tuplizer class [" + clazz.getName() + "] is not properly instantiatable";
        assert (this.hasProperConstructor(clazz, ENTITY_TUP_CTOR_SIG_NEW)) : "Specified tuplizer class [" + clazz.getName() + "] is not properly instantiatable";
        this.defaultImplClassByMode.put(entityMode, clazz);
    }

    public EntityTuplizer constructTuplizer(String string, EntityMetamodel entityMetamodel, PersistentClass persistentClass) {
        try {
            Class clazz = ReflectHelper.classForName(string);
            return this.constructTuplizer((Class<? extends EntityTuplizer>)clazz, entityMetamodel, persistentClass);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new HibernateException("Could not locate specified tuplizer class [" + string + "]");
        }
    }

    public EntityTuplizer constructTuplizer(String string, EntityMetamodel entityMetamodel, EntityBinding entityBinding) {
        try {
            Class clazz = ReflectHelper.classForName(string);
            return this.constructTuplizer((Class<? extends EntityTuplizer>)clazz, entityMetamodel, entityBinding);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new HibernateException("Could not locate specified tuplizer class [" + string + "]");
        }
    }

    public EntityTuplizer constructTuplizer(Class<? extends EntityTuplizer> clazz, EntityMetamodel entityMetamodel, PersistentClass persistentClass) {
        Constructor<? extends EntityTuplizer> constructor = this.getProperConstructor(clazz, ENTITY_TUP_CTOR_SIG);
        assert (constructor != null) : "Unable to locate proper constructor for tuplizer [" + clazz.getName() + "]";
        try {
            return constructor.newInstance(entityMetamodel, persistentClass);
        }
        catch (Throwable throwable) {
            throw new HibernateException("Unable to instantiate default tuplizer [" + clazz.getName() + "]", throwable);
        }
    }

    public EntityTuplizer constructTuplizer(Class<? extends EntityTuplizer> clazz, EntityMetamodel entityMetamodel, EntityBinding entityBinding) {
        Constructor<? extends EntityTuplizer> constructor = this.getProperConstructor(clazz, ENTITY_TUP_CTOR_SIG_NEW);
        assert (constructor != null) : "Unable to locate proper constructor for tuplizer [" + clazz.getName() + "]";
        try {
            return constructor.newInstance(entityMetamodel, entityBinding);
        }
        catch (Throwable throwable) {
            throw new HibernateException("Unable to instantiate default tuplizer [" + clazz.getName() + "]", throwable);
        }
    }

    public EntityTuplizer constructDefaultTuplizer(EntityMode entityMode, EntityMetamodel entityMetamodel, PersistentClass persistentClass) {
        Class<? extends EntityTuplizer> clazz = this.defaultImplClassByMode.get((Object)entityMode);
        if (clazz == null) {
            throw new HibernateException("could not determine default tuplizer class to use [" + (Object)((Object)entityMode) + "]");
        }
        return this.constructTuplizer(clazz, entityMetamodel, persistentClass);
    }

    public EntityTuplizer constructDefaultTuplizer(EntityMode entityMode, EntityMetamodel entityMetamodel, EntityBinding entityBinding) {
        Class<? extends EntityTuplizer> clazz = this.defaultImplClassByMode.get((Object)entityMode);
        if (clazz == null) {
            throw new HibernateException("could not determine default tuplizer class to use [" + (Object)((Object)entityMode) + "]");
        }
        return this.constructTuplizer(clazz, entityMetamodel, entityBinding);
    }

    private boolean isEntityTuplizerImplementor(Class clazz) {
        return ReflectHelper.implementsInterface(clazz, EntityTuplizer.class);
    }

    private boolean hasProperConstructor(Class<? extends EntityTuplizer> clazz, Class[] classArray) {
        return this.getProperConstructor(clazz, classArray) != null && !ReflectHelper.isAbstractClass(clazz);
    }

    private Constructor<? extends EntityTuplizer> getProperConstructor(Class<? extends EntityTuplizer> clazz, Class[] classArray) {
        Constructor<? extends EntityTuplizer> constructor = null;
        try {
            constructor = clazz.getDeclaredConstructor(classArray);
            if (!ReflectHelper.isPublic(constructor)) {
                try {
                    constructor.setAccessible(true);
                }
                catch (SecurityException securityException) {
                    constructor = null;
                }
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return constructor;
    }

    private static Map<EntityMode, Class<? extends EntityTuplizer>> buildBaseMapping() {
        ConcurrentHashMap<EntityMode, Class<? extends EntityTuplizer>> concurrentHashMap = new ConcurrentHashMap<EntityMode, Class<? extends EntityTuplizer>>();
        concurrentHashMap.put(EntityMode.POJO, PojoEntityTuplizer.class);
        concurrentHashMap.put(EntityMode.MAP, DynamicMapEntityTuplizer.class);
        return concurrentHashMap;
    }
}

