/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tuple.entity;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.bytecode.spi.EntityInstrumentationMetadata;
import org.hibernate.cfg.Environment;
import org.hibernate.engine.OptimisticLockStyle;
import org.hibernate.engine.spi.CascadeStyle;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.ValueInclusion;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.PropertyGeneration;
import org.hibernate.metamodel.binding.AttributeBinding;
import org.hibernate.metamodel.binding.BasicAttributeBinding;
import org.hibernate.metamodel.binding.EntityBinding;
import org.hibernate.metamodel.domain.Attribute;
import org.hibernate.metamodel.domain.SingularAttribute;
import org.hibernate.tuple.IdentifierProperty;
import org.hibernate.tuple.PropertyFactory;
import org.hibernate.tuple.StandardProperty;
import org.hibernate.tuple.VersionProperty;
import org.hibernate.tuple.entity.EntityTuplizer;
import org.hibernate.tuple.entity.EntityTuplizerFactory;
import org.hibernate.tuple.entity.NonPojoInstrumentationMetadata;
import org.hibernate.type.AssociationType;
import org.hibernate.type.CompositeType;
import org.hibernate.type.EntityType;
import org.hibernate.type.Type;
import org.jboss.logging.Logger;

public class EntityMetamodel
implements Serializable {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, EntityMetamodel.class.getName());
    private static final int NO_VERSION_INDX = -66;
    private final SessionFactoryImplementor sessionFactory;
    private final String name;
    private final String rootName;
    private final EntityType entityType;
    private final IdentifierProperty identifierProperty;
    private final boolean versioned;
    private final int propertySpan;
    private final int versionPropertyIndex;
    private final StandardProperty[] properties;
    private final String[] propertyNames;
    private final Type[] propertyTypes;
    private final boolean[] propertyLaziness;
    private final boolean[] propertyUpdateability;
    private final boolean[] nonlazyPropertyUpdateability;
    private final boolean[] propertyCheckability;
    private final boolean[] propertyInsertability;
    private final ValueInclusion[] insertInclusions;
    private final ValueInclusion[] updateInclusions;
    private final boolean[] propertyNullability;
    private final boolean[] propertyVersionability;
    private final CascadeStyle[] cascadeStyles;
    private final boolean hasInsertGeneratedValues;
    private final boolean hasUpdateGeneratedValues;
    private final Map<String, Integer> propertyIndexes = new HashMap<String, Integer>();
    private final boolean hasCollections;
    private final boolean hasMutableProperties;
    private final boolean hasLazyProperties;
    private final boolean hasNonIdentifierPropertyNamedId;
    private final int[] naturalIdPropertyNumbers;
    private final boolean hasImmutableNaturalId;
    private final boolean hasCacheableNaturalId;
    private boolean lazy;
    private final boolean hasCascades;
    private final boolean mutable;
    private final boolean isAbstract;
    private final boolean selectBeforeUpdate;
    private final boolean dynamicUpdate;
    private final boolean dynamicInsert;
    private final OptimisticLockStyle optimisticLockStyle;
    private final boolean polymorphic;
    private final String superclass;
    private final boolean explicitPolymorphism;
    private final boolean inherited;
    private final boolean hasSubclasses;
    private final Set subclassEntityNames = new HashSet();
    private final Map entityNameByInheritenceClassMap = new HashMap();
    private final EntityMode entityMode;
    private final EntityTuplizer entityTuplizer;
    private final EntityInstrumentationMetadata instrumentationMetadata;

    public EntityMetamodel(PersistentClass persistentClass, SessionFactoryImplementor sessionFactoryImplementor) {
        boolean bl;
        this.sessionFactory = sessionFactoryImplementor;
        this.name = persistentClass.getEntityName();
        this.rootName = persistentClass.getRootClass().getEntityName();
        this.entityType = sessionFactoryImplementor.getTypeResolver().getTypeFactory().manyToOne(this.name);
        this.identifierProperty = PropertyFactory.buildIdentifierProperty(persistentClass, sessionFactoryImplementor.getIdentifierGenerator(this.rootName));
        this.versioned = persistentClass.isVersioned();
        this.instrumentationMetadata = persistentClass.hasPojoRepresentation() ? Environment.getBytecodeProvider().getEntityInstrumentationMetadata(persistentClass.getMappedClass()) : new NonPojoInstrumentationMetadata(persistentClass.getEntityName());
        boolean bl2 = false;
        this.propertySpan = persistentClass.getPropertyClosureSpan();
        this.properties = new StandardProperty[this.propertySpan];
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        this.propertyNames = new String[this.propertySpan];
        this.propertyTypes = new Type[this.propertySpan];
        this.propertyUpdateability = new boolean[this.propertySpan];
        this.propertyInsertability = new boolean[this.propertySpan];
        this.insertInclusions = new ValueInclusion[this.propertySpan];
        this.updateInclusions = new ValueInclusion[this.propertySpan];
        this.nonlazyPropertyUpdateability = new boolean[this.propertySpan];
        this.propertyCheckability = new boolean[this.propertySpan];
        this.propertyNullability = new boolean[this.propertySpan];
        this.propertyVersionability = new boolean[this.propertySpan];
        this.propertyLaziness = new boolean[this.propertySpan];
        this.cascadeStyles = new CascadeStyle[this.propertySpan];
        Iterator iterator = persistentClass.getPropertyClosureIterator();
        int n = 0;
        int n2 = -66;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        boolean bl8 = false;
        boolean bl9 = false;
        while (iterator.hasNext()) {
            boolean bl10;
            Property property = (Property)iterator.next();
            if (property == persistentClass.getVersion()) {
                n2 = n;
                this.properties[n] = PropertyFactory.buildVersionProperty(property, this.instrumentationMetadata.isInstrumented());
            } else {
                this.properties[n] = PropertyFactory.buildStandardProperty(property, this.instrumentationMetadata.isInstrumented());
            }
            if (property.isNaturalIdentifier()) {
                arrayList.add(n);
                if (property.isUpdateable()) {
                    bl9 = true;
                }
            }
            if ("id".equals(property.getName())) {
                bl6 = true;
            }
            boolean bl11 = bl10 = property.isLazy() && this.instrumentationMetadata.isInstrumented();
            if (bl10) {
                bl2 = true;
            }
            this.propertyLaziness[n] = bl10;
            this.propertyNames[n] = this.properties[n].getName();
            this.propertyTypes[n] = this.properties[n].getType();
            this.propertyNullability[n] = this.properties[n].isNullable();
            this.propertyUpdateability[n] = this.properties[n].isUpdateable();
            this.propertyInsertability[n] = this.properties[n].isInsertable();
            this.insertInclusions[n] = this.determineInsertValueGenerationType(property, this.properties[n]);
            this.updateInclusions[n] = this.determineUpdateValueGenerationType(property, this.properties[n]);
            this.propertyVersionability[n] = this.properties[n].isVersionable();
            this.nonlazyPropertyUpdateability[n] = this.properties[n].isUpdateable() && !bl10;
            this.propertyCheckability[n] = this.propertyUpdateability[n] || this.propertyTypes[n].isAssociationType() && ((AssociationType)this.propertyTypes[n]).isAlwaysDirtyChecked();
            this.cascadeStyles[n] = this.properties[n].getCascadeStyle();
            if (this.properties[n].isLazy()) {
                bl2 = true;
            }
            if (this.properties[n].getCascadeStyle() != CascadeStyle.NONE) {
                bl3 = true;
            }
            if (this.indicatesCollection(this.properties[n].getType())) {
                bl4 = true;
            }
            if (this.propertyTypes[n].isMutable() && this.propertyCheckability[n]) {
                bl5 = true;
            }
            if (this.insertInclusions[n] != ValueInclusion.NONE) {
                bl7 = true;
            }
            if (this.updateInclusions[n] != ValueInclusion.NONE) {
                bl8 = true;
            }
            this.mapPropertyToIndex(property, n);
            ++n;
        }
        if (arrayList.size() == 0) {
            this.naturalIdPropertyNumbers = null;
            this.hasImmutableNaturalId = false;
            this.hasCacheableNaturalId = false;
        } else {
            this.naturalIdPropertyNumbers = ArrayHelper.toIntArray(arrayList);
            this.hasImmutableNaturalId = !bl9;
            this.hasCacheableNaturalId = persistentClass.getNaturalIdCacheRegionName() != null;
        }
        this.hasInsertGeneratedValues = bl7;
        this.hasUpdateGeneratedValues = bl8;
        this.hasCascades = bl3;
        this.hasNonIdentifierPropertyNamedId = bl6;
        this.versionPropertyIndex = n2;
        this.hasLazyProperties = bl2;
        if (this.hasLazyProperties) {
            LOG.lazyPropertyFetchingAvailable(this.name);
        }
        this.lazy = persistentClass.isLazy() && (!persistentClass.hasPojoRepresentation() || !ReflectHelper.isFinalClass(persistentClass.getProxyInterface()));
        this.mutable = persistentClass.isMutable();
        if (persistentClass.isAbstract() == null) {
            this.isAbstract = persistentClass.hasPojoRepresentation() && ReflectHelper.isAbstractClass(persistentClass.getMappedClass());
        } else {
            this.isAbstract = persistentClass.isAbstract();
            if (!this.isAbstract && persistentClass.hasPojoRepresentation() && ReflectHelper.isAbstractClass(persistentClass.getMappedClass())) {
                LOG.entityMappedAsNonAbstract(this.name);
            }
        }
        this.selectBeforeUpdate = persistentClass.hasSelectBeforeUpdate();
        this.dynamicUpdate = persistentClass.useDynamicUpdate();
        this.dynamicInsert = persistentClass.useDynamicInsert();
        this.polymorphic = persistentClass.isPolymorphic();
        this.explicitPolymorphism = persistentClass.isExplicitPolymorphism();
        this.inherited = persistentClass.isInherited();
        this.superclass = this.inherited ? persistentClass.getSuperclass().getEntityName() : null;
        this.hasSubclasses = persistentClass.hasSubclasses();
        this.optimisticLockStyle = this.interpretOptLockMode(persistentClass.getOptimisticLockMode());
        boolean bl12 = bl = this.optimisticLockStyle == OptimisticLockStyle.ALL || this.optimisticLockStyle == OptimisticLockStyle.DIRTY;
        if (bl && !this.dynamicUpdate) {
            throw new MappingException("optimistic-lock=all|dirty requires dynamic-update=\"true\": " + this.name);
        }
        if (this.versionPropertyIndex != -66 && bl) {
            throw new MappingException("version and optimistic-lock=all|dirty are not a valid combination : " + this.name);
        }
        this.hasCollections = bl4;
        this.hasMutableProperties = bl5;
        iterator = persistentClass.getSubclassIterator();
        while (iterator.hasNext()) {
            this.subclassEntityNames.add(((PersistentClass)iterator.next()).getEntityName());
        }
        this.subclassEntityNames.add(this.name);
        if (persistentClass.hasPojoRepresentation()) {
            this.entityNameByInheritenceClassMap.put(persistentClass.getMappedClass(), persistentClass.getEntityName());
            iterator = persistentClass.getSubclassIterator();
            while (iterator.hasNext()) {
                PersistentClass persistentClass2 = (PersistentClass)iterator.next();
                this.entityNameByInheritenceClassMap.put(persistentClass2.getMappedClass(), persistentClass2.getEntityName());
            }
        }
        this.entityMode = persistentClass.hasPojoRepresentation() ? EntityMode.POJO : EntityMode.MAP;
        EntityTuplizerFactory entityTuplizerFactory = sessionFactoryImplementor.getSettings().getEntityTuplizerFactory();
        String string = persistentClass.getTuplizerImplClassName(this.entityMode);
        this.entityTuplizer = string == null ? entityTuplizerFactory.constructDefaultTuplizer(this.entityMode, this, persistentClass) : entityTuplizerFactory.constructTuplizer(string, this, persistentClass);
    }

    private OptimisticLockStyle interpretOptLockMode(int n) {
        switch (n) {
            case -1: {
                return OptimisticLockStyle.NONE;
            }
            case 1: {
                return OptimisticLockStyle.DIRTY;
            }
            case 2: {
                return OptimisticLockStyle.ALL;
            }
        }
        return OptimisticLockStyle.VERSION;
    }

    public EntityMetamodel(EntityBinding entityBinding, SessionFactoryImplementor sessionFactoryImplementor) {
        boolean bl;
        this.sessionFactory = sessionFactoryImplementor;
        this.name = entityBinding.getEntity().getName();
        this.rootName = entityBinding.getHierarchyDetails().getRootEntityBinding().getEntity().getName();
        this.entityType = sessionFactoryImplementor.getTypeResolver().getTypeFactory().manyToOne(this.name);
        this.identifierProperty = PropertyFactory.buildIdentifierProperty(entityBinding, sessionFactoryImplementor.getIdentifierGenerator(this.rootName));
        this.versioned = entityBinding.isVersioned();
        boolean bl2 = false;
        Class<?> clazz = null;
        Class<?> clazz2 = null;
        if (entityBinding.getEntity().getClassReferenceUnresolved() != null) {
            bl2 = true;
            clazz = entityBinding.getEntity().getClassReference();
            clazz2 = entityBinding.getProxyInterfaceType().getValue();
        }
        this.instrumentationMetadata = Environment.getBytecodeProvider().getEntityInstrumentationMetadata(clazz);
        boolean bl3 = false;
        BasicAttributeBinding basicAttributeBinding = entityBinding.getHierarchyDetails().getEntityIdentifier().getValueBinding();
        this.propertySpan = basicAttributeBinding == null ? entityBinding.getAttributeBindingClosureSpan() : entityBinding.getAttributeBindingClosureSpan() - 1;
        this.properties = new StandardProperty[this.propertySpan];
        ArrayList arrayList = new ArrayList();
        this.propertyNames = new String[this.propertySpan];
        this.propertyTypes = new Type[this.propertySpan];
        this.propertyUpdateability = new boolean[this.propertySpan];
        this.propertyInsertability = new boolean[this.propertySpan];
        this.insertInclusions = new ValueInclusion[this.propertySpan];
        this.updateInclusions = new ValueInclusion[this.propertySpan];
        this.nonlazyPropertyUpdateability = new boolean[this.propertySpan];
        this.propertyCheckability = new boolean[this.propertySpan];
        this.propertyNullability = new boolean[this.propertySpan];
        this.propertyVersionability = new boolean[this.propertySpan];
        this.propertyLaziness = new boolean[this.propertySpan];
        this.cascadeStyles = new CascadeStyle[this.propertySpan];
        int n = 0;
        int n2 = -66;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        boolean bl8 = false;
        boolean bl9 = false;
        boolean bl10 = false;
        for (AttributeBinding object2 : entityBinding.getAttributeBindingClosure()) {
            boolean clazz3;
            if (object2 == basicAttributeBinding) continue;
            if (object2 == entityBinding.getHierarchyDetails().getVersioningAttributeBinding()) {
                n2 = n;
                this.properties[n] = PropertyFactory.buildVersionProperty(entityBinding.getHierarchyDetails().getVersioningAttributeBinding(), this.instrumentationMetadata.isInstrumented());
            } else {
                this.properties[n] = PropertyFactory.buildStandardProperty(object2, this.instrumentationMetadata.isInstrumented());
            }
            if ("id".equals(object2.getAttribute().getName())) {
                bl7 = true;
            }
            boolean bl11 = clazz3 = object2.isLazy() && this.instrumentationMetadata.isInstrumented();
            if (clazz3) {
                bl3 = true;
            }
            this.propertyLaziness[n] = clazz3;
            this.propertyNames[n] = this.properties[n].getName();
            this.propertyTypes[n] = this.properties[n].getType();
            this.propertyNullability[n] = this.properties[n].isNullable();
            this.propertyUpdateability[n] = this.properties[n].isUpdateable();
            this.propertyInsertability[n] = this.properties[n].isInsertable();
            this.insertInclusions[n] = this.determineInsertValueGenerationType(object2, this.properties[n]);
            this.updateInclusions[n] = this.determineUpdateValueGenerationType(object2, this.properties[n]);
            this.propertyVersionability[n] = this.properties[n].isVersionable();
            this.nonlazyPropertyUpdateability[n] = this.properties[n].isUpdateable() && !clazz3;
            this.propertyCheckability[n] = this.propertyUpdateability[n] || this.propertyTypes[n].isAssociationType() && ((AssociationType)this.propertyTypes[n]).isAlwaysDirtyChecked();
            this.cascadeStyles[n] = this.properties[n].getCascadeStyle();
            if (this.properties[n].isLazy()) {
                bl3 = true;
            }
            if (this.properties[n].getCascadeStyle() != CascadeStyle.NONE) {
                bl4 = true;
            }
            if (this.indicatesCollection(this.properties[n].getType())) {
                bl5 = true;
            }
            if (this.propertyTypes[n].isMutable() && this.propertyCheckability[n]) {
                bl6 = true;
            }
            if (this.insertInclusions[n] != ValueInclusion.NONE) {
                bl8 = true;
            }
            if (this.updateInclusions[n] != ValueInclusion.NONE) {
                bl9 = true;
            }
            this.mapPropertyToIndex(object2.getAttribute(), n);
            ++n;
        }
        if (arrayList.size() == 0) {
            this.naturalIdPropertyNumbers = null;
            this.hasImmutableNaturalId = false;
            this.hasCacheableNaturalId = false;
        } else {
            this.naturalIdPropertyNumbers = ArrayHelper.toIntArray(arrayList);
            this.hasImmutableNaturalId = !bl10;
            this.hasCacheableNaturalId = false;
        }
        this.hasInsertGeneratedValues = bl8;
        this.hasUpdateGeneratedValues = bl9;
        this.hasCascades = bl4;
        this.hasNonIdentifierPropertyNamedId = bl7;
        this.versionPropertyIndex = n2;
        this.hasLazyProperties = bl3;
        if (this.hasLazyProperties) {
            LOG.lazyPropertyFetchingAvailable(this.name);
        }
        this.lazy = entityBinding.isLazy() && (!bl2 || !ReflectHelper.isFinalClass(clazz2));
        this.mutable = entityBinding.isMutable();
        if (entityBinding.isAbstract() == null) {
            this.isAbstract = bl2 && ReflectHelper.isAbstractClass(clazz);
        } else {
            this.isAbstract = entityBinding.isAbstract();
            if (!this.isAbstract && bl2 && ReflectHelper.isAbstractClass(clazz)) {
                LOG.entityMappedAsNonAbstract(this.name);
            }
        }
        this.selectBeforeUpdate = entityBinding.isSelectBeforeUpdate();
        this.dynamicUpdate = entityBinding.isDynamicUpdate();
        this.dynamicInsert = entityBinding.isDynamicInsert();
        this.hasSubclasses = entityBinding.hasSubEntityBindings();
        this.polymorphic = entityBinding.isPolymorphic();
        this.explicitPolymorphism = entityBinding.getHierarchyDetails().isExplicitPolymorphism();
        this.inherited = !entityBinding.isRoot();
        this.superclass = this.inherited ? entityBinding.getEntity().getSuperType().getName() : null;
        this.optimisticLockStyle = entityBinding.getHierarchyDetails().getOptimisticLockStyle();
        boolean bl12 = bl = this.optimisticLockStyle == OptimisticLockStyle.ALL || this.optimisticLockStyle == OptimisticLockStyle.DIRTY;
        if (bl && !this.dynamicUpdate) {
            throw new MappingException("optimistic-lock=all|dirty requires dynamic-update=\"true\": " + this.name);
        }
        if (this.versionPropertyIndex != -66 && bl) {
            throw new MappingException("version and optimistic-lock=all|dirty are not a valid combination : " + this.name);
        }
        this.hasCollections = bl5;
        this.hasMutableProperties = bl6;
        for (EntityBinding entityBinding2 : entityBinding.getPostOrderSubEntityBindingClosure()) {
            this.subclassEntityNames.add(entityBinding2.getEntity().getName());
            if (entityBinding2.getEntity().getClassReference() == null) continue;
            this.entityNameByInheritenceClassMap.put(entityBinding2.getEntity().getClassReference(), entityBinding2.getEntity().getName());
        }
        this.subclassEntityNames.add(this.name);
        if (clazz != null) {
            this.entityNameByInheritenceClassMap.put(clazz, this.name);
        }
        this.entityMode = bl2 ? EntityMode.POJO : EntityMode.MAP;
        EntityTuplizerFactory entityTuplizerFactory = sessionFactoryImplementor.getSettings().getEntityTuplizerFactory();
        Class<? extends EntityTuplizer> clazz3 = entityBinding.getCustomEntityTuplizerClass();
        this.entityTuplizer = clazz3 == null ? entityTuplizerFactory.constructDefaultTuplizer(this.entityMode, this, entityBinding) : entityTuplizerFactory.constructTuplizer(clazz3, this, entityBinding);
    }

    private ValueInclusion determineInsertValueGenerationType(Property property, StandardProperty standardProperty) {
        if (standardProperty.isInsertGenerated()) {
            return ValueInclusion.FULL;
        }
        if (property.getValue() instanceof Component && this.hasPartialInsertComponentGeneration((Component)property.getValue())) {
            return ValueInclusion.PARTIAL;
        }
        return ValueInclusion.NONE;
    }

    private ValueInclusion determineInsertValueGenerationType(AttributeBinding attributeBinding, StandardProperty standardProperty) {
        if (standardProperty.isInsertGenerated()) {
            return ValueInclusion.FULL;
        }
        return ValueInclusion.NONE;
    }

    private boolean hasPartialInsertComponentGeneration(Component component) {
        Iterator iterator = component.getPropertyIterator();
        while (iterator.hasNext()) {
            Property property = (Property)iterator.next();
            if (property.getGeneration() == PropertyGeneration.ALWAYS || property.getGeneration() == PropertyGeneration.INSERT) {
                return true;
            }
            if (!(property.getValue() instanceof Component) || !this.hasPartialInsertComponentGeneration((Component)property.getValue())) continue;
            return true;
        }
        return false;
    }

    private ValueInclusion determineUpdateValueGenerationType(Property property, StandardProperty standardProperty) {
        if (standardProperty.isUpdateGenerated()) {
            return ValueInclusion.FULL;
        }
        if (property.getValue() instanceof Component && this.hasPartialUpdateComponentGeneration((Component)property.getValue())) {
            return ValueInclusion.PARTIAL;
        }
        return ValueInclusion.NONE;
    }

    private ValueInclusion determineUpdateValueGenerationType(AttributeBinding attributeBinding, StandardProperty standardProperty) {
        if (standardProperty.isUpdateGenerated()) {
            return ValueInclusion.FULL;
        }
        return ValueInclusion.NONE;
    }

    private boolean hasPartialUpdateComponentGeneration(Component component) {
        Iterator iterator = component.getPropertyIterator();
        while (iterator.hasNext()) {
            Property property = (Property)iterator.next();
            if (property.getGeneration() == PropertyGeneration.ALWAYS) {
                return true;
            }
            if (!(property.getValue() instanceof Component) || !this.hasPartialUpdateComponentGeneration((Component)property.getValue())) continue;
            return true;
        }
        return false;
    }

    private void mapPropertyToIndex(Property property, int n) {
        this.propertyIndexes.put(property.getName(), n);
        if (property.getValue() instanceof Component) {
            Iterator iterator = ((Component)property.getValue()).getPropertyIterator();
            while (iterator.hasNext()) {
                Property property2 = (Property)iterator.next();
                this.propertyIndexes.put(property.getName() + '.' + property2.getName(), n);
            }
        }
    }

    private void mapPropertyToIndex(Attribute attribute, int n) {
        this.propertyIndexes.put(attribute.getName(), n);
        if (attribute.isSingular() && ((SingularAttribute)attribute).getSingularAttributeType().isComponent()) {
            org.hibernate.metamodel.domain.Component component = (org.hibernate.metamodel.domain.Component)((SingularAttribute)attribute).getSingularAttributeType();
            for (Attribute attribute2 : component.attributes()) {
                this.propertyIndexes.put(attribute.getName() + '.' + attribute2.getName(), n);
            }
        }
    }

    public EntityTuplizer getTuplizer() {
        return this.entityTuplizer;
    }

    public int[] getNaturalIdentifierProperties() {
        return this.naturalIdPropertyNumbers;
    }

    public boolean hasNaturalIdentifier() {
        return this.naturalIdPropertyNumbers != null;
    }

    public boolean isNaturalIdentifierCached() {
        return this.hasNaturalIdentifier() && this.hasCacheableNaturalId;
    }

    public boolean hasImmutableNaturalId() {
        return this.hasImmutableNaturalId;
    }

    public Set getSubclassEntityNames() {
        return this.subclassEntityNames;
    }

    private boolean indicatesCollection(Type type) {
        if (type.isCollectionType()) {
            return true;
        }
        if (type.isComponentType()) {
            Type[] typeArray = ((CompositeType)type).getSubtypes();
            for (int i = 0; i < typeArray.length; ++i) {
                if (!this.indicatesCollection(typeArray[i])) continue;
                return true;
            }
        }
        return false;
    }

    public SessionFactoryImplementor getSessionFactory() {
        return this.sessionFactory;
    }

    public String getName() {
        return this.name;
    }

    public String getRootName() {
        return this.rootName;
    }

    public EntityType getEntityType() {
        return this.entityType;
    }

    public IdentifierProperty getIdentifierProperty() {
        return this.identifierProperty;
    }

    public int getPropertySpan() {
        return this.propertySpan;
    }

    public int getVersionPropertyIndex() {
        return this.versionPropertyIndex;
    }

    public VersionProperty getVersionProperty() {
        if (-66 == this.versionPropertyIndex) {
            return null;
        }
        return (VersionProperty)this.properties[this.versionPropertyIndex];
    }

    public StandardProperty[] getProperties() {
        return this.properties;
    }

    public int getPropertyIndex(String string) {
        Integer n = this.getPropertyIndexOrNull(string);
        if (n == null) {
            throw new HibernateException("Unable to resolve property: " + string);
        }
        return n;
    }

    public Integer getPropertyIndexOrNull(String string) {
        return this.propertyIndexes.get(string);
    }

    public boolean hasCollections() {
        return this.hasCollections;
    }

    public boolean hasMutableProperties() {
        return this.hasMutableProperties;
    }

    public boolean hasNonIdentifierPropertyNamedId() {
        return this.hasNonIdentifierPropertyNamedId;
    }

    public boolean hasLazyProperties() {
        return this.hasLazyProperties;
    }

    public boolean hasCascades() {
        return this.hasCascades;
    }

    public boolean isMutable() {
        return this.mutable;
    }

    public boolean isSelectBeforeUpdate() {
        return this.selectBeforeUpdate;
    }

    public boolean isDynamicUpdate() {
        return this.dynamicUpdate;
    }

    public boolean isDynamicInsert() {
        return this.dynamicInsert;
    }

    public OptimisticLockStyle getOptimisticLockStyle() {
        return this.optimisticLockStyle;
    }

    public boolean isPolymorphic() {
        return this.polymorphic;
    }

    public String getSuperclass() {
        return this.superclass;
    }

    public boolean isExplicitPolymorphism() {
        return this.explicitPolymorphism;
    }

    public boolean isInherited() {
        return this.inherited;
    }

    public boolean hasSubclasses() {
        return this.hasSubclasses;
    }

    public boolean isLazy() {
        return this.lazy;
    }

    public void setLazy(boolean bl) {
        this.lazy = bl;
    }

    public boolean isVersioned() {
        return this.versioned;
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public String findEntityNameByEntityClass(Class clazz) {
        return (String)this.entityNameByInheritenceClassMap.get(clazz);
    }

    public String toString() {
        return "EntityMetamodel(" + this.name + ':' + ArrayHelper.toString(this.properties) + ')';
    }

    public String[] getPropertyNames() {
        return this.propertyNames;
    }

    public Type[] getPropertyTypes() {
        return this.propertyTypes;
    }

    public boolean[] getPropertyLaziness() {
        return this.propertyLaziness;
    }

    public boolean[] getPropertyUpdateability() {
        return this.propertyUpdateability;
    }

    public boolean[] getPropertyCheckability() {
        return this.propertyCheckability;
    }

    public boolean[] getNonlazyPropertyUpdateability() {
        return this.nonlazyPropertyUpdateability;
    }

    public boolean[] getPropertyInsertability() {
        return this.propertyInsertability;
    }

    public ValueInclusion[] getPropertyInsertGenerationInclusions() {
        return this.insertInclusions;
    }

    public ValueInclusion[] getPropertyUpdateGenerationInclusions() {
        return this.updateInclusions;
    }

    public boolean[] getPropertyNullability() {
        return this.propertyNullability;
    }

    public boolean[] getPropertyVersionability() {
        return this.propertyVersionability;
    }

    public CascadeStyle[] getCascadeStyles() {
        return this.cascadeStyles;
    }

    public boolean hasInsertGeneratedValues() {
        return this.hasInsertGeneratedValues;
    }

    public boolean hasUpdateGeneratedValues() {
        return this.hasUpdateGeneratedValues;
    }

    public EntityMode getEntityMode() {
        return this.entityMode;
    }

    public boolean isInstrumented() {
        return this.instrumentationMetadata.isInstrumented();
    }

    public EntityInstrumentationMetadata getInstrumentationMetadata() {
        return this.instrumentationMetadata;
    }
}

