/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tuple.entity;

import java.util.Map;
import org.hibernate.EntityMode;
import org.hibernate.EntityNameResolver;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.metamodel.binding.AttributeBinding;
import org.hibernate.metamodel.binding.EntityBinding;
import org.hibernate.property.Getter;
import org.hibernate.property.PropertyAccessor;
import org.hibernate.property.PropertyAccessorFactory;
import org.hibernate.property.Setter;
import org.hibernate.proxy.ProxyFactory;
import org.hibernate.proxy.map.MapProxyFactory;
import org.hibernate.tuple.DynamicMapInstantiator;
import org.hibernate.tuple.Instantiator;
import org.hibernate.tuple.entity.AbstractEntityTuplizer;
import org.hibernate.tuple.entity.EntityMetamodel;
import org.jboss.logging.Logger;

public class DynamicMapEntityTuplizer
extends AbstractEntityTuplizer {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, DynamicMapEntityTuplizer.class.getName());

    DynamicMapEntityTuplizer(EntityMetamodel entityMetamodel, PersistentClass persistentClass) {
        super(entityMetamodel, persistentClass);
    }

    DynamicMapEntityTuplizer(EntityMetamodel entityMetamodel, EntityBinding entityBinding) {
        super(entityMetamodel, entityBinding);
    }

    public EntityMode getEntityMode() {
        return EntityMode.MAP;
    }

    private PropertyAccessor buildPropertyAccessor(Property property) {
        if (property.isBackRef()) {
            return property.getPropertyAccessor(null);
        }
        return PropertyAccessorFactory.getDynamicMapPropertyAccessor();
    }

    protected Getter buildPropertyGetter(Property property, PersistentClass persistentClass) {
        return this.buildPropertyAccessor(property).getGetter(null, property.getName());
    }

    protected Setter buildPropertySetter(Property property, PersistentClass persistentClass) {
        return this.buildPropertyAccessor(property).getSetter(null, property.getName());
    }

    protected Instantiator buildInstantiator(PersistentClass persistentClass) {
        return new DynamicMapInstantiator(persistentClass);
    }

    protected ProxyFactory buildProxyFactory(PersistentClass persistentClass, Getter getter, Setter setter) {
        MapProxyFactory mapProxyFactory = new MapProxyFactory();
        try {
            mapProxyFactory.postInstantiate(this.getEntityName(), null, null, null, null, null);
        }
        catch (HibernateException hibernateException) {
            LOG.unableToCreateProxyFactory(this.getEntityName(), hibernateException);
            mapProxyFactory = null;
        }
        return mapProxyFactory;
    }

    private PropertyAccessor buildPropertyAccessor(AttributeBinding attributeBinding) {
        return PropertyAccessorFactory.getDynamicMapPropertyAccessor();
    }

    protected Getter buildPropertyGetter(AttributeBinding attributeBinding) {
        return this.buildPropertyAccessor(attributeBinding).getGetter(null, attributeBinding.getAttribute().getName());
    }

    protected Setter buildPropertySetter(AttributeBinding attributeBinding) {
        return this.buildPropertyAccessor(attributeBinding).getSetter(null, attributeBinding.getAttribute().getName());
    }

    protected Instantiator buildInstantiator(EntityBinding entityBinding) {
        return new DynamicMapInstantiator(entityBinding);
    }

    protected ProxyFactory buildProxyFactory(EntityBinding entityBinding, Getter getter, Setter setter) {
        MapProxyFactory mapProxyFactory = new MapProxyFactory();
        try {
            mapProxyFactory.postInstantiate(this.getEntityName(), null, null, null, null, null);
        }
        catch (HibernateException hibernateException) {
            LOG.unableToCreateProxyFactory(this.getEntityName(), hibernateException);
            mapProxyFactory = null;
        }
        return mapProxyFactory;
    }

    public Class getMappedClass() {
        return Map.class;
    }

    public Class getConcreteProxyClass() {
        return Map.class;
    }

    public boolean isInstrumented() {
        return false;
    }

    public EntityNameResolver[] getEntityNameResolvers() {
        return new EntityNameResolver[]{BasicEntityNameResolver.INSTANCE};
    }

    public String determineConcreteSubclassEntityName(Object object, SessionFactoryImplementor sessionFactoryImplementor) {
        return DynamicMapEntityTuplizer.extractEmbeddedEntityName((Map)object);
    }

    public static String extractEmbeddedEntityName(Map map) {
        return (String)map.get("$type$");
    }

    public static class BasicEntityNameResolver
    implements EntityNameResolver {
        public static final BasicEntityNameResolver INSTANCE = new BasicEntityNameResolver();

        public String resolveEntityName(Object object) {
            if (!Map.class.isInstance(object)) {
                return null;
            }
            String string = DynamicMapEntityTuplizer.extractEmbeddedEntityName((Map)object);
            if (string == null) {
                throw new HibernateException("Could not determine type of dynamic map entity");
            }
            return string;
        }

        public boolean equals(Object object) {
            return this.getClass().equals(object.getClass());
        }

        public int hashCode() {
            return this.getClass().hashCode();
        }
    }
}

