/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tuple.component;

import java.io.Serializable;
import java.lang.reflect.Method;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.bytecode.spi.BasicProxyFactory;
import org.hibernate.bytecode.spi.ReflectionOptimizer;
import org.hibernate.cfg.Environment;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.Property;
import org.hibernate.property.BackrefPropertyAccessor;
import org.hibernate.property.Getter;
import org.hibernate.property.PropertyAccessor;
import org.hibernate.property.PropertyAccessorFactory;
import org.hibernate.property.Setter;
import org.hibernate.tuple.Instantiator;
import org.hibernate.tuple.PojoInstantiator;
import org.hibernate.tuple.component.AbstractComponentTuplizer;

public class PojoComponentTuplizer
extends AbstractComponentTuplizer {
    private final Class componentClass;
    private ReflectionOptimizer optimizer;
    private final Getter parentGetter;
    private final Setter parentSetter;

    public PojoComponentTuplizer(Component component) {
        super(component);
        this.componentClass = component.getComponentClass();
        String[] stringArray = new String[this.propertySpan];
        String[] stringArray2 = new String[this.propertySpan];
        Class[] classArray = new Class[this.propertySpan];
        for (int i = 0; i < this.propertySpan; ++i) {
            stringArray[i] = this.getters[i].getMethodName();
            stringArray2[i] = this.setters[i].getMethodName();
            classArray[i] = this.getters[i].getReturnType();
        }
        String string = component.getParentProperty();
        if (string == null) {
            this.parentSetter = null;
            this.parentGetter = null;
        } else {
            PropertyAccessor propertyAccessor = PropertyAccessorFactory.getPropertyAccessor(null);
            this.parentSetter = propertyAccessor.getSetter(this.componentClass, string);
            this.parentGetter = propertyAccessor.getGetter(this.componentClass, string);
        }
        this.optimizer = this.hasCustomAccessors || !Environment.useReflectionOptimizer() ? null : Environment.getBytecodeProvider().getReflectionOptimizer(this.componentClass, stringArray, stringArray2, classArray);
    }

    public Class getMappedClass() {
        return this.componentClass;
    }

    public Object[] getPropertyValues(Object object) throws HibernateException {
        if (object == BackrefPropertyAccessor.UNKNOWN) {
            return new Object[this.propertySpan];
        }
        if (this.optimizer != null && this.optimizer.getAccessOptimizer() != null) {
            return this.optimizer.getAccessOptimizer().getPropertyValues(object);
        }
        return super.getPropertyValues(object);
    }

    public void setPropertyValues(Object object, Object[] objectArray) throws HibernateException {
        if (this.optimizer != null && this.optimizer.getAccessOptimizer() != null) {
            this.optimizer.getAccessOptimizer().setPropertyValues(object, objectArray);
        } else {
            super.setPropertyValues(object, objectArray);
        }
    }

    public Object getParent(Object object) {
        return this.parentGetter.get(object);
    }

    public boolean hasParentProperty() {
        return this.parentGetter != null;
    }

    public boolean isMethodOf(Method method) {
        for (int i = 0; i < this.propertySpan; ++i) {
            Method method2 = this.getters[i].getMethod();
            if (method2 == null || !method2.equals(method)) continue;
            return true;
        }
        return false;
    }

    public void setParent(Object object, Object object2, SessionFactoryImplementor sessionFactoryImplementor) {
        this.parentSetter.set(object, object2, sessionFactoryImplementor);
    }

    protected Instantiator buildInstantiator(Component component) {
        if (component.isEmbedded() && ReflectHelper.isAbstractClass(component.getComponentClass())) {
            return new ProxiedInstantiator(component);
        }
        if (this.optimizer == null) {
            return new PojoInstantiator(component, null);
        }
        return new PojoInstantiator(component, this.optimizer.getInstantiationOptimizer());
    }

    protected Getter buildGetter(Component component, Property property) {
        return property.getGetter(component.getComponentClass());
    }

    protected Setter buildSetter(Component component, Property property) {
        return property.getSetter(component.getComponentClass());
    }

    private static class ProxiedInstantiator
    implements Instantiator {
        private final Class proxiedClass;
        private final BasicProxyFactory factory;

        public ProxiedInstantiator(Component component) {
            this.proxiedClass = component.getComponentClass();
            this.factory = this.proxiedClass.isInterface() ? Environment.getBytecodeProvider().getProxyFactoryFactory().buildBasicProxyFactory(null, new Class[]{this.proxiedClass}) : Environment.getBytecodeProvider().getProxyFactoryFactory().buildBasicProxyFactory(this.proxiedClass, null);
        }

        public Object instantiate(Serializable serializable) {
            throw new AssertionFailure("ProxiedInstantiator can only be used to instantiate component");
        }

        public Object instantiate() {
            return this.factory.getProxy();
        }

        public boolean isInstance(Object object) {
            return this.proxiedClass.isInstance(object);
        }
    }
}

