/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tuple.component;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.Property;
import org.hibernate.tuple.PropertyFactory;
import org.hibernate.tuple.StandardProperty;
import org.hibernate.tuple.component.ComponentTuplizer;
import org.hibernate.tuple.component.ComponentTuplizerFactory;

public class ComponentMetamodel
implements Serializable {
    private final String role;
    private final boolean isKey;
    private final StandardProperty[] properties;
    private final EntityMode entityMode;
    private final ComponentTuplizer componentTuplizer;
    private final int propertySpan;
    private final Map propertyIndexes = new HashMap();

    public ComponentMetamodel(Component component) {
        Serializable serializable;
        this.role = component.getRoleName();
        this.isKey = component.isKey();
        this.propertySpan = component.getPropertySpan();
        this.properties = new StandardProperty[this.propertySpan];
        Iterator iterator = component.getPropertyIterator();
        int n = 0;
        while (iterator.hasNext()) {
            serializable = (Property)iterator.next();
            this.properties[n] = PropertyFactory.buildStandardProperty((Property)serializable, false);
            this.propertyIndexes.put(((Property)serializable).getName(), n);
            ++n;
        }
        this.entityMode = component.hasPojoRepresentation() ? EntityMode.POJO : EntityMode.MAP;
        serializable = new ComponentTuplizerFactory();
        String string = component.getTuplizerImplClassName(this.entityMode);
        this.componentTuplizer = string == null ? ((ComponentTuplizerFactory)serializable).constructDefaultTuplizer(this.entityMode, component) : ((ComponentTuplizerFactory)serializable).constructTuplizer(string, component);
    }

    public boolean isKey() {
        return this.isKey;
    }

    public int getPropertySpan() {
        return this.propertySpan;
    }

    public StandardProperty[] getProperties() {
        return this.properties;
    }

    public StandardProperty getProperty(int n) {
        if (n < 0 || n >= this.propertySpan) {
            throw new IllegalArgumentException("illegal index value for component property access [request=" + n + ", span=" + this.propertySpan + "]");
        }
        return this.properties[n];
    }

    public int getPropertyIndex(String string) {
        Integer n = (Integer)this.propertyIndexes.get(string);
        if (n == null) {
            throw new HibernateException("component does not contain such a property [" + string + "]");
        }
        return n;
    }

    public StandardProperty getProperty(String string) {
        return this.getProperty(this.getPropertyIndex(string));
    }

    public EntityMode getEntityMode() {
        return this.entityMode;
    }

    public ComponentTuplizer getComponentTuplizer() {
        return this.componentTuplizer;
    }
}

