/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tuple;

import java.lang.reflect.Constructor;
import org.hibernate.EntityMode;
import org.hibernate.FetchMode;
import org.hibernate.engine.internal.UnsavedValueFactory;
import org.hibernate.engine.spi.CascadeStyle;
import org.hibernate.engine.spi.IdentifierValue;
import org.hibernate.engine.spi.VersionValue;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.PropertyGeneration;
import org.hibernate.metamodel.binding.AbstractPluralAttributeBinding;
import org.hibernate.metamodel.binding.AssociationAttributeBinding;
import org.hibernate.metamodel.binding.AttributeBinding;
import org.hibernate.metamodel.binding.BasicAttributeBinding;
import org.hibernate.metamodel.binding.EntityBinding;
import org.hibernate.metamodel.binding.SimpleValueBinding;
import org.hibernate.metamodel.binding.SingularAttributeBinding;
import org.hibernate.property.Getter;
import org.hibernate.property.PropertyAccessor;
import org.hibernate.property.PropertyAccessorFactory;
import org.hibernate.tuple.IdentifierProperty;
import org.hibernate.tuple.StandardProperty;
import org.hibernate.tuple.VersionProperty;
import org.hibernate.type.AssociationType;
import org.hibernate.type.Type;
import org.hibernate.type.VersionType;

public class PropertyFactory {
    public static IdentifierProperty buildIdentifierProperty(PersistentClass persistentClass, IdentifierGenerator identifierGenerator) {
        String string = persistentClass.getIdentifier().getNullValue();
        Type type = persistentClass.getIdentifier().getType();
        Property property = persistentClass.getIdentifierProperty();
        IdentifierValue identifierValue = UnsavedValueFactory.getUnsavedIdentifierValue(string, PropertyFactory.getGetter(property), type, PropertyFactory.getConstructor(persistentClass));
        if (property == null) {
            return new IdentifierProperty(type, persistentClass.hasEmbeddedIdentifier(), persistentClass.hasIdentifierMapper(), identifierValue, identifierGenerator);
        }
        return new IdentifierProperty(property.getName(), property.getNodeName(), type, persistentClass.hasEmbeddedIdentifier(), identifierValue, identifierGenerator);
    }

    public static IdentifierProperty buildIdentifierProperty(EntityBinding entityBinding, IdentifierGenerator identifierGenerator) {
        BasicAttributeBinding basicAttributeBinding = entityBinding.getHierarchyDetails().getEntityIdentifier().getValueBinding();
        String string = basicAttributeBinding.getUnsavedValue();
        Type type = basicAttributeBinding.getHibernateTypeDescriptor().getResolvedTypeMapping();
        IdentifierValue identifierValue = UnsavedValueFactory.getUnsavedIdentifierValue(string, PropertyFactory.getGetter(basicAttributeBinding), type, PropertyFactory.getConstructor(entityBinding));
        if (basicAttributeBinding == null) {
            return new IdentifierProperty(type, entityBinding.getHierarchyDetails().getEntityIdentifier().isEmbedded(), entityBinding.getHierarchyDetails().getEntityIdentifier().isIdentifierMapper(), identifierValue, identifierGenerator);
        }
        return new IdentifierProperty(basicAttributeBinding.getAttribute().getName(), null, type, entityBinding.getHierarchyDetails().getEntityIdentifier().isEmbedded(), identifierValue, identifierGenerator);
    }

    public static VersionProperty buildVersionProperty(Property property, boolean bl) {
        String string = ((KeyValue)property.getValue()).getNullValue();
        VersionValue versionValue = UnsavedValueFactory.getUnsavedVersionValue(string, PropertyFactory.getGetter(property), (VersionType)property.getType(), PropertyFactory.getConstructor(property.getPersistentClass()));
        boolean bl2 = bl && property.isLazy();
        return new VersionProperty(property.getName(), property.getNodeName(), property.getValue().getType(), bl2, property.isInsertable(), property.isUpdateable(), property.getGeneration() == PropertyGeneration.INSERT || property.getGeneration() == PropertyGeneration.ALWAYS, property.getGeneration() == PropertyGeneration.ALWAYS, property.isOptional(), property.isUpdateable() && !bl2, property.isOptimisticLocked(), property.getCascadeStyle(), versionValue);
    }

    public static VersionProperty buildVersionProperty(BasicAttributeBinding basicAttributeBinding, boolean bl) {
        String string = ((KeyValue)((Object)basicAttributeBinding.getValue())).getNullValue();
        VersionValue versionValue = UnsavedValueFactory.getUnsavedVersionValue(string, PropertyFactory.getGetter(basicAttributeBinding), (VersionType)basicAttributeBinding.getHibernateTypeDescriptor().getResolvedTypeMapping(), PropertyFactory.getConstructor((EntityBinding)basicAttributeBinding.getContainer()));
        boolean bl2 = bl && basicAttributeBinding.isLazy();
        CascadeStyle cascadeStyle = basicAttributeBinding.isAssociation() ? ((AssociationAttributeBinding)((Object)basicAttributeBinding)).getCascadeStyle() : CascadeStyle.NONE;
        return new VersionProperty(basicAttributeBinding.getAttribute().getName(), null, basicAttributeBinding.getHibernateTypeDescriptor().getResolvedTypeMapping(), bl2, true, true, basicAttributeBinding.getGeneration() == PropertyGeneration.INSERT || basicAttributeBinding.getGeneration() == PropertyGeneration.ALWAYS, basicAttributeBinding.getGeneration() == PropertyGeneration.ALWAYS, basicAttributeBinding.isNullable(), !bl2, basicAttributeBinding.isIncludedInOptimisticLocking(), cascadeStyle, versionValue);
    }

    public static StandardProperty buildStandardProperty(Property property, boolean bl) {
        Type type = property.getValue().getType();
        boolean bl2 = type.isAssociationType() && ((AssociationType)type).isAlwaysDirtyChecked();
        return new StandardProperty(property.getName(), property.getNodeName(), type, bl && property.isLazy(), property.isInsertable(), property.isUpdateable(), property.getGeneration() == PropertyGeneration.INSERT || property.getGeneration() == PropertyGeneration.ALWAYS, property.getGeneration() == PropertyGeneration.ALWAYS, property.isOptional(), bl2 || property.isUpdateable(), property.isOptimisticLocked(), property.getCascadeStyle(), property.getValue().getFetchMode());
    }

    public static StandardProperty buildStandardProperty(AttributeBinding attributeBinding, boolean bl) {
        boolean bl2;
        Type type = attributeBinding.getHibernateTypeDescriptor().getResolvedTypeMapping();
        boolean bl3 = bl2 = type.isAssociationType() && ((AssociationType)type).isAlwaysDirtyChecked();
        if (attributeBinding.getAttribute().isSingular()) {
            SingularAttributeBinding singularAttributeBinding = (SingularAttributeBinding)attributeBinding;
            CascadeStyle cascadeStyle = singularAttributeBinding.isAssociation() ? ((AssociationAttributeBinding)((Object)singularAttributeBinding)).getCascadeStyle() : CascadeStyle.NONE;
            FetchMode fetchMode = singularAttributeBinding.isAssociation() ? ((AssociationAttributeBinding)((Object)singularAttributeBinding)).getFetchMode() : FetchMode.DEFAULT;
            return new StandardProperty(singularAttributeBinding.getAttribute().getName(), null, type, bl && singularAttributeBinding.isLazy(), true, true, singularAttributeBinding.getGeneration() == PropertyGeneration.INSERT || singularAttributeBinding.getGeneration() == PropertyGeneration.ALWAYS, singularAttributeBinding.getGeneration() == PropertyGeneration.ALWAYS, singularAttributeBinding.isNullable(), bl2 || PropertyFactory.areAllValuesIncludedInUpdate(singularAttributeBinding), singularAttributeBinding.isIncludedInOptimisticLocking(), cascadeStyle, fetchMode);
        }
        AbstractPluralAttributeBinding abstractPluralAttributeBinding = (AbstractPluralAttributeBinding)attributeBinding;
        CascadeStyle cascadeStyle = abstractPluralAttributeBinding.isAssociation() ? abstractPluralAttributeBinding.getCascadeStyle() : CascadeStyle.NONE;
        FetchMode fetchMode = abstractPluralAttributeBinding.isAssociation() ? abstractPluralAttributeBinding.getFetchMode() : FetchMode.DEFAULT;
        return new StandardProperty(abstractPluralAttributeBinding.getAttribute().getName(), null, type, bl && abstractPluralAttributeBinding.isLazy(), true, true, false, false, false, true, abstractPluralAttributeBinding.isIncludedInOptimisticLocking(), cascadeStyle, fetchMode);
    }

    private static boolean areAllValuesIncludedInUpdate(SingularAttributeBinding singularAttributeBinding) {
        if (singularAttributeBinding.hasDerivedValue()) {
            return false;
        }
        for (SimpleValueBinding simpleValueBinding : singularAttributeBinding.getSimpleValueBindings()) {
            if (simpleValueBinding.isIncludeInUpdate()) continue;
            return false;
        }
        return true;
    }

    private static Constructor getConstructor(PersistentClass persistentClass) {
        if (persistentClass == null || !persistentClass.hasPojoRepresentation()) {
            return null;
        }
        try {
            return ReflectHelper.getDefaultConstructor(persistentClass.getMappedClass());
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private static Constructor getConstructor(EntityBinding entityBinding) {
        if (entityBinding == null || entityBinding.getEntity() == null) {
            return null;
        }
        try {
            return ReflectHelper.getDefaultConstructor(entityBinding.getEntity().getClassReference());
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private static Getter getGetter(Property property) {
        if (property == null || !property.getPersistentClass().hasPojoRepresentation()) {
            return null;
        }
        PropertyAccessor propertyAccessor = PropertyAccessorFactory.getPropertyAccessor(property, EntityMode.POJO);
        return propertyAccessor.getGetter(property.getPersistentClass().getMappedClass(), property.getName());
    }

    private static Getter getGetter(AttributeBinding attributeBinding) {
        if (attributeBinding == null || attributeBinding.getContainer().getClassReference() == null) {
            return null;
        }
        PropertyAccessor propertyAccessor = PropertyAccessorFactory.getPropertyAccessor(attributeBinding, EntityMode.POJO);
        return propertyAccessor.getGetter(attributeBinding.getContainer().getClassReference(), attributeBinding.getAttribute().getName());
    }
}

