/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tuple;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import org.hibernate.InstantiationException;
import org.hibernate.PropertyNotFoundException;
import org.hibernate.bytecode.spi.ReflectionOptimizer;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.metamodel.binding.EntityBinding;
import org.hibernate.tuple.Instantiator;
import org.jboss.logging.Logger;

public class PojoInstantiator
implements Instantiator,
Serializable {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, PojoInstantiator.class.getName());
    private transient Constructor constructor;
    private final Class mappedClass;
    private final transient ReflectionOptimizer.InstantiationOptimizer optimizer;
    private final boolean embeddedIdentifier;
    private final Class proxyInterface;
    private final boolean isAbstract;

    public PojoInstantiator(Component component, ReflectionOptimizer.InstantiationOptimizer instantiationOptimizer) {
        this.mappedClass = component.getComponentClass();
        this.isAbstract = ReflectHelper.isAbstractClass(this.mappedClass);
        this.optimizer = instantiationOptimizer;
        this.proxyInterface = null;
        this.embeddedIdentifier = false;
        try {
            this.constructor = ReflectHelper.getDefaultConstructor(this.mappedClass);
        }
        catch (PropertyNotFoundException propertyNotFoundException) {
            LOG.noDefaultConstructor(this.mappedClass.getName());
            this.constructor = null;
        }
    }

    public PojoInstantiator(PersistentClass persistentClass, ReflectionOptimizer.InstantiationOptimizer instantiationOptimizer) {
        this.mappedClass = persistentClass.getMappedClass();
        this.isAbstract = ReflectHelper.isAbstractClass(this.mappedClass);
        this.proxyInterface = persistentClass.getProxyInterface();
        this.embeddedIdentifier = persistentClass.hasEmbeddedIdentifier();
        this.optimizer = instantiationOptimizer;
        try {
            this.constructor = ReflectHelper.getDefaultConstructor(this.mappedClass);
        }
        catch (PropertyNotFoundException propertyNotFoundException) {
            LOG.noDefaultConstructor(this.mappedClass.getName());
            this.constructor = null;
        }
    }

    public PojoInstantiator(EntityBinding entityBinding, ReflectionOptimizer.InstantiationOptimizer instantiationOptimizer) {
        this.mappedClass = entityBinding.getEntity().getClassReference();
        this.isAbstract = ReflectHelper.isAbstractClass(this.mappedClass);
        this.proxyInterface = entityBinding.getProxyInterfaceType().getValue();
        this.embeddedIdentifier = entityBinding.getHierarchyDetails().getEntityIdentifier().isEmbedded();
        this.optimizer = instantiationOptimizer;
        try {
            this.constructor = ReflectHelper.getDefaultConstructor(this.mappedClass);
        }
        catch (PropertyNotFoundException propertyNotFoundException) {
            LOG.noDefaultConstructor(this.mappedClass.getName());
            this.constructor = null;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.constructor = ReflectHelper.getDefaultConstructor(this.mappedClass);
    }

    public Object instantiate() {
        if (this.isAbstract) {
            throw new InstantiationException("Cannot instantiate abstract class or interface: ", this.mappedClass);
        }
        if (this.optimizer != null) {
            return this.optimizer.newInstance();
        }
        if (this.constructor == null) {
            throw new InstantiationException("No default constructor for entity: ", this.mappedClass);
        }
        try {
            return this.constructor.newInstance(null);
        }
        catch (Exception exception) {
            throw new InstantiationException("Could not instantiate entity: ", this.mappedClass, exception);
        }
    }

    public Object instantiate(Serializable serializable) {
        boolean bl = this.embeddedIdentifier && serializable != null && serializable.getClass().equals(this.mappedClass);
        return bl ? serializable : this.instantiate();
    }

    public boolean isInstance(Object object) {
        return this.mappedClass.isInstance(object) || this.proxyInterface != null && this.proxyInterface.isInstance(object);
    }
}

