/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tuple;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.metamodel.binding.EntityBinding;
import org.hibernate.tuple.Instantiator;

public class DynamicMapInstantiator
implements Instantiator {
    public static final String KEY = "$type$";
    private String entityName;
    private Set isInstanceEntityNames = new HashSet();

    public DynamicMapInstantiator() {
        this.entityName = null;
    }

    public DynamicMapInstantiator(PersistentClass persistentClass) {
        this.entityName = persistentClass.getEntityName();
        this.isInstanceEntityNames.add(this.entityName);
        if (persistentClass.hasSubclasses()) {
            Iterator iterator = persistentClass.getSubclassClosureIterator();
            while (iterator.hasNext()) {
                PersistentClass persistentClass2 = (PersistentClass)iterator.next();
                this.isInstanceEntityNames.add(persistentClass2.getEntityName());
            }
        }
    }

    public DynamicMapInstantiator(EntityBinding entityBinding) {
        this.entityName = entityBinding.getEntity().getName();
        this.isInstanceEntityNames.add(this.entityName);
        for (EntityBinding entityBinding2 : entityBinding.getPostOrderSubEntityBindingClosure()) {
            this.isInstanceEntityNames.add(entityBinding2.getEntity().getName());
        }
    }

    public final Object instantiate(Serializable serializable) {
        return this.instantiate();
    }

    public final Object instantiate() {
        Map map = this.generateMap();
        if (this.entityName != null) {
            map.put(KEY, this.entityName);
        }
        return map;
    }

    public final boolean isInstance(Object object) {
        if (object instanceof Map) {
            if (this.entityName == null) {
                return true;
            }
            String string = (String)((Map)object).get(KEY);
            return string == null || this.isInstanceEntityNames.contains(string);
        }
        return false;
    }

    protected Map generateMap() {
        return new HashMap();
    }
}

