/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tuple;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import org.dom4j.Element;
import org.hibernate.internal.util.xml.XMLHelper;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.tuple.Instantiator;

public class Dom4jInstantiator
implements Instantiator {
    private final String nodeName;
    private final HashSet isInstanceNodeNames = new HashSet();

    public Dom4jInstantiator(Component component) {
        this.nodeName = component.getNodeName();
        this.isInstanceNodeNames.add(this.nodeName);
    }

    public Dom4jInstantiator(PersistentClass persistentClass) {
        this.nodeName = persistentClass.getNodeName();
        this.isInstanceNodeNames.add(this.nodeName);
        if (persistentClass.hasSubclasses()) {
            Iterator iterator = persistentClass.getSubclassClosureIterator();
            while (iterator.hasNext()) {
                PersistentClass persistentClass2 = (PersistentClass)iterator.next();
                this.isInstanceNodeNames.add(persistentClass2.getNodeName());
            }
        }
    }

    public Object instantiate(Serializable serializable) {
        return this.instantiate();
    }

    public Object instantiate() {
        return XMLHelper.generateDom4jElement(this.nodeName);
    }

    public boolean isInstance(Object object) {
        if (object instanceof Element) {
            return this.isInstanceNodeNames.contains(((Element)object).getName());
        }
        return false;
    }
}

