/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.transform;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.transform.BasicTransformerAdapter;
import org.jboss.logging.Logger;

public class DistinctResultTransformer
extends BasicTransformerAdapter {
    public static final DistinctResultTransformer INSTANCE = new DistinctResultTransformer();
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, DistinctResultTransformer.class.getName());

    private DistinctResultTransformer() {
    }

    public List transformList(List list) {
        ArrayList arrayList = new ArrayList(list.size());
        HashSet<Identity> hashSet = new HashSet<Identity>();
        for (int i = 0; i < list.size(); ++i) {
            Object e = list.get(i);
            if (!hashSet.add(new Identity(e))) continue;
            arrayList.add(e);
        }
        LOG.debugf("Transformed: %s rows to: %s distinct results", (Object)list.size(), (Object)arrayList.size());
        return arrayList;
    }

    private Object readResolve() {
        return INSTANCE;
    }

    private static final class Identity {
        final Object entity;

        private Identity(Object object) {
            this.entity = object;
        }

        public boolean equals(Object object) {
            return Identity.class.isInstance(object) && this.entity == ((Identity)object).entity;
        }

        public int hashCode() {
            return System.identityHashCode(this.entity);
        }
    }
}

