/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.transform;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.List;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.transform.PassThroughResultTransformer;
import org.hibernate.transform.ResultTransformer;
import org.hibernate.transform.TupleSubsetResultTransformer;
import org.hibernate.type.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheableResultTransformer
implements ResultTransformer {
    private static final PassThroughResultTransformer ACTUAL_TRANSFORMER = PassThroughResultTransformer.INSTANCE;
    private final int tupleLength;
    private final int tupleSubsetLength;
    private final boolean[] includeInTuple;
    private final int[] includeInTransformIndex;

    public static CacheableResultTransformer create(ResultTransformer resultTransformer, String[] stringArray, boolean[] blArray) {
        return resultTransformer instanceof TupleSubsetResultTransformer ? CacheableResultTransformer.create((TupleSubsetResultTransformer)resultTransformer, stringArray, blArray) : CacheableResultTransformer.create(blArray);
    }

    private static CacheableResultTransformer create(TupleSubsetResultTransformer tupleSubsetResultTransformer, String[] stringArray, boolean[] blArray) {
        if (tupleSubsetResultTransformer == null) {
            throw new IllegalArgumentException("transformer cannot be null");
        }
        int n = ArrayHelper.countTrue(blArray);
        if (stringArray != null && stringArray.length != n) {
            throw new IllegalArgumentException("if aliases is not null, then the length of aliases[] must equal the number of true elements in includeInTuple; aliases.length=" + stringArray.length + "tupleLength=" + n);
        }
        return new CacheableResultTransformer(blArray, tupleSubsetResultTransformer.includeInTransform(stringArray, n));
    }

    private static CacheableResultTransformer create(boolean[] blArray) {
        return new CacheableResultTransformer(blArray, null);
    }

    private CacheableResultTransformer(boolean[] blArray, boolean[] blArray2) {
        if (blArray == null) {
            throw new IllegalArgumentException("includeInTuple cannot be null");
        }
        this.includeInTuple = blArray;
        this.tupleLength = ArrayHelper.countTrue(blArray);
        int n = this.tupleSubsetLength = blArray2 == null ? this.tupleLength : ArrayHelper.countTrue(blArray2);
        if (this.tupleSubsetLength == this.tupleLength) {
            this.includeInTransformIndex = null;
        } else {
            this.includeInTransformIndex = new int[this.tupleSubsetLength];
            int n2 = 0;
            for (int i = 0; i < blArray2.length; ++i) {
                if (!blArray2[i]) continue;
                this.includeInTransformIndex[n2] = i;
                ++n2;
            }
        }
    }

    @Override
    public Object transformTuple(Object[] objectArray, String[] stringArray) {
        if (stringArray != null && stringArray.length != this.tupleLength) {
            throw new IllegalStateException("aliases expected length is " + this.tupleLength + "; actual length is " + stringArray.length);
        }
        return ACTUAL_TRANSFORMER.transformTuple(this.index(objectArray.getClass(), objectArray), null);
    }

    public List retransformResults(List list, String[] stringArray, ResultTransformer resultTransformer, boolean[] blArray) {
        String[] stringArray2;
        if (resultTransformer == null) {
            throw new IllegalArgumentException("transformer cannot be null");
        }
        if (!this.equals(CacheableResultTransformer.create(resultTransformer, stringArray, blArray))) {
            throw new IllegalStateException("this CacheableResultTransformer is inconsistent with specified arguments; cannot re-transform");
        }
        boolean bl = true;
        String[] stringArray3 = stringArray2 = stringArray == null ? null : this.index(stringArray.getClass(), stringArray);
        if (resultTransformer == ACTUAL_TRANSFORMER) {
            bl = false;
        } else if (resultTransformer instanceof TupleSubsetResultTransformer) {
            boolean bl2 = bl = !((TupleSubsetResultTransformer)resultTransformer).isTransformedValueATupleElement(stringArray2, this.tupleLength);
        }
        if (bl) {
            for (int i = 0; i < list.size(); ++i) {
                Object[] objectArray = ACTUAL_TRANSFORMER.untransformToTuple(list.get(i), this.tupleSubsetLength == 1);
                list.set(i, resultTransformer.transformTuple(objectArray, stringArray2));
            }
        }
        return list;
    }

    public List untransformToTuples(List list) {
        if (this.includeInTransformIndex == null) {
            list = ACTUAL_TRANSFORMER.untransformToTuples(list, this.tupleSubsetLength == 1);
        } else {
            for (int i = 0; i < list.size(); ++i) {
                Object[] objectArray = ACTUAL_TRANSFORMER.untransformToTuple(list.get(i), this.tupleSubsetLength == 1);
                list.set(i, this.unindex(objectArray.getClass(), objectArray));
            }
        }
        return list;
    }

    public Type[] getCachedResultTypes(Type[] typeArray) {
        return this.tupleLength != this.tupleSubsetLength ? this.index(typeArray.getClass(), typeArray) : typeArray;
    }

    @Override
    public List transformList(List list) {
        return list;
    }

    private <T> T[] index(Class<? extends T[]> clazz, T[] TArray) {
        T[] TArray2 = TArray;
        if (TArray != null && this.includeInTransformIndex != null && TArray.length != this.tupleSubsetLength) {
            TArray2 = clazz.cast(Array.newInstance(clazz.getComponentType(), this.tupleSubsetLength));
            for (int i = 0; i < this.tupleSubsetLength; ++i) {
                TArray2[i] = TArray[this.includeInTransformIndex[i]];
            }
        }
        return TArray2;
    }

    private <T> T[] unindex(Class<? extends T[]> clazz, T[] TArray) {
        T[] TArray2 = TArray;
        if (TArray != null && this.includeInTransformIndex != null && TArray.length != this.tupleLength) {
            TArray2 = clazz.cast(Array.newInstance(clazz.getComponentType(), this.tupleLength));
            for (int i = 0; i < this.tupleSubsetLength; ++i) {
                TArray2[this.includeInTransformIndex[i]] = TArray[i];
            }
        }
        return TArray2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        CacheableResultTransformer cacheableResultTransformer = (CacheableResultTransformer)object;
        return this.tupleLength == cacheableResultTransformer.tupleLength && this.tupleSubsetLength == cacheableResultTransformer.tupleSubsetLength && Arrays.equals(this.includeInTuple, cacheableResultTransformer.includeInTuple) && Arrays.equals(this.includeInTransformIndex, cacheableResultTransformer.includeInTransformIndex);
    }

    public int hashCode() {
        int n = this.tupleLength;
        n = 31 * n + this.tupleSubsetLength;
        n = 31 * n + (this.includeInTuple != null ? Arrays.hashCode(this.includeInTuple) : 0);
        n = 31 * n + (this.includeInTransformIndex != null ? Arrays.hashCode(this.includeInTransformIndex) : 0);
        return n;
    }
}

