/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.transform;

import java.util.Arrays;
import org.hibernate.HibernateException;
import org.hibernate.property.ChainedPropertyAccessor;
import org.hibernate.property.PropertyAccessor;
import org.hibernate.property.PropertyAccessorFactory;
import org.hibernate.property.Setter;
import org.hibernate.transform.AliasedTupleSubsetResultTransformer;

public class AliasToBeanResultTransformer
extends AliasedTupleSubsetResultTransformer {
    private final Class resultClass;
    private boolean isInitialized;
    private String[] aliases;
    private Setter[] setters;

    public AliasToBeanResultTransformer(Class clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("resultClass cannot be null");
        }
        this.isInitialized = false;
        this.resultClass = clazz;
    }

    public boolean isTransformedValueATupleElement(String[] stringArray, int n) {
        return false;
    }

    public Object transformTuple(Object[] objectArray, String[] stringArray) {
        Object t;
        try {
            if (!this.isInitialized) {
                this.initialize(stringArray);
            } else {
                this.check(stringArray);
            }
            t = this.resultClass.newInstance();
            for (int i = 0; i < stringArray.length; ++i) {
                if (this.setters[i] == null) continue;
                this.setters[i].set(t, objectArray[i], null);
            }
        }
        catch (InstantiationException instantiationException) {
            throw new HibernateException("Could not instantiate resultclass: " + this.resultClass.getName());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new HibernateException("Could not instantiate resultclass: " + this.resultClass.getName());
        }
        return t;
    }

    private void initialize(String[] stringArray) {
        ChainedPropertyAccessor chainedPropertyAccessor = new ChainedPropertyAccessor(new PropertyAccessor[]{PropertyAccessorFactory.getPropertyAccessor(this.resultClass, null), PropertyAccessorFactory.getPropertyAccessor("field")});
        this.aliases = new String[stringArray.length];
        this.setters = new Setter[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (string == null) continue;
            this.aliases[i] = string;
            this.setters[i] = chainedPropertyAccessor.getSetter(this.resultClass, string);
        }
        this.isInitialized = true;
    }

    private void check(String[] stringArray) {
        if (!Arrays.equals(stringArray, this.aliases)) {
            throw new IllegalStateException("aliases are different from what is cached; aliases=" + Arrays.asList(stringArray) + " cached=" + Arrays.asList(this.aliases));
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        AliasToBeanResultTransformer aliasToBeanResultTransformer = (AliasToBeanResultTransformer)object;
        if (!this.resultClass.equals(aliasToBeanResultTransformer.resultClass)) {
            return false;
        }
        return Arrays.equals(this.aliases, aliasToBeanResultTransformer.aliases);
    }

    public int hashCode() {
        int n = this.resultClass.hashCode();
        n = 31 * n + (this.aliases != null ? Arrays.hashCode(this.aliases) : 0);
        return n;
    }
}

