/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.instrument;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.hibernate.bytecode.buildtime.spi.Instrumenter;
import org.hibernate.bytecode.buildtime.spi.Logger;

public abstract class BasicInstrumentationTask
extends Task
implements Instrumenter.Options {
    private final LoggerBridge logger = new LoggerBridge();
    private List filesets = new ArrayList();
    private boolean extended;
    private boolean verbose;

    public void addFileset(FileSet fileSet) {
        this.filesets.add(fileSet);
    }

    protected final Iterator filesets() {
        return this.filesets.iterator();
    }

    public boolean isExtended() {
        return this.extended;
    }

    public void setExtended(boolean bl) {
        this.extended = bl;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    public final boolean performExtendedInstrumentation() {
        return this.isExtended();
    }

    protected abstract Instrumenter buildInstrumenter(Logger var1, Instrumenter.Options var2);

    public void execute() throws BuildException {
        try {
            this.buildInstrumenter(this.logger, this).execute(this.collectSpecifiedFiles());
        }
        catch (Throwable throwable) {
            throw new BuildException(throwable);
        }
    }

    private Set collectSpecifiedFiles() {
        HashSet<File> hashSet = new HashSet<File>();
        Project project = this.getProject();
        Iterator iterator = this.filesets();
        while (iterator.hasNext()) {
            FileSet fileSet = (FileSet)iterator.next();
            DirectoryScanner directoryScanner = fileSet.getDirectoryScanner(project);
            String[] stringArray = directoryScanner.getIncludedFiles();
            File file = fileSet.getDir(project);
            for (int i = 0; i < stringArray.length; ++i) {
                hashSet.add(new File(file, stringArray[i]));
            }
        }
        return hashSet;
    }

    protected class LoggerBridge
    implements Logger {
        protected LoggerBridge() {
        }

        public void trace(String string) {
            BasicInstrumentationTask.this.log(string, 3);
        }

        public void debug(String string) {
            BasicInstrumentationTask.this.log(string, 4);
        }

        public void info(String string) {
            BasicInstrumentationTask.this.log(string, 2);
        }

        public void warn(String string) {
            BasicInstrumentationTask.this.log(string, 1);
        }

        public void error(String string) {
            BasicInstrumentationTask.this.log(string, 0);
        }
    }
}

