/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.hbm2ddl;

import java.sql.Connection;
import java.sql.SQLException;
import org.hibernate.engine.jdbc.spi.SqlExceptionHelper;
import org.hibernate.tool.hbm2ddl.ConnectionHelper;

class SuppliedConnectionHelper
implements ConnectionHelper {
    private Connection connection;
    private boolean toggleAutoCommit;

    public SuppliedConnectionHelper(Connection connection) {
        this.connection = connection;
    }

    public void prepare(boolean bl) throws SQLException {
        boolean bl2 = this.toggleAutoCommit = bl && !this.connection.getAutoCommit();
        if (this.toggleAutoCommit) {
            try {
                this.connection.commit();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.connection.setAutoCommit(true);
        }
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void release() throws SQLException {
        new SqlExceptionHelper().logAndClearWarnings(this.connection);
        if (this.toggleAutoCommit) {
            this.connection.setAutoCommit(false);
        }
        this.connection = null;
    }
}

