/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.hbm2ddl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.LinkedList;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.tool.hbm2ddl.ImportScriptException;
import org.hibernate.tool.hbm2ddl.ImportSqlCommandExtractor;

public class SingleLineSqlCommandExtractor
implements ImportSqlCommandExtractor {
    public String[] extractCommands(Reader reader) {
        BufferedReader bufferedReader = new BufferedReader(reader);
        LinkedList<String> linkedList = new LinkedList<String>();
        try {
            String string = bufferedReader.readLine();
            while (string != null) {
                String string2 = string.trim();
                if (!StringHelper.isEmpty(string2) && !this.isComment(string2)) {
                    if (string2.endsWith(";")) {
                        string2 = string2.substring(0, string2.length() - 1);
                    }
                    linkedList.add(string2);
                }
                string = bufferedReader.readLine();
            }
            return linkedList.toArray(new String[linkedList.size()]);
        }
        catch (IOException iOException) {
            throw new ImportScriptException("Error during import script parsing.", iOException);
        }
    }

    private boolean isComment(String string) {
        return string.startsWith("--") || string.startsWith("//") || string.startsWith("/*");
    }
}

