/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.hbm2ddl;

import java.io.FileInputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.cfg.Configuration;
import org.hibernate.cfg.Environment;
import org.hibernate.cfg.NamingStrategy;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.ServiceRegistryBuilder;
import org.hibernate.service.internal.StandardServiceRegistryImpl;
import org.hibernate.tool.hbm2ddl.ConnectionHelper;
import org.hibernate.tool.hbm2ddl.DatabaseMetadata;
import org.hibernate.tool.hbm2ddl.ManagedProviderConnectionHelper;
import org.hibernate.tool.hbm2ddl.SuppliedConnectionProviderConnectionHelper;
import org.jboss.logging.Logger;

public class SchemaValidator {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, SchemaValidator.class.getName());
    private ConnectionHelper connectionHelper;
    private Configuration configuration;
    private Dialect dialect;

    public SchemaValidator(Configuration configuration) throws HibernateException {
        this(configuration, configuration.getProperties());
    }

    public SchemaValidator(Configuration configuration, Properties properties) throws HibernateException {
        this.configuration = configuration;
        this.dialect = Dialect.getDialect(properties);
        Properties properties2 = new Properties();
        properties2.putAll((Map<?, ?>)this.dialect.getDefaultProperties());
        properties2.putAll((Map<?, ?>)properties);
        this.connectionHelper = new ManagedProviderConnectionHelper(properties2);
    }

    public SchemaValidator(ServiceRegistry serviceRegistry, Configuration configuration) throws HibernateException {
        this.configuration = configuration;
        JdbcServices jdbcServices = serviceRegistry.getService(JdbcServices.class);
        this.dialect = jdbcServices.getDialect();
        this.connectionHelper = new SuppliedConnectionProviderConnectionHelper(jdbcServices.getConnectionProvider());
    }

    private static StandardServiceRegistryImpl createServiceRegistry(Properties properties) {
        Environment.verifyProperties(properties);
        ConfigurationHelper.resolvePlaceHolders(properties);
        return (StandardServiceRegistryImpl)new ServiceRegistryBuilder().applySettings(properties).buildServiceRegistry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        try {
            Configuration configuration = new Configuration();
            String string = null;
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].startsWith("--")) {
                    if (stringArray[i].startsWith("--properties=")) {
                        string = stringArray[i].substring(13);
                        continue;
                    }
                    if (stringArray[i].startsWith("--config=")) {
                        configuration.configure(stringArray[i].substring(9));
                        continue;
                    }
                    if (!stringArray[i].startsWith("--naming=")) continue;
                    configuration.setNamingStrategy((NamingStrategy)ReflectHelper.classForName(stringArray[i].substring(9)).newInstance());
                    continue;
                }
                configuration.addFile(stringArray[i]);
            }
            if (string != null) {
                Properties properties = new Properties();
                properties.putAll((Map<?, ?>)configuration.getProperties());
                properties.load(new FileInputStream(string));
                configuration.setProperties(properties);
            }
            StandardServiceRegistryImpl standardServiceRegistryImpl = SchemaValidator.createServiceRegistry(configuration.getProperties());
            try {
                new SchemaValidator(standardServiceRegistryImpl, configuration).validate();
            }
            finally {
                standardServiceRegistryImpl.destroy();
            }
        }
        catch (Exception exception) {
            LOG.unableToRunSchemaUpdate(exception);
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validate() {
        LOG.runningSchemaValidator();
        Connection connection = null;
        try {
            DatabaseMetadata databaseMetadata;
            try {
                LOG.fetchingDatabaseMetadata();
                this.connectionHelper.prepare(false);
                connection = this.connectionHelper.getConnection();
                databaseMetadata = new DatabaseMetadata(connection, this.dialect, this.configuration, false);
            }
            catch (SQLException sQLException) {
                LOG.unableToGetDatabaseMetadata(sQLException);
                throw sQLException;
            }
            this.configuration.validateSchema(this.dialect, databaseMetadata);
        }
        catch (SQLException sQLException) {
            LOG.unableToCompleteSchemaValidation(sQLException);
        }
        finally {
            try {
                this.connectionHelper.release();
            }
            catch (Exception exception) {
                LOG.unableToCloseConnection(exception);
            }
        }
    }
}

