/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.hbm2ddl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.FileSet;
import org.hibernate.HibernateException;
import org.hibernate.cfg.Configuration;
import org.hibernate.cfg.NamingStrategy;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.tool.hbm2ddl.SchemaUpdate;

public class SchemaUpdateTask
extends MatchingTask {
    private List fileSets = new LinkedList();
    private File propertiesFile = null;
    private File configurationFile = null;
    private File outputFile = null;
    private boolean quiet = false;
    private boolean text = true;
    private boolean haltOnError = false;
    private String delimiter = null;
    private String namingStrategy = null;

    public void addFileset(FileSet fileSet) {
        this.fileSets.add(fileSet);
    }

    public void setProperties(File file) {
        if (!file.exists()) {
            throw new BuildException("Properties file: " + file + " does not exist.");
        }
        this.log("Using properties file " + file, 4);
        this.propertiesFile = file;
    }

    public void setConfig(File file) {
        this.configurationFile = file;
    }

    public void setText(boolean bl) {
        this.text = bl;
    }

    public void setQuiet(boolean bl) {
        this.quiet = bl;
    }

    public void execute() throws BuildException {
        try {
            this.log("Running Hibernate Core SchemaUpdate.");
            this.log("This is an Ant task supporting only mapping files, if you want to use annotations see http://tools.hibernate.org.");
            Configuration configuration = this.getConfiguration();
            this.getSchemaUpdate(configuration).execute(!this.quiet, !this.text);
        }
        catch (HibernateException hibernateException) {
            throw new BuildException("Schema text failed: " + hibernateException.getMessage(), (Throwable)hibernateException);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new BuildException("File not found: " + fileNotFoundException.getMessage(), (Throwable)fileNotFoundException);
        }
        catch (IOException iOException) {
            throw new BuildException("IOException : " + iOException.getMessage(), (Throwable)iOException);
        }
        catch (Exception exception) {
            throw new BuildException((Throwable)exception);
        }
    }

    private String[] getFiles() {
        LinkedList<String> linkedList = new LinkedList<String>();
        for (FileSet fileSet : this.fileSets) {
            DirectoryScanner directoryScanner = fileSet.getDirectoryScanner(this.getProject());
            String[] stringArray = directoryScanner.getIncludedFiles();
            for (int i = 0; i < stringArray.length; ++i) {
                File file = new File(stringArray[i]);
                if (!file.isFile()) {
                    file = new File(directoryScanner.getBasedir(), stringArray[i]);
                }
                linkedList.add(file.getAbsolutePath());
            }
        }
        return ArrayHelper.toStringArray(linkedList);
    }

    private Configuration getConfiguration() throws Exception {
        Configuration configuration = new Configuration();
        if (this.namingStrategy != null) {
            configuration.setNamingStrategy((NamingStrategy)ReflectHelper.classForName(this.namingStrategy).newInstance());
        }
        if (this.configurationFile != null) {
            configuration.configure(this.configurationFile);
        }
        String[] stringArray = this.getFiles();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (string.endsWith(".jar")) {
                configuration.addJar(new File(string));
                continue;
            }
            configuration.addFile(string);
        }
        return configuration;
    }

    private SchemaUpdate getSchemaUpdate(Configuration configuration) throws HibernateException, IOException {
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)configuration.getProperties());
        if (this.propertiesFile == null) {
            properties.putAll((Map<?, ?>)this.getProject().getProperties());
        } else {
            properties.load(new FileInputStream(this.propertiesFile));
        }
        configuration.setProperties(properties);
        SchemaUpdate schemaUpdate = new SchemaUpdate(configuration);
        schemaUpdate.setOutputFile(this.outputFile.getPath());
        schemaUpdate.setDelimiter(this.delimiter);
        schemaUpdate.setHaltOnError(this.haltOnError);
        return schemaUpdate;
    }

    public void setNamingStrategy(String string) {
        this.namingStrategy = string;
    }

    public File getOutputFile() {
        return this.outputFile;
    }

    public void setOutputFile(File file) {
        this.outputFile = file;
    }

    public boolean isHaltOnError() {
        return this.haltOnError;
    }

    public void setHaltOnError(boolean bl) {
        this.haltOnError = bl;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(String string) {
        this.delimiter = string;
    }
}

