/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.hbm2ddl;

import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.JDBCException;
import org.hibernate.cfg.Configuration;
import org.hibernate.cfg.Environment;
import org.hibernate.cfg.NamingStrategy;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.internal.FormatStyle;
import org.hibernate.engine.jdbc.internal.Formatter;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.jdbc.spi.SqlExceptionHelper;
import org.hibernate.engine.jdbc.spi.SqlStatementLogger;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.ServiceRegistryBuilder;
import org.hibernate.service.internal.StandardServiceRegistryImpl;
import org.hibernate.tool.hbm2ddl.ConnectionHelper;
import org.hibernate.tool.hbm2ddl.DatabaseMetadata;
import org.hibernate.tool.hbm2ddl.ManagedProviderConnectionHelper;
import org.hibernate.tool.hbm2ddl.SchemaUpdateScript;
import org.hibernate.tool.hbm2ddl.SuppliedConnectionProviderConnectionHelper;
import org.hibernate.tool.hbm2ddl.Target;
import org.jboss.logging.Logger;

public class SchemaUpdate {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, SchemaUpdate.class.getName());
    private final Configuration configuration;
    private final ConnectionHelper connectionHelper;
    private final SqlStatementLogger sqlStatementLogger;
    private final SqlExceptionHelper sqlExceptionHelper;
    private final Dialect dialect;
    private final List<Exception> exceptions = new ArrayList<Exception>();
    private Formatter formatter;
    private boolean haltOnError = false;
    private boolean format = true;
    private String outputFile = null;
    private String delimiter;

    public SchemaUpdate(Configuration configuration) throws HibernateException {
        this(configuration, configuration.getProperties());
    }

    public SchemaUpdate(Configuration configuration, Properties properties) throws HibernateException {
        this.configuration = configuration;
        this.dialect = Dialect.getDialect(properties);
        Properties properties2 = new Properties();
        properties2.putAll((Map<?, ?>)this.dialect.getDefaultProperties());
        properties2.putAll((Map<?, ?>)properties);
        this.connectionHelper = new ManagedProviderConnectionHelper(properties2);
        this.sqlExceptionHelper = new SqlExceptionHelper();
        this.sqlStatementLogger = new SqlStatementLogger(false, true);
        this.formatter = FormatStyle.DDL.getFormatter();
    }

    public SchemaUpdate(ServiceRegistry serviceRegistry, Configuration configuration) throws HibernateException {
        this.configuration = configuration;
        JdbcServices jdbcServices = serviceRegistry.getService(JdbcServices.class);
        this.dialect = jdbcServices.getDialect();
        this.connectionHelper = new SuppliedConnectionProviderConnectionHelper(jdbcServices.getConnectionProvider());
        this.sqlExceptionHelper = new SqlExceptionHelper();
        this.sqlStatementLogger = jdbcServices.getSqlStatementLogger();
        this.formatter = (this.sqlStatementLogger.isFormat() ? FormatStyle.DDL : FormatStyle.NONE).getFormatter();
    }

    private static StandardServiceRegistryImpl createServiceRegistry(Properties properties) {
        Environment.verifyProperties(properties);
        ConfigurationHelper.resolvePlaceHolders(properties);
        return (StandardServiceRegistryImpl)new ServiceRegistryBuilder().applySettings(properties).buildServiceRegistry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        try {
            Configuration configuration = new Configuration();
            boolean bl = true;
            boolean bl2 = true;
            String string = null;
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].startsWith("--")) {
                    if (stringArray[i].equals("--quiet")) {
                        bl = false;
                        continue;
                    }
                    if (stringArray[i].startsWith("--properties=")) {
                        string = stringArray[i].substring(13);
                        continue;
                    }
                    if (stringArray[i].startsWith("--config=")) {
                        configuration.configure(stringArray[i].substring(9));
                        continue;
                    }
                    if (stringArray[i].startsWith("--text")) {
                        bl2 = false;
                        continue;
                    }
                    if (!stringArray[i].startsWith("--naming=")) continue;
                    configuration.setNamingStrategy((NamingStrategy)ReflectHelper.classForName(stringArray[i].substring(9)).newInstance());
                    continue;
                }
                configuration.addFile(stringArray[i]);
            }
            if (string != null) {
                Properties properties = new Properties();
                properties.putAll((Map<?, ?>)configuration.getProperties());
                properties.load(new FileInputStream(string));
                configuration.setProperties(properties);
            }
            StandardServiceRegistryImpl standardServiceRegistryImpl = SchemaUpdate.createServiceRegistry(configuration.getProperties());
            try {
                new SchemaUpdate(standardServiceRegistryImpl, configuration).execute(bl, bl2);
            }
            finally {
                standardServiceRegistryImpl.destroy();
            }
        }
        catch (Exception exception) {
            LOG.unableToRunSchemaUpdate(exception);
            exception.printStackTrace();
        }
    }

    public void execute(boolean bl, boolean bl2) {
        this.execute(Target.interpret(bl, bl2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Target target) {
        LOG.runningHbm2ddlSchemaUpdate();
        Connection connection = null;
        Statement statement = null;
        Writer writer = null;
        this.exceptions.clear();
        try {
            DatabaseMetadata databaseMetadata;
            try {
                LOG.fetchingDatabaseMetadata();
                this.connectionHelper.prepare(true);
                connection = this.connectionHelper.getConnection();
                databaseMetadata = new DatabaseMetadata(connection, this.dialect, this.configuration);
                statement = connection.createStatement();
            }
            catch (SQLException sQLException) {
                this.exceptions.add(sQLException);
                LOG.unableToGetDatabaseMetadata(sQLException);
                throw sQLException;
            }
            LOG.updatingSchema();
            if (this.outputFile != null) {
                LOG.writingGeneratedSchemaToFile(this.outputFile);
                writer = new FileWriter(this.outputFile);
            }
            List<SchemaUpdateScript> list = this.configuration.generateSchemaUpdateScriptList(this.dialect, databaseMetadata);
            for (SchemaUpdateScript schemaUpdateScript : list) {
                String string = this.formatter.format(schemaUpdateScript.getScript());
                try {
                    if (this.delimiter != null) {
                        string = string + this.delimiter;
                    }
                    if (target.doScript()) {
                        System.out.println(string);
                    }
                    if (this.outputFile != null) {
                        writer.write(string + "\n");
                    }
                    if (!target.doExport()) continue;
                    LOG.debug(schemaUpdateScript.getScript());
                    statement.executeUpdate(string);
                }
                catch (SQLException sQLException) {
                    if (schemaUpdateScript.isQuiet()) continue;
                    if (this.haltOnError) {
                        throw new JDBCException("Error during DDL export", sQLException);
                    }
                    this.exceptions.add(sQLException);
                    LOG.unsuccessful(schemaUpdateScript.getScript());
                    LOG.error(sQLException.getMessage());
                }
            }
            LOG.schemaUpdateComplete();
        }
        catch (Exception exception) {
            this.exceptions.add(exception);
            LOG.unableToCompleteSchemaUpdate(exception);
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
                this.connectionHelper.release();
            }
            catch (Exception exception) {
                this.exceptions.add(exception);
                LOG.unableToCloseConnection(exception);
            }
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (Exception exception) {
                this.exceptions.add(exception);
                LOG.unableToCloseConnection(exception);
            }
        }
    }

    public List getExceptions() {
        return this.exceptions;
    }

    public void setHaltOnError(boolean bl) {
        this.haltOnError = bl;
    }

    public void setFormat(boolean bl) {
        this.formatter = (bl ? FormatStyle.DDL : FormatStyle.NONE).getFormatter();
    }

    public void setOutputFile(String string) {
        this.outputFile = string;
    }

    public void setDelimiter(String string) {
        this.delimiter = string;
    }
}

