/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.hbm2ddl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.cfg.Configuration;
import org.hibernate.cfg.Environment;
import org.hibernate.cfg.NamingStrategy;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.internal.FormatStyle;
import org.hibernate.engine.jdbc.internal.Formatter;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.jdbc.spi.SqlExceptionHelper;
import org.hibernate.engine.jdbc.spi.SqlStatementLogger;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.ConfigHelper;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.metamodel.source.MetadataImplementor;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.ServiceRegistryBuilder;
import org.hibernate.service.config.spi.ConfigurationService;
import org.hibernate.service.internal.StandardServiceRegistryImpl;
import org.hibernate.service.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.tool.hbm2ddl.ConnectionHelper;
import org.hibernate.tool.hbm2ddl.DatabaseExporter;
import org.hibernate.tool.hbm2ddl.Exporter;
import org.hibernate.tool.hbm2ddl.FileExporter;
import org.hibernate.tool.hbm2ddl.ImportScriptException;
import org.hibernate.tool.hbm2ddl.ImportSqlCommandExtractor;
import org.hibernate.tool.hbm2ddl.ImportSqlCommandExtractorInitiator;
import org.hibernate.tool.hbm2ddl.ManagedProviderConnectionHelper;
import org.hibernate.tool.hbm2ddl.ScriptExporter;
import org.hibernate.tool.hbm2ddl.SuppliedConnectionHelper;
import org.hibernate.tool.hbm2ddl.SuppliedConnectionProviderConnectionHelper;
import org.hibernate.tool.hbm2ddl.Target;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchemaExport {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, SchemaExport.class.getName());
    private static final String DEFAULT_IMPORT_FILE = "/import.sql";
    private final ConnectionHelper connectionHelper;
    private final SqlStatementLogger sqlStatementLogger;
    private final SqlExceptionHelper sqlExceptionHelper;
    private final String[] dropSQL;
    private final String[] createSQL;
    private final String importFiles;
    private final List<Exception> exceptions = new ArrayList<Exception>();
    private Formatter formatter;
    private ImportSqlCommandExtractor importSqlCommandExtractor = ImportSqlCommandExtractorInitiator.DEFAULT_EXTRACTOR;
    private String outputFile = null;
    private String delimiter;
    private boolean haltOnError = false;

    public SchemaExport(ServiceRegistry serviceRegistry, Configuration configuration) {
        this.connectionHelper = new SuppliedConnectionProviderConnectionHelper(serviceRegistry.getService(ConnectionProvider.class));
        this.sqlStatementLogger = serviceRegistry.getService(JdbcServices.class).getSqlStatementLogger();
        this.formatter = (this.sqlStatementLogger.isFormat() ? FormatStyle.DDL : FormatStyle.NONE).getFormatter();
        this.sqlExceptionHelper = serviceRegistry.getService(JdbcServices.class).getSqlExceptionHelper();
        this.importFiles = ConfigurationHelper.getString("hibernate.hbm2ddl.import_files", configuration.getProperties(), DEFAULT_IMPORT_FILE);
        Dialect dialect = serviceRegistry.getService(JdbcServices.class).getDialect();
        this.dropSQL = configuration.generateDropSchemaScript(dialect);
        this.createSQL = configuration.generateSchemaCreationScript(dialect);
    }

    public SchemaExport(MetadataImplementor metadataImplementor) {
        ServiceRegistry serviceRegistry = metadataImplementor.getServiceRegistry();
        this.connectionHelper = new SuppliedConnectionProviderConnectionHelper(serviceRegistry.getService(ConnectionProvider.class));
        JdbcServices jdbcServices = serviceRegistry.getService(JdbcServices.class);
        this.sqlStatementLogger = jdbcServices.getSqlStatementLogger();
        this.formatter = (this.sqlStatementLogger.isFormat() ? FormatStyle.DDL : FormatStyle.NONE).getFormatter();
        this.sqlExceptionHelper = jdbcServices.getSqlExceptionHelper();
        this.importFiles = ConfigurationHelper.getString("hibernate.hbm2ddl.import_files", serviceRegistry.getService(ConfigurationService.class).getSettings(), DEFAULT_IMPORT_FILE);
        Dialect dialect = jdbcServices.getDialect();
        this.dropSQL = metadataImplementor.getDatabase().generateDropSchemaScript(dialect);
        this.createSQL = metadataImplementor.getDatabase().generateSchemaCreationScript(dialect);
    }

    public SchemaExport(Configuration configuration) {
        this(configuration, configuration.getProperties());
    }

    @Deprecated
    public SchemaExport(Configuration configuration, Properties properties) throws HibernateException {
        Dialect dialect = Dialect.getDialect(properties);
        Properties properties2 = new Properties();
        properties2.putAll((Map<?, ?>)dialect.getDefaultProperties());
        properties2.putAll((Map<?, ?>)properties);
        this.connectionHelper = new ManagedProviderConnectionHelper(properties2);
        this.sqlStatementLogger = new SqlStatementLogger(false, true);
        this.formatter = FormatStyle.DDL.getFormatter();
        this.sqlExceptionHelper = new SqlExceptionHelper();
        this.importFiles = ConfigurationHelper.getString("hibernate.hbm2ddl.import_files", properties, DEFAULT_IMPORT_FILE);
        this.dropSQL = configuration.generateDropSchemaScript(dialect);
        this.createSQL = configuration.generateSchemaCreationScript(dialect);
    }

    public SchemaExport(Configuration configuration, Connection connection) throws HibernateException {
        this.connectionHelper = new SuppliedConnectionHelper(connection);
        this.sqlStatementLogger = new SqlStatementLogger(false, true);
        this.formatter = FormatStyle.DDL.getFormatter();
        this.sqlExceptionHelper = new SqlExceptionHelper();
        this.importFiles = ConfigurationHelper.getString("hibernate.hbm2ddl.import_files", configuration.getProperties(), DEFAULT_IMPORT_FILE);
        Dialect dialect = Dialect.getDialect(configuration.getProperties());
        this.dropSQL = configuration.generateDropSchemaScript(dialect);
        this.createSQL = configuration.generateSchemaCreationScript(dialect);
    }

    public SchemaExport(ConnectionHelper connectionHelper, String[] stringArray, String[] stringArray2) {
        this.connectionHelper = connectionHelper;
        this.dropSQL = stringArray;
        this.createSQL = stringArray2;
        this.importFiles = "";
        this.sqlStatementLogger = new SqlStatementLogger(false, true);
        this.sqlExceptionHelper = new SqlExceptionHelper();
        this.formatter = FormatStyle.DDL.getFormatter();
    }

    public SchemaExport setOutputFile(String string) {
        this.outputFile = string;
        return this;
    }

    public SchemaExport setDelimiter(String string) {
        this.delimiter = string;
        return this;
    }

    public SchemaExport setFormat(boolean bl) {
        this.formatter = (bl ? FormatStyle.DDL : FormatStyle.NONE).getFormatter();
        return this;
    }

    public SchemaExport setImportSqlCommandExtractor(ImportSqlCommandExtractor importSqlCommandExtractor) {
        this.importSqlCommandExtractor = importSqlCommandExtractor;
        return this;
    }

    public SchemaExport setHaltOnError(boolean bl) {
        this.haltOnError = bl;
        return this;
    }

    public void create(boolean bl, boolean bl2) {
        this.create(Target.interpret(bl, bl2));
    }

    public void create(Target target) {
        this.execute(target, Type.BOTH);
    }

    public void drop(boolean bl, boolean bl2) {
        this.drop(Target.interpret(bl, bl2));
    }

    public void drop(Target target) {
        this.execute(target, Type.DROP);
    }

    public void execute(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.execute(Target.interpret(bl, bl2), this.interpretType(bl3, bl4));
    }

    private Type interpretType(boolean bl, boolean bl2) {
        if (bl) {
            return Type.DROP;
        }
        if (bl2) {
            return Type.CREATE;
        }
        return Type.BOTH;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Target target, Type type) {
        if (this.outputFile == null && target == Target.NONE || type == Type.NONE) {
            return;
        }
        this.exceptions.clear();
        LOG.runningHbm2ddlSchemaExport();
        ArrayList<NamedReader> arrayList = new ArrayList<NamedReader>();
        for (String string : this.importFiles.split(",")) {
            try {
                String string2 = string.trim();
                InputStream inputStream = ConfigHelper.getResourceAsStream(string2);
                arrayList.add(new NamedReader(string2, inputStream));
            }
            catch (HibernateException hibernateException) {
                LOG.debugf("Import file not found: %s", (Object)string);
            }
        }
        ArrayList arrayList2 = new ArrayList();
        try {
            if (target.doScript()) {
                arrayList2.add(new ScriptExporter());
            }
            if (this.outputFile != null) {
                arrayList2.add(new FileExporter(this.outputFile));
            }
            if (target.doExport()) {
                arrayList2.add(new DatabaseExporter(this.connectionHelper, this.sqlExceptionHelper));
            }
            if (type.doDrop()) {
                this.perform(this.dropSQL, arrayList2);
            }
            if (type.doCreate()) {
                this.perform(this.createSQL, arrayList2);
                if (!arrayList.isEmpty()) {
                    for (NamedReader namedReader : arrayList) {
                        this.importScript(namedReader, arrayList2);
                    }
                }
            }
        }
        catch (Exception exception) {
            this.exceptions.add(exception);
            LOG.schemaExportUnsuccessful(exception);
        }
        finally {
            Iterator iterator2 = arrayList2.iterator();
            while (iterator2.hasNext()) {
                Exporter exporter = (Exporter)iterator2.next();
                try {
                    exporter.release();
                }
                catch (Exception exception4) {}
            }
            for (NamedReader namedReader : arrayList) {
                try {
                    namedReader.getReader().close();
                }
                catch (Exception exception5) {}
            }
            LOG.schemaExportComplete();
        }
    }

    private void perform(String[] stringArray, List<Exporter> list) {
        for (String string : stringArray) {
            String string2 = this.formatter.format(string);
            if (this.delimiter != null) {
                string2 = string2 + this.delimiter;
            }
            this.sqlStatementLogger.logStatement(string, this.formatter);
            for (Exporter exporter : list) {
                try {
                    exporter.export(string2);
                }
                catch (Exception exception) {
                    if (this.haltOnError) {
                        throw new HibernateException("Error during DDL export", exception);
                    }
                    this.exceptions.add(exception);
                    LOG.unsuccessfulCreate(string);
                    LOG.error(exception.getMessage());
                }
            }
        }
    }

    private void importScript(NamedReader namedReader, List<Exporter> list) throws Exception {
        BufferedReader bufferedReader = new BufferedReader(namedReader.getReader());
        String[] stringArray = this.importSqlCommandExtractor.extractCommands(bufferedReader);
        if (stringArray != null) {
            for (String string : stringArray) {
                if (string == null) continue;
                String string2 = string.trim();
                if (string2.endsWith(";")) {
                    string2 = string2.substring(0, string.length() - 1);
                }
                if (StringHelper.isEmpty(string2)) continue;
                try {
                    for (Exporter exporter : list) {
                        if (!exporter.acceptsImportScripts()) continue;
                        exporter.export(string2);
                    }
                }
                catch (Exception exception) {
                    throw new ImportScriptException("Error during statement execution (file: '" + namedReader.getName() + "'): " + string2, exception);
                }
            }
        }
    }

    private void execute(boolean bl, boolean bl2, Writer writer, Statement statement, String string) throws IOException, SQLException {
        SqlExceptionHelper sqlExceptionHelper = new SqlExceptionHelper();
        String string2 = this.formatter.format(string);
        if (this.delimiter != null) {
            string2 = string2 + this.delimiter;
        }
        if (bl) {
            System.out.println(string2);
        }
        LOG.debug(string2);
        if (this.outputFile != null) {
            writer.write(string2 + "\n");
        }
        if (bl2) {
            statement.executeUpdate(string);
            try {
                SQLWarning sQLWarning = statement.getWarnings();
                if (sQLWarning != null) {
                    sqlExceptionHelper.logAndClearWarnings(this.connectionHelper.getConnection());
                }
            }
            catch (SQLException sQLException) {
                LOG.unableToLogSqlWarnings(sQLException);
            }
        }
    }

    private static StandardServiceRegistryImpl createServiceRegistry(Properties properties) {
        Environment.verifyProperties(properties);
        ConfigurationHelper.resolvePlaceHolders(properties);
        return (StandardServiceRegistryImpl)new ServiceRegistryBuilder().applySettings(properties).buildServiceRegistry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        try {
            Object object;
            Configuration configuration = new Configuration();
            boolean bl = true;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = true;
            String string = null;
            String string2 = DEFAULT_IMPORT_FILE;
            String string3 = null;
            boolean bl6 = false;
            String string4 = null;
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].startsWith("--")) {
                    if (stringArray[i].equals("--quiet")) {
                        bl = false;
                        continue;
                    }
                    if (stringArray[i].equals("--drop")) {
                        bl2 = true;
                        continue;
                    }
                    if (stringArray[i].equals("--create")) {
                        bl3 = true;
                        continue;
                    }
                    if (stringArray[i].equals("--haltonerror")) {
                        bl4 = true;
                        continue;
                    }
                    if (stringArray[i].equals("--text")) {
                        bl5 = false;
                        continue;
                    }
                    if (stringArray[i].startsWith("--output=")) {
                        string = stringArray[i].substring(9);
                        continue;
                    }
                    if (stringArray[i].startsWith("--import=")) {
                        string2 = stringArray[i].substring(9);
                        continue;
                    }
                    if (stringArray[i].startsWith("--properties=")) {
                        string3 = stringArray[i].substring(13);
                        continue;
                    }
                    if (stringArray[i].equals("--format")) {
                        bl6 = true;
                        continue;
                    }
                    if (stringArray[i].startsWith("--delimiter=")) {
                        string4 = stringArray[i].substring(12);
                        continue;
                    }
                    if (stringArray[i].startsWith("--config=")) {
                        configuration.configure(stringArray[i].substring(9));
                        continue;
                    }
                    if (!stringArray[i].startsWith("--naming=")) continue;
                    configuration.setNamingStrategy((NamingStrategy)ReflectHelper.classForName(stringArray[i].substring(9)).newInstance());
                    continue;
                }
                object = stringArray[i];
                if (((String)object).endsWith(".jar")) {
                    configuration.addJar(new File((String)object));
                    continue;
                }
                configuration.addFile((String)object);
            }
            if (string3 != null) {
                Properties properties = new Properties();
                properties.putAll((Map<?, ?>)configuration.getProperties());
                properties.load(new FileInputStream(string3));
                configuration.setProperties(properties);
            }
            if (string2 != null) {
                configuration.setProperty("hibernate.hbm2ddl.import_files", string2);
            }
            StandardServiceRegistryImpl standardServiceRegistryImpl = SchemaExport.createServiceRegistry(configuration.getProperties());
            try {
                object = new SchemaExport(standardServiceRegistryImpl, configuration).setHaltOnError(bl4).setOutputFile(string).setDelimiter(string4).setImportSqlCommandExtractor(standardServiceRegistryImpl.getService(ImportSqlCommandExtractor.class));
                if (bl6) {
                    ((SchemaExport)object).setFormat(true);
                }
                ((SchemaExport)object).execute(bl, bl5, bl2, bl3);
            }
            finally {
                standardServiceRegistryImpl.destroy();
            }
        }
        catch (Exception exception) {
            LOG.unableToCreateSchema(exception);
            exception.printStackTrace();
        }
    }

    public List getExceptions() {
        return this.exceptions;
    }

    private static class NamedReader {
        private final Reader reader;
        private final String name;

        public NamedReader(String string, InputStream inputStream) {
            this.name = string;
            this.reader = new InputStreamReader(inputStream);
        }

        public Reader getReader() {
            return this.reader;
        }

        public String getName() {
            return this.name;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        CREATE,
        DROP,
        NONE,
        BOTH;


        public boolean doCreate() {
            return this == BOTH || this == CREATE;
        }

        public boolean doDrop() {
            return this == BOTH || this == DROP;
        }
    }
}

