/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.hbm2ddl;

import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.service.classloading.spi.ClassLoaderService;
import org.hibernate.service.spi.BasicServiceInitiator;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.tool.hbm2ddl.ImportSqlCommandExtractor;
import org.hibernate.tool.hbm2ddl.SingleLineSqlCommandExtractor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportSqlCommandExtractorInitiator
implements BasicServiceInitiator<ImportSqlCommandExtractor> {
    public static final ImportSqlCommandExtractorInitiator INSTANCE = new ImportSqlCommandExtractorInitiator();
    public static final ImportSqlCommandExtractor DEFAULT_EXTRACTOR = new SingleLineSqlCommandExtractor();

    @Override
    public ImportSqlCommandExtractor initiateService(Map map, ServiceRegistryImplementor serviceRegistryImplementor) {
        String string = (String)map.get("hibernate.hbm2ddl.import_files_sql_extractor");
        if (StringHelper.isEmpty(string)) {
            return DEFAULT_EXTRACTOR;
        }
        ClassLoaderService classLoaderService = serviceRegistryImplementor.getService(ClassLoaderService.class);
        return this.instantiateExplicitCommandExtractor(string, classLoaderService);
    }

    private ImportSqlCommandExtractor instantiateExplicitCommandExtractor(String string, ClassLoaderService classLoaderService) {
        try {
            return (ImportSqlCommandExtractor)classLoaderService.classForName(string).newInstance();
        }
        catch (Exception exception) {
            throw new HibernateException("Could not instantiate import sql command extractor [" + string + "]", exception);
        }
    }

    @Override
    public Class<ImportSqlCommandExtractor> getServiceInitiated() {
        return ImportSqlCommandExtractor.class;
    }
}

