/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.hbm2ddl;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.ForeignKey;

public class ForeignKeyMetadata {
    private final String name;
    private final String refTable;
    private final Map references = new HashMap();

    ForeignKeyMetadata(ResultSet resultSet) throws SQLException {
        this.name = resultSet.getString("FK_NAME");
        this.refTable = resultSet.getString("PKTABLE_NAME");
    }

    public String getName() {
        return this.name;
    }

    public String getReferencedTableName() {
        return this.refTable;
    }

    void addReference(ResultSet resultSet) throws SQLException {
        this.references.put(resultSet.getString("FKCOLUMN_NAME").toLowerCase(), resultSet.getString("PKCOLUMN_NAME"));
    }

    private boolean hasReference(Column column, Column column2) {
        String string = (String)this.references.get(column.getName().toLowerCase());
        return column2.getName().equalsIgnoreCase(string);
    }

    public boolean matches(ForeignKey foreignKey) {
        if (this.refTable.equalsIgnoreCase(foreignKey.getReferencedTable().getName()) && foreignKey.getColumnSpan() == this.references.size()) {
            List list = foreignKey.isReferenceToPrimaryKey() ? foreignKey.getReferencedTable().getPrimaryKey().getColumns() : foreignKey.getReferencedColumns();
            for (int i = 0; i < foreignKey.getColumnSpan(); ++i) {
                Column column;
                Column column2 = foreignKey.getColumn(i);
                if (this.hasReference(column2, column = (Column)list.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        return "ForeignKeyMetadata(" + this.name + ')';
    }
}

