/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.hbm2ddl;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.hibernate.HibernateException;
import org.hibernate.cfg.Configuration;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.spi.SqlExceptionHelper;
import org.hibernate.exception.spi.SQLExceptionConverter;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.mapping.Table;
import org.hibernate.tool.hbm2ddl.TableMetadata;
import org.jboss.logging.Logger;

public class DatabaseMetadata {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, DatabaseMetaData.class.getName());
    private final Map tables = new HashMap();
    private final Set sequences = new HashSet();
    private final boolean extras;
    private DatabaseMetaData meta;
    private SQLExceptionConverter sqlExceptionConverter;
    private final String[] types;

    @Deprecated
    public DatabaseMetadata(Connection connection, Dialect dialect) throws SQLException {
        this(connection, dialect, null, true);
    }

    @Deprecated
    public DatabaseMetadata(Connection connection, Dialect dialect, boolean bl) throws SQLException {
        this(connection, dialect, null, bl);
    }

    public DatabaseMetadata(Connection connection, Dialect dialect, Configuration configuration) throws SQLException {
        this(connection, dialect, configuration, true);
    }

    public DatabaseMetadata(Connection connection, Dialect dialect, Configuration configuration, boolean bl) throws SQLException {
        this.sqlExceptionConverter = dialect.buildSQLExceptionConverter();
        this.meta = connection.getMetaData();
        this.extras = bl;
        this.initSequences(connection, dialect);
        this.types = configuration != null && ConfigurationHelper.getBoolean("hibernate.synonyms", configuration.getProperties(), false) ? new String[]{"TABLE", "VIEW", "SYNONYM"} : new String[]{"TABLE", "VIEW"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TableMetadata getTableMetadata(String string, String string2, String string3, boolean bl) throws HibernateException {
        Object object = this.identifier(string3, string2, string);
        TableMetadata tableMetadata = (TableMetadata)this.tables.get(object);
        if (tableMetadata != null) {
            return tableMetadata;
        }
        try {
            ResultSet resultSet = null;
            try {
                String string4;
                resultSet = bl && this.meta.storesMixedCaseQuotedIdentifiers() ? this.meta.getTables(string3, string2, string, this.types) : (bl && this.meta.storesUpperCaseQuotedIdentifiers() || !bl && this.meta.storesUpperCaseIdentifiers() ? this.meta.getTables(StringHelper.toUpperCase(string3), StringHelper.toUpperCase(string2), StringHelper.toUpperCase(string), this.types) : (bl && this.meta.storesLowerCaseQuotedIdentifiers() || !bl && this.meta.storesLowerCaseIdentifiers() ? this.meta.getTables(StringHelper.toLowerCase(string3), StringHelper.toLowerCase(string2), StringHelper.toLowerCase(string), this.types) : this.meta.getTables(string3, string2, string, this.types)));
                while (resultSet.next()) {
                    string4 = resultSet.getString("TABLE_NAME");
                    if (!string.equalsIgnoreCase(string4)) continue;
                    tableMetadata = new TableMetadata(resultSet, this.meta, this.extras);
                    this.tables.put(object, tableMetadata);
                    TableMetadata tableMetadata2 = tableMetadata;
                    return tableMetadata2;
                }
                LOG.tableNotFound(string);
                string4 = null;
                return string4;
            }
            finally {
                resultSet.close();
            }
        }
        catch (SQLException sQLException) {
            throw new SqlExceptionHelper(this.sqlExceptionConverter).convert(sQLException, "could not get table metadata: " + string);
        }
    }

    private Object identifier(String string, String string2, String string3) {
        return Table.qualify(string, string2, string3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initSequences(Connection connection, Dialect dialect) throws SQLException {
        String string;
        if (dialect.supportsSequences() && (string = dialect.getQuerySequencesString()) != null) {
            Statement statement = null;
            ResultSet resultSet = null;
            try {
                statement = connection.createStatement();
                resultSet = statement.executeQuery(string);
                while (resultSet.next()) {
                    this.sequences.add(resultSet.getString(1).toLowerCase().trim());
                }
            }
            finally {
                resultSet.close();
                statement.close();
            }
        }
    }

    public boolean isSequence(Object object) {
        if (object instanceof String) {
            String[] stringArray = StringHelper.split(".", (String)object);
            return this.sequences.contains(stringArray[stringArray.length - 1].toLowerCase());
        }
        return false;
    }

    public boolean isTable(Object object) throws HibernateException {
        if (object instanceof String) {
            Table table = new Table((String)object);
            if (this.getTableMetadata(table.getName(), table.getSchema(), table.getCatalog(), table.isQuoted()) != null) {
                return true;
            }
            String[] stringArray = StringHelper.split(".", (String)object);
            if (stringArray.length == 3) {
                table = new Table(stringArray[2]);
                table.setCatalog(stringArray[0]);
                table.setSchema(stringArray[1]);
                return this.getTableMetadata(table.getName(), table.getSchema(), table.getCatalog(), table.isQuoted()) != null;
            }
            if (stringArray.length == 2) {
                table = new Table(stringArray[1]);
                table.setSchema(stringArray[0]);
                return this.getTableMetadata(table.getName(), table.getSchema(), table.getCatalog(), table.isQuoted()) != null;
            }
        }
        return false;
    }

    public String toString() {
        return "DatabaseMetadata" + this.tables.keySet().toString() + this.sequences.toString();
    }
}

