/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.hbm2ddl;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.StringTokenizer;

public class ColumnMetadata {
    private final String name;
    private final String typeName;
    private final int columnSize;
    private final int decimalDigits;
    private final String isNullable;
    private final int typeCode;

    ColumnMetadata(ResultSet resultSet) throws SQLException {
        this.name = resultSet.getString("COLUMN_NAME");
        this.columnSize = resultSet.getInt("COLUMN_SIZE");
        this.decimalDigits = resultSet.getInt("DECIMAL_DIGITS");
        this.isNullable = resultSet.getString("IS_NULLABLE");
        this.typeCode = resultSet.getInt("DATA_TYPE");
        this.typeName = new StringTokenizer(resultSet.getString("TYPE_NAME"), "() ").nextToken();
    }

    public String getName() {
        return this.name;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public int getColumnSize() {
        return this.columnSize;
    }

    public int getDecimalDigits() {
        return this.decimalDigits;
    }

    public String getNullable() {
        return this.isNullable;
    }

    public String toString() {
        return "ColumnMetadata(" + this.name + ')';
    }

    public int getTypeCode() {
        return this.typeCode;
    }
}

