/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.enhance;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javax.persistence.Entity;
import javax.persistence.Transient;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.hibernate.bytecode.enhance.spi.EnhancementContext;
import org.hibernate.bytecode.enhance.spi.Enhancer;

public class EnhancementTask
extends Task
implements EnhancementContext {
    private List<FileSet> filesets = new ArrayList<FileSet>();
    private final ClassPool classPool = new ClassPool(false);
    private final Enhancer enhancer = new Enhancer(this);

    public void addFileset(FileSet fileSet) {
        this.filesets.add(fileSet);
    }

    public void execute() throws BuildException {
        this.log("Starting Hibernate EnhancementTask execution", 2);
        Project project = this.getProject();
        for (FileSet fileSet : this.filesets) {
            File file = fileSet.getDir(project);
            DirectoryScanner directoryScanner = fileSet.getDirectoryScanner(project);
            for (String string : directoryScanner.getIncludedFiles()) {
                File file2 = new File(file, string);
                if (!file2.exists()) continue;
                this.processClassFile(file2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processClassFile(File file) {
        try {
            byte[] byArray;
            CtClass ctClass = this.classPool.makeClass((InputStream)new FileInputStream(file));
            if (!this.shouldInclude(ctClass)) {
                return;
            }
            try {
                byArray = this.enhancer.enhance(ctClass.getName(), ctClass.toBytecode());
            }
            catch (Exception exception) {
                this.log("Unable to enhance class [" + ctClass.getName() + "]", exception, 1);
                return;
            }
            if (file.delete()) {
                if (!file.createNewFile()) {
                    this.log("Unable to recreate class file [" + ctClass.getName() + "]", 2);
                }
            } else {
                this.log("Unable to delete class file [" + ctClass.getName() + "]", 2);
            }
            FileOutputStream fileOutputStream = new FileOutputStream(file, false);
            try {
                fileOutputStream.write(byArray);
                fileOutputStream.flush();
            }
            finally {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            throw new BuildException(String.format("Error processing included file [%s]", file.getAbsolutePath()), (Throwable)iOException);
        }
    }

    private boolean shouldInclude(CtClass ctClass) {
        return ctClass.hasAnnotation(Entity.class);
    }

    public ClassLoader getLoadingClassLoader() {
        return this.getClass().getClassLoader();
    }

    public boolean isEntityClass(CtClass ctClass) {
        return true;
    }

    public boolean isCompositeClass(CtClass ctClass) {
        return false;
    }

    public boolean doDirtyCheckingInline(CtClass ctClass) {
        return false;
    }

    public boolean hasLazyLoadableAttributes(CtClass ctClass) {
        return true;
    }

    public boolean isLazyLoadable(CtField ctField) {
        return true;
    }

    public boolean isPersistentField(CtField ctField) {
        return !ctField.hasAnnotation(Transient.class);
    }

    public CtField[] order(CtField[] ctFieldArray) {
        return ctFieldArray;
    }
}

