/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.stat.internal;

import org.hibernate.HibernateException;
import org.hibernate.cfg.Configuration;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.metamodel.source.MetadataImplementor;
import org.hibernate.service.Service;
import org.hibernate.service.classloading.spi.ClassLoaderService;
import org.hibernate.service.config.spi.ConfigurationService;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.service.spi.SessionFactoryServiceInitiator;
import org.hibernate.stat.internal.ConcurrentStatisticsImpl;
import org.hibernate.stat.spi.StatisticsFactory;
import org.hibernate.stat.spi.StatisticsImplementor;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatisticsInitiator
implements SessionFactoryServiceInitiator<StatisticsImplementor> {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, StatisticsInitiator.class.getName());
    public static final StatisticsInitiator INSTANCE = new StatisticsInitiator();
    public static final String STATS_BUILDER = "hibernate.stats.factory";
    private static StatisticsFactory DEFAULT_STATS_BUILDER = new StatisticsFactory(){

        public StatisticsImplementor buildStatistics(SessionFactoryImplementor sessionFactoryImplementor) {
            return new ConcurrentStatisticsImpl(sessionFactoryImplementor);
        }
    };

    @Override
    public Class<StatisticsImplementor> getServiceInitiated() {
        return StatisticsImplementor.class;
    }

    @Override
    public StatisticsImplementor initiateService(SessionFactoryImplementor sessionFactoryImplementor, Configuration configuration, ServiceRegistryImplementor serviceRegistryImplementor) {
        Object object = configuration.getProperties().get(STATS_BUILDER);
        return this.initiateServiceInternal(sessionFactoryImplementor, object, serviceRegistryImplementor);
    }

    @Override
    public StatisticsImplementor initiateService(SessionFactoryImplementor sessionFactoryImplementor, MetadataImplementor metadataImplementor, ServiceRegistryImplementor serviceRegistryImplementor) {
        ConfigurationService configurationService = serviceRegistryImplementor.getService(ConfigurationService.class);
        Object t = configurationService.getSetting(STATS_BUILDER, null);
        return this.initiateServiceInternal(sessionFactoryImplementor, t, serviceRegistryImplementor);
    }

    private StatisticsImplementor initiateServiceInternal(SessionFactoryImplementor sessionFactoryImplementor, Object object, ServiceRegistryImplementor serviceRegistryImplementor) {
        Service service;
        StatisticsFactory statisticsFactory;
        if (object == null) {
            statisticsFactory = DEFAULT_STATS_BUILDER;
        } else if (StatisticsFactory.class.isInstance(object)) {
            statisticsFactory = (StatisticsFactory)object;
        } else {
            service = serviceRegistryImplementor.getService(ClassLoaderService.class);
            try {
                statisticsFactory = (StatisticsFactory)service.classForName(object.toString()).newInstance();
            }
            catch (HibernateException hibernateException) {
                throw hibernateException;
            }
            catch (Exception exception) {
                throw new HibernateException("Unable to instantiate specified StatisticsFactory implementation [" + object.toString() + "]", exception);
            }
        }
        service = statisticsFactory.buildStatistics(sessionFactoryImplementor);
        boolean bl = sessionFactoryImplementor.getSettings().isStatisticsEnabled();
        service.setStatisticsEnabled(bl);
        LOG.debugf("Statistics initialized [enabled=%s]", (Object)bl);
        return service;
    }
}

