/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.stat.internal;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.hibernate.cache.spi.CacheKey;
import org.hibernate.cache.spi.Region;
import org.hibernate.stat.NaturalIdCacheStatistics;
import org.hibernate.stat.internal.CategorizedStatistics;

public class ConcurrentNaturalIdCacheStatisticsImpl
extends CategorizedStatistics
implements NaturalIdCacheStatistics {
    private static final long serialVersionUID = 1L;
    private final transient Region region;
    private final AtomicLong hitCount = new AtomicLong();
    private final AtomicLong missCount = new AtomicLong();
    private final AtomicLong putCount = new AtomicLong();
    private final AtomicLong executionCount = new AtomicLong();
    private final AtomicLong executionMaxTime = new AtomicLong();
    private final AtomicLong executionMinTime = new AtomicLong(Long.MAX_VALUE);
    private final AtomicLong totalExecutionTime = new AtomicLong();
    private final Lock readLock;
    private final Lock writeLock;

    ConcurrentNaturalIdCacheStatisticsImpl(Region region) {
        super(region.getName());
        ReentrantReadWriteLock reentrantReadWriteLock = new ReentrantReadWriteLock();
        this.readLock = reentrantReadWriteLock.readLock();
        this.writeLock = reentrantReadWriteLock.writeLock();
        this.region = region;
    }

    public long getHitCount() {
        return this.hitCount.get();
    }

    public long getMissCount() {
        return this.missCount.get();
    }

    public long getPutCount() {
        return this.putCount.get();
    }

    public long getExecutionCount() {
        return this.executionCount.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getExecutionAvgTime() {
        this.writeLock.lock();
        try {
            long l = 0L;
            if (this.executionCount.get() > 0L) {
                l = this.totalExecutionTime.get() / this.executionCount.get();
            }
            long l2 = l;
            return l2;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public long getExecutionMaxTime() {
        return this.executionMaxTime.get();
    }

    public long getExecutionMinTime() {
        return this.executionMinTime.get();
    }

    public long getElementCountInMemory() {
        return this.region.getElementCountInMemory();
    }

    public long getElementCountOnDisk() {
        return this.region.getElementCountOnDisk();
    }

    public long getSizeInMemory() {
        return this.region.getSizeInMemory();
    }

    public Map getEntries() {
        HashMap hashMap = new HashMap();
        for (Map.Entry entry : this.region.toMap().entrySet()) {
            hashMap.put(((CacheKey)entry.getKey()).getKey(), entry.getValue());
        }
        return hashMap;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder().append("NaturalIdCacheStatistics").append("[hitCount=").append(this.hitCount).append(",missCount=").append(this.missCount).append(",putCount=").append(this.putCount).append(",executionCount=").append(this.executionCount).append(",executionAvgTime=").append(this.getExecutionAvgTime()).append(",executionMinTime=").append(this.executionMinTime).append(",executionMaxTime=").append(this.executionMaxTime);
        if (this.region != null) {
            stringBuilder.append(",elementCountInMemory=").append(this.getElementCountInMemory()).append(",elementCountOnDisk=").append(this.getElementCountOnDisk()).append(",sizeInMemory=").append(this.getSizeInMemory());
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    void incrementHitCount() {
        this.hitCount.getAndIncrement();
    }

    void incrementMissCount() {
        this.missCount.getAndIncrement();
    }

    void incrementPutCount() {
        this.putCount.getAndIncrement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void queryExecuted(long l) {
        this.readLock.lock();
        try {
            long l2 = this.executionMinTime.get();
            while (l < l2 && !this.executionMinTime.compareAndSet(l2, l)) {
                l2 = this.executionMinTime.get();
            }
            l2 = this.executionMaxTime.get();
            while (l > l2 && !this.executionMaxTime.compareAndSet(l2, l)) {
                l2 = this.executionMaxTime.get();
            }
            this.executionCount.getAndIncrement();
            this.totalExecutionTime.addAndGet(l);
        }
        finally {
            this.readLock.unlock();
        }
    }
}

