/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ordering.antlr;

import antlr.TokenStream;
import java.io.StringReader;
import java.util.Set;
import org.hibernate.HibernateException;
import org.hibernate.hql.internal.ast.util.ASTPrinter;
import org.hibernate.sql.ordering.antlr.GeneratedOrderByFragmentRenderer;
import org.hibernate.sql.ordering.antlr.GeneratedOrderByLexer;
import org.hibernate.sql.ordering.antlr.OrderByAliasResolver;
import org.hibernate.sql.ordering.antlr.OrderByFragmentParser;
import org.hibernate.sql.ordering.antlr.OrderByFragmentRenderer;
import org.hibernate.sql.ordering.antlr.OrderByTemplateTokenTypes;
import org.hibernate.sql.ordering.antlr.OrderByTranslation;
import org.hibernate.sql.ordering.antlr.TranslationContext;
import org.jboss.logging.Logger;

public class OrderByFragmentTranslator {
    private static final Logger LOG = Logger.getLogger(OrderByFragmentTranslator.class.getName());

    public static OrderByTranslation translate(TranslationContext translationContext, String string) {
        Object object;
        GeneratedOrderByLexer generatedOrderByLexer = new GeneratedOrderByLexer(new StringReader(string));
        OrderByFragmentParser orderByFragmentParser = new OrderByFragmentParser((TokenStream)generatedOrderByLexer, translationContext);
        try {
            orderByFragmentParser.orderByFragment();
        }
        catch (HibernateException hibernateException) {
            throw hibernateException;
        }
        catch (Throwable throwable) {
            throw new HibernateException("Unable to parse order-by fragment", throwable);
        }
        if (LOG.isTraceEnabled()) {
            object = new ASTPrinter(OrderByTemplateTokenTypes.class);
            LOG.trace(((ASTPrinter)object).showAsString(orderByFragmentParser.getAST(), "--- {order-by fragment} ---"));
        }
        object = new OrderByFragmentRenderer(translationContext.getSessionFactory());
        try {
            ((GeneratedOrderByFragmentRenderer)object).orderByFragment(orderByFragmentParser.getAST());
        }
        catch (HibernateException hibernateException) {
            throw hibernateException;
        }
        catch (Throwable throwable) {
            throw new HibernateException("Unable to render parsed order-by fragment", throwable);
        }
        return new StandardOrderByTranslationImpl(((GeneratedOrderByFragmentRenderer)object).getRenderedFragment(), orderByFragmentParser.getColumnReferences());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class StandardOrderByTranslationImpl
    implements OrderByTranslation {
        private final String sqlTemplate;
        private final Set<String> columnReferences;

        public StandardOrderByTranslationImpl(String string, Set<String> set) {
            this.sqlTemplate = string;
            this.columnReferences = set;
        }

        @Override
        public String injectAliases(OrderByAliasResolver orderByAliasResolver) {
            String string = this.sqlTemplate;
            for (String string2 : this.columnReferences) {
                String string3 = "{" + string2 + "}";
                string = string.replace(string3, orderByAliasResolver.resolveTableAlias(string2) + '.' + string2);
            }
            return string;
        }
    }
}

