/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ordering.antlr;

import antlr.collections.AST;
import org.hibernate.NullPrecedence;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.hql.internal.ast.util.ASTPrinter;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.sql.ordering.antlr.GeneratedOrderByFragmentRenderer;
import org.hibernate.sql.ordering.antlr.GeneratedOrderByFragmentRendererTokenTypes;
import org.hibernate.sql.ordering.antlr.Node;
import org.jboss.logging.Logger;

public class OrderByFragmentRenderer
extends GeneratedOrderByFragmentRenderer {
    private static final Logger LOG = Logger.getLogger(OrderByFragmentRenderer.class.getName());
    private static final ASTPrinter printer = new ASTPrinter(GeneratedOrderByFragmentRendererTokenTypes.class);
    private final SessionFactoryImplementor sessionFactory;
    private int traceDepth = 0;

    public OrderByFragmentRenderer(SessionFactoryImplementor sessionFactoryImplementor) {
        this.sessionFactory = sessionFactoryImplementor;
    }

    protected void out(AST aST) {
        this.out(((Node)aST).getRenderableText());
    }

    public void traceIn(String string, AST aST) {
        if (this.inputState.guessing > 0) {
            return;
        }
        String string2 = StringHelper.repeat('-', this.traceDepth++ * 2) + "-> ";
        String string3 = string + " (" + this.buildTraceNodeName(aST) + ")";
        LOG.trace(string2 + string3);
    }

    private String buildTraceNodeName(AST aST) {
        return aST == null ? "???" : aST.getText() + " [" + printer.getTokenTypeName(aST.getType()) + "]";
    }

    public void traceOut(String string, AST aST) {
        if (this.inputState.guessing > 0) {
            return;
        }
        String string2 = "<-" + StringHelper.repeat('-', --this.traceDepth * 2) + " ";
        LOG.trace(string2 + string);
    }

    protected String renderOrderByElement(String string, String string2, String string3, String string4) {
        NullPrecedence nullPrecedence = NullPrecedence.parse(string4, this.sessionFactory.getSettings().getDefaultNullPrecedence());
        return this.sessionFactory.getDialect().renderOrderByElement(string, string2, string3, nullPrecedence);
    }
}

