/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ordering.antlr;

import antlr.ASTFactory;
import antlr.CommonAST;
import antlr.TokenStream;
import antlr.collections.AST;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hibernate.dialect.function.SQLFunction;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.sql.ordering.antlr.CollationSpecification;
import org.hibernate.sql.ordering.antlr.ColumnReference;
import org.hibernate.sql.ordering.antlr.Factory;
import org.hibernate.sql.ordering.antlr.FormulaReference;
import org.hibernate.sql.ordering.antlr.GeneratedOrderByFragmentParser;
import org.hibernate.sql.ordering.antlr.OrderingSpecification;
import org.hibernate.sql.ordering.antlr.SortKey;
import org.hibernate.sql.ordering.antlr.SortSpecification;
import org.hibernate.sql.ordering.antlr.SqlValueReference;
import org.hibernate.sql.ordering.antlr.TranslationContext;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrderByFragmentParser
extends GeneratedOrderByFragmentParser {
    private static final Logger LOG = Logger.getLogger(OrderByFragmentParser.class.getName());
    private final TranslationContext context;
    private Set<String> columnReferences = new HashSet<String>();
    private static final int TEMPLATE_MARKER_LENGTH = "$PlaceHolder$".length();
    private int traceDepth = 0;

    public OrderByFragmentParser(TokenStream tokenStream, TranslationContext translationContext) {
        super(tokenStream);
        super.setASTFactory((ASTFactory)new Factory());
        this.context = translationContext;
    }

    public Set<String> getColumnReferences() {
        return this.columnReferences;
    }

    @Override
    protected AST quotedIdentifier(AST aST) {
        String string = this.context.getDialect().quote('`' + aST.getText() + '`');
        this.columnReferences.add(string);
        String string2 = '{' + string + '}';
        return this.getASTFactory().create(21, string2);
    }

    @Override
    protected AST quotedString(AST aST) {
        return this.getASTFactory().create(21, this.context.getDialect().quote(aST.getText()));
    }

    @Override
    protected boolean isFunctionName(AST aST) {
        AST aST2 = aST.getFirstChild();
        if (aST2 != null && "{param list}".equals(aST2.getText())) {
            return true;
        }
        SQLFunction sQLFunction = this.context.getSqlFunctionRegistry().findSQLFunction(aST.getText());
        if (sQLFunction == null) {
            return false;
        }
        return !sQLFunction.hasParenthesesIfNoArguments();
    }

    @Override
    protected AST resolveFunction(AST aST) {
        AST aST2 = aST.getFirstChild();
        if (aST2 != null) {
            assert ("{param list}".equals(aST2.getText()));
            aST2 = aST2.getFirstChild();
        }
        String string = aST.getText();
        SQLFunction sQLFunction = this.context.getSqlFunctionRegistry().findSQLFunction(string);
        if (sQLFunction == null) {
            String string2 = string;
            if (aST2 != null) {
                string2 = string2 + '(';
                while (aST2 != null) {
                    string2 = string2 + this.resolveFunctionArgument(aST2);
                    if ((aST2 = aST2.getNextSibling()) == null) continue;
                    string2 = string2 + ", ";
                }
                string2 = string2 + ')';
            }
            return this.getASTFactory().create(21, string2);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        while (aST2 != null) {
            arrayList.add(this.resolveFunctionArgument(aST2));
            aST2 = aST2.getNextSibling();
        }
        String string3 = sQLFunction.render(null, arrayList, this.context.getSessionFactory());
        return this.getASTFactory().create(21, string3);
    }

    private String resolveFunctionArgument(AST aST) {
        String string;
        String string2 = aST.getText();
        if (string2.contains("$PlaceHolder$")) {
            string = this.adjustTemplateReferences(string2);
        } else {
            if (string2.startsWith("{") && string2.endsWith("}")) {
                this.columnReferences.add(string2.substring(1, string2.length() - 1));
                return string2;
            }
            string = string2;
            Pattern pattern = Pattern.compile("\\{(.*)\\}");
            Matcher matcher = pattern.matcher(string);
            while (matcher.find()) {
                this.columnReferences.add(matcher.group(1));
            }
        }
        return string;
    }

    @Override
    protected AST resolveIdent(AST aST) {
        SqlValueReference[] sqlValueReferenceArray;
        String string = aST.getText();
        try {
            sqlValueReferenceArray = this.context.getColumnMapper().map(string);
        }
        catch (Throwable throwable) {
            sqlValueReferenceArray = null;
        }
        if (sqlValueReferenceArray == null || sqlValueReferenceArray.length == 0) {
            return this.getASTFactory().create(21, this.makeColumnReference(string));
        }
        if (sqlValueReferenceArray.length == 1) {
            return this.processSqlValueReference(sqlValueReferenceArray[0]);
        }
        AST aST2 = this.getASTFactory().create(11, "{ident list}");
        for (SqlValueReference sqlValueReference : sqlValueReferenceArray) {
            aST2.addChild(this.processSqlValueReference(sqlValueReference));
        }
        return aST2;
    }

    private AST processSqlValueReference(SqlValueReference sqlValueReference) {
        if (ColumnReference.class.isInstance(sqlValueReference)) {
            String string = ((ColumnReference)sqlValueReference).getColumnName();
            return this.getASTFactory().create(21, this.makeColumnReference(string));
        }
        String string = ((FormulaReference)sqlValueReference).getFormulaFragment();
        String string2 = this.adjustTemplateReferences(string);
        return this.getASTFactory().create(21, string2);
    }

    private String makeColumnReference(String string) {
        this.columnReferences.add(string);
        return "{" + string + "}";
    }

    private String adjustTemplateReferences(String string) {
        int n = string.length();
        int n2 = string.indexOf("$PlaceHolder$");
        while (n2 != -1 && n2 < n) {
            int n3;
            int n4 = n2 + TEMPLATE_MARKER_LENGTH;
            for (n3 = n4 + 1; n3 < n && OrderByFragmentParser.isValidIdentifierCharacter(string.charAt(n3)); ++n3) {
            }
            String string2 = string.substring(n4 + 1, n3);
            String string3 = "{" + string2 + "}";
            string = string.replace(string.substring(n2, n3), string3);
            this.columnReferences.add(string2);
            n2 = string.indexOf("$PlaceHolder$", n3 - TEMPLATE_MARKER_LENGTH + 1);
            n = string.length();
        }
        return string;
    }

    private static boolean isValidIdentifierCharacter(char c) {
        return Character.isLetter(c) || Character.isDigit(c) || '_' == c || '\"' == c;
    }

    @Override
    protected AST postProcessSortSpecification(AST aST) {
        assert (5 == aST.getType());
        SortSpecification sortSpecification = (SortSpecification)aST;
        SortKey sortKey = sortSpecification.getSortKey();
        if (11 == sortKey.getFirstChild().getType()) {
            AST aST2 = sortKey.getFirstChild();
            AST aST3 = aST2.getFirstChild();
            CommonAST commonAST = new CommonAST();
            do {
                commonAST.addChild((AST)this.createSortSpecification(aST3, sortSpecification.getCollation(), sortSpecification.getOrdering()));
            } while ((aST3 = aST3.getNextSibling()) != null);
            aST = commonAST.getFirstChild();
        }
        return aST;
    }

    private SortSpecification createSortSpecification(AST aST, CollationSpecification collationSpecification, OrderingSpecification orderingSpecification) {
        AST aST2 = this.getASTFactory().create(5, "{{sort specification}}");
        AST aST3 = this.getASTFactory().create(8, "{{sort key}}");
        AST aST4 = this.getASTFactory().create(aST.getType(), aST.getText());
        aST3.setFirstChild(aST4);
        aST2.setFirstChild(aST3);
        if (collationSpecification != null) {
            aST2.addChild((AST)collationSpecification);
        }
        if (orderingSpecification != null) {
            aST2.addChild((AST)orderingSpecification);
        }
        return (SortSpecification)aST2;
    }

    public void traceIn(String string) {
        if (this.inputState.guessing > 0) {
            return;
        }
        String string2 = StringHelper.repeat('-', this.traceDepth++ * 2) + "-> ";
        LOG.trace(string2 + string);
    }

    public void traceOut(String string) {
        if (this.inputState.guessing > 0) {
            return;
        }
        String string2 = "<-" + StringHelper.repeat('-', --this.traceDepth * 2) + " ";
        LOG.trace(string2 + string);
    }

    @Override
    protected void trace(String string) {
        LOG.trace(string);
    }
}

