/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.hibernate.HibernateException;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.function.SQLFunction;
import org.hibernate.dialect.function.SQLFunctionRegistry;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.sql.ordering.antlr.ColumnMapper;
import org.hibernate.sql.ordering.antlr.OrderByAliasResolver;
import org.hibernate.sql.ordering.antlr.OrderByFragmentTranslator;
import org.hibernate.sql.ordering.antlr.OrderByTranslation;
import org.hibernate.sql.ordering.antlr.SqlValueReference;
import org.hibernate.sql.ordering.antlr.TranslationContext;

public final class Template {
    private static final Set<String> KEYWORDS = new HashSet<String>();
    private static final Set<String> BEFORE_TABLE_KEYWORDS = new HashSet<String>();
    private static final Set<String> FUNCTION_KEYWORDS = new HashSet<String>();
    public static final String TEMPLATE = "$PlaceHolder$";
    public static OrderByAliasResolver LEGACY_ORDER_BY_ALIAS_RESOLVER;

    private Template() {
    }

    public static String renderWhereStringTemplate(String string, Dialect dialect, SQLFunctionRegistry sQLFunctionRegistry) {
        return Template.renderWhereStringTemplate(string, TEMPLATE, dialect, sQLFunctionRegistry);
    }

    @Deprecated
    public static String renderWhereStringTemplate(String string, String string2, Dialect dialect) {
        return Template.renderWhereStringTemplate(string, string2, dialect, new SQLFunctionRegistry(dialect, Collections.EMPTY_MAP));
    }

    public static String renderWhereStringTemplate(String string, String string2, Dialect dialect, SQLFunctionRegistry sQLFunctionRegistry) {
        String string3;
        String string4 = "=><!+-*/()',|&`" + " \n\r\f\t" + dialect.openQuote() + dialect.closeQuote();
        StringTokenizer stringTokenizer = new StringTokenizer(string, string4, true);
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = stringTokenizer.hasMoreTokens();
        String string5 = string3 = bl6 ? stringTokenizer.nextToken() : null;
        while (bl6) {
            CharSequence charSequence;
            boolean bl7;
            String string6 = string3;
            String string7 = string6.toLowerCase();
            bl6 = stringTokenizer.hasMoreTokens();
            string3 = bl6 ? stringTokenizer.nextToken() : null;
            boolean bl8 = false;
            if (!bl2 && "'".equals(string6)) {
                bl = !bl;
                bl8 = true;
            }
            if (!bl) {
                if ("`".equals(string6)) {
                    bl7 = !bl2;
                    string7 = bl7 ? Character.toString(dialect.openQuote()) : Character.toString(dialect.closeQuote());
                    string6 = string7;
                    bl2 = bl7;
                    bl8 = true;
                } else if (!bl2 && dialect.openQuote() == string6.charAt(0)) {
                    bl7 = true;
                    bl2 = true;
                    bl8 = true;
                } else if (bl2 && dialect.closeQuote() == string6.charAt(0)) {
                    bl2 = false;
                    bl8 = true;
                    bl7 = false;
                } else {
                    bl7 = false;
                }
                if (bl7) {
                    stringBuilder.append(string2).append('.');
                }
            }
            if ("extract".equals(string7) && "(".equals(string3)) {
                String string8 = Template.extractUntil(stringTokenizer, "from");
                charSequence = Template.renderWhereStringTemplate(Template.extractUntil(stringTokenizer, ")"), string2, dialect, sQLFunctionRegistry);
                stringBuilder.append("extract(").append(string8).append(" from ").append((String)charSequence).append(')');
                bl6 = stringTokenizer.hasMoreTokens();
                string3 = bl6 ? stringTokenizer.nextToken() : null;
                continue;
            }
            if ("trim".equals(string7) && "(".equals(string3)) {
                ArrayList<String> arrayList = new ArrayList<String>();
                charSequence = new StringBuilder();
                boolean bl9 = true;
                String string9 = stringTokenizer.nextToken();
                boolean bl10 = false;
                while (bl9) {
                    boolean bl11 = "'".equals(string9);
                    if (bl11) {
                        boolean bl12 = bl10 = !bl10;
                        if (!bl10) {
                            arrayList.add(((StringBuilder)charSequence).append('\'').toString());
                            ((StringBuilder)charSequence).setLength(0);
                        } else {
                            ((StringBuilder)charSequence).append('\'');
                        }
                    } else if (bl10) {
                        ((StringBuilder)charSequence).append(string9);
                    } else if (string9.length() != 1 || !Character.isWhitespace(string9.charAt(0))) {
                        arrayList.add(string9);
                    }
                    string9 = stringTokenizer.nextToken();
                    bl9 = stringTokenizer.hasMoreTokens() && !")".equals(string9);
                }
                TrimOperands trimOperands = new TrimOperands(arrayList);
                stringBuilder.append("trim(");
                if (trimOperands.trimSpec != null) {
                    stringBuilder.append(trimOperands.trimSpec).append(' ');
                }
                if (trimOperands.trimChar != null) {
                    if (trimOperands.trimChar.startsWith("'") && trimOperands.trimChar.endsWith("'")) {
                        stringBuilder.append(trimOperands.trimChar);
                    } else {
                        stringBuilder.append(Template.renderWhereStringTemplate(trimOperands.trimSpec, string2, dialect, sQLFunctionRegistry));
                    }
                    stringBuilder.append(' ');
                }
                if (trimOperands.from != null) {
                    stringBuilder.append(trimOperands.from).append(' ');
                } else if (trimOperands.trimSpec != null || trimOperands.trimChar != null) {
                    stringBuilder.append("from ");
                }
                stringBuilder.append(Template.renderWhereStringTemplate(trimOperands.trimSource, string2, dialect, sQLFunctionRegistry)).append(')');
                bl6 = stringTokenizer.hasMoreTokens();
                string3 = bl6 ? stringTokenizer.nextToken() : null;
                continue;
            }
            boolean bl13 = bl7 = bl || bl2 || bl8 || Character.isWhitespace(string6.charAt(0));
            if (bl7) {
                stringBuilder.append(string6);
            } else if (bl3) {
                stringBuilder.append(string6);
                bl3 = false;
                bl5 = true;
            } else if (bl5) {
                if (!"as".equals(string7)) {
                    bl5 = false;
                }
                stringBuilder.append(string6);
            } else if (Template.isNamedParameter(string6)) {
                stringBuilder.append(string6);
            } else if (Template.isIdentifier(string6, dialect) && !Template.isFunctionOrKeyword(string7, string3, dialect, sQLFunctionRegistry)) {
                stringBuilder.append(string2).append('.').append(dialect.quote(string6));
            } else {
                if (BEFORE_TABLE_KEYWORDS.contains(string7)) {
                    bl3 = true;
                    bl4 = true;
                } else if (bl4 && ",".equals(string7)) {
                    bl3 = true;
                }
                stringBuilder.append(string6);
            }
            if (!bl4 || !KEYWORDS.contains(string7) || BEFORE_TABLE_KEYWORDS.contains(string7)) continue;
            bl4 = false;
        }
        return stringBuilder.toString();
    }

    private static String extractUntil(StringTokenizer stringTokenizer, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = stringTokenizer.nextToken();
        while (!string.equalsIgnoreCase(string2)) {
            stringBuilder.append(string2);
            string2 = stringTokenizer.nextToken();
        }
        return stringBuilder.toString().trim();
    }

    @Deprecated
    public static String renderOrderByStringTemplate(String string, Dialect dialect, SQLFunctionRegistry sQLFunctionRegistry) {
        return Template.renderOrderByStringTemplate(string, NoOpColumnMapper.INSTANCE, null, dialect, sQLFunctionRegistry);
    }

    public static String renderOrderByStringTemplate(String string, ColumnMapper columnMapper, SessionFactoryImplementor sessionFactoryImplementor, Dialect dialect, SQLFunctionRegistry sQLFunctionRegistry) {
        return Template.translateOrderBy(string, columnMapper, sessionFactoryImplementor, dialect, sQLFunctionRegistry).injectAliases(LEGACY_ORDER_BY_ALIAS_RESOLVER);
    }

    public static OrderByTranslation translateOrderBy(String string, final ColumnMapper columnMapper, final SessionFactoryImplementor sessionFactoryImplementor, final Dialect dialect, final SQLFunctionRegistry sQLFunctionRegistry) {
        TranslationContext translationContext = new TranslationContext(){

            public SessionFactoryImplementor getSessionFactory() {
                return sessionFactoryImplementor;
            }

            public Dialect getDialect() {
                return dialect;
            }

            public SQLFunctionRegistry getSqlFunctionRegistry() {
                return sQLFunctionRegistry;
            }

            public ColumnMapper getColumnMapper() {
                return columnMapper;
            }
        };
        return OrderByFragmentTranslator.translate(translationContext, string);
    }

    private static boolean isNamedParameter(String string) {
        return string.startsWith(":");
    }

    private static boolean isFunctionOrKeyword(String string, String string2, Dialect dialect, SQLFunctionRegistry sQLFunctionRegistry) {
        return "(".equals(string2) || KEYWORDS.contains(string) || Template.isFunction(string, string2, sQLFunctionRegistry) || dialect.getKeywords().contains(string) || FUNCTION_KEYWORDS.contains(string);
    }

    private static boolean isFunction(String string, String string2, SQLFunctionRegistry sQLFunctionRegistry) {
        if ("(".equals(string2)) {
            return true;
        }
        SQLFunction sQLFunction = sQLFunctionRegistry.findSQLFunction(string);
        if (sQLFunction == null) {
            return false;
        }
        return !sQLFunction.hasParenthesesIfNoArguments();
    }

    private static boolean isIdentifier(String string, Dialect dialect) {
        return string.charAt(0) == '`' || Character.isLetter(string.charAt(0)) && string.indexOf(46) < 0;
    }

    static {
        KEYWORDS.add("and");
        KEYWORDS.add("or");
        KEYWORDS.add("not");
        KEYWORDS.add("like");
        KEYWORDS.add("is");
        KEYWORDS.add("in");
        KEYWORDS.add("between");
        KEYWORDS.add("null");
        KEYWORDS.add("select");
        KEYWORDS.add("distinct");
        KEYWORDS.add("from");
        KEYWORDS.add("join");
        KEYWORDS.add("inner");
        KEYWORDS.add("outer");
        KEYWORDS.add("left");
        KEYWORDS.add("right");
        KEYWORDS.add("on");
        KEYWORDS.add("where");
        KEYWORDS.add("having");
        KEYWORDS.add("group");
        KEYWORDS.add("order");
        KEYWORDS.add("by");
        KEYWORDS.add("desc");
        KEYWORDS.add("asc");
        KEYWORDS.add("limit");
        KEYWORDS.add("any");
        KEYWORDS.add("some");
        KEYWORDS.add("exists");
        KEYWORDS.add("all");
        KEYWORDS.add("union");
        KEYWORDS.add("minus");
        BEFORE_TABLE_KEYWORDS.add("from");
        BEFORE_TABLE_KEYWORDS.add("join");
        FUNCTION_KEYWORDS.add("as");
        FUNCTION_KEYWORDS.add("leading");
        FUNCTION_KEYWORDS.add("trailing");
        FUNCTION_KEYWORDS.add("from");
        FUNCTION_KEYWORDS.add("case");
        FUNCTION_KEYWORDS.add("when");
        FUNCTION_KEYWORDS.add("then");
        FUNCTION_KEYWORDS.add("else");
        FUNCTION_KEYWORDS.add("end");
        LEGACY_ORDER_BY_ALIAS_RESOLVER = new OrderByAliasResolver(){

            public String resolveTableAlias(String string) {
                return Template.TEMPLATE;
            }
        };
    }

    public static class NoOpColumnMapper
    implements ColumnMapper {
        public static final NoOpColumnMapper INSTANCE = new NoOpColumnMapper();

        public SqlValueReference[] map(String string) {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TrimOperands {
        private final String trimSpec;
        private final String trimChar;
        private final String from;
        private final String trimSource;

        private TrimOperands(List<String> list) {
            if (list.size() == 1) {
                this.trimSpec = null;
                this.trimChar = null;
                this.from = null;
                this.trimSource = list.get(0);
            } else if (list.size() == 4) {
                this.trimSpec = list.get(0);
                this.trimChar = list.get(1);
                this.from = list.get(2);
                this.trimSource = list.get(3);
            } else {
                if (list.size() < 1 || list.size() > 4) {
                    throw new HibernateException("Unexpected number of trim function operands : " + list.size());
                }
                this.trimSource = list.get(list.size() - 1);
                if (!"from".equals(list.get(list.size() - 2))) {
                    throw new HibernateException("Expecting FROM, found : " + list.get(list.size() - 2));
                }
                this.from = list.get(list.size() - 2);
                if ("leading".equalsIgnoreCase(list.get(0)) || "trailing".equalsIgnoreCase(list.get(0)) || "both".equalsIgnoreCase(list.get(0))) {
                    this.trimSpec = list.get(0);
                    this.trimChar = null;
                } else {
                    this.trimSpec = null;
                    this.trimChar = list.size() - 2 == 0 ? null : list.get(0);
                }
            }
        }
    }
}

