/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.dialect.Dialect;

public class SimpleSelect {
    private String tableName;
    private String orderBy;
    private Dialect dialect;
    private LockOptions lockOptions = new LockOptions(LockMode.READ);
    private String comment;
    private List columns = new ArrayList();
    private Map aliases = new HashMap();
    private List whereTokens = new ArrayList();

    public SimpleSelect(Dialect dialect) {
        this.dialect = dialect;
    }

    public SimpleSelect addColumns(String[] stringArray, String[] stringArray2) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null) continue;
            this.addColumn(stringArray[i], stringArray2[i]);
        }
        return this;
    }

    public SimpleSelect addColumns(String[] stringArray, String[] stringArray2, boolean[] blArray) {
        for (int i = 0; i < blArray.length; ++i) {
            if (blArray[i] || stringArray[i] == null) continue;
            this.addColumn(stringArray[i], stringArray2[i]);
        }
        return this;
    }

    public SimpleSelect addColumns(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null) continue;
            this.addColumn(stringArray[i]);
        }
        return this;
    }

    public SimpleSelect addColumn(String string) {
        this.columns.add(string);
        return this;
    }

    public SimpleSelect addColumn(String string, String string2) {
        this.columns.add(string);
        this.aliases.put(string, string2);
        return this;
    }

    public SimpleSelect setTableName(String string) {
        this.tableName = string;
        return this;
    }

    public SimpleSelect setLockOptions(LockOptions lockOptions) {
        LockOptions.copy(lockOptions, this.lockOptions);
        return this;
    }

    public SimpleSelect setLockMode(LockMode lockMode) {
        this.lockOptions.setLockMode(lockMode);
        return this;
    }

    public SimpleSelect addWhereToken(String string) {
        this.whereTokens.add(string);
        return this;
    }

    private void and() {
        if (this.whereTokens.size() > 0) {
            this.whereTokens.add("and");
        }
    }

    public SimpleSelect addCondition(String string, String string2, String string3) {
        this.and();
        this.whereTokens.add(string + ' ' + string2 + ' ' + string3);
        return this;
    }

    public SimpleSelect addCondition(String string, String string2) {
        this.and();
        this.whereTokens.add(string + ' ' + string2);
        return this;
    }

    public SimpleSelect addCondition(String[] stringArray, String string, String[] stringArray2) {
        for (int i = 0; i < stringArray.length; ++i) {
            this.addCondition(stringArray[i], string, stringArray2[i]);
        }
        return this;
    }

    public SimpleSelect addCondition(String[] stringArray, String string) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null) continue;
            this.addCondition(stringArray[i], string);
        }
        return this;
    }

    public String toStatementString() {
        StringBuilder stringBuilder = new StringBuilder(this.columns.size() * 10 + this.tableName.length() + this.whereTokens.size() * 10 + 10);
        if (this.comment != null) {
            stringBuilder.append("/* ").append(this.comment).append(" */ ");
        }
        stringBuilder.append("select ");
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = this.columns.iterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = (String)this.aliases.get(string);
            if (!hashSet.add(string2 == null ? string : string2)) continue;
            if (bl) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(string);
            if (string2 != null && !string2.equals(string)) {
                stringBuilder.append(" as ").append(string2);
            }
            bl = true;
        }
        stringBuilder.append(" from ").append(this.dialect.appendLockHint(this.lockOptions, this.tableName));
        if (this.whereTokens.size() > 0) {
            stringBuilder.append(" where ").append(this.toWhereClause());
        }
        if (this.orderBy != null) {
            stringBuilder.append(this.orderBy);
        }
        if (this.lockOptions != null) {
            stringBuilder.append(this.dialect.getForUpdateString(this.lockOptions));
        }
        return this.dialect.transformSelectString(stringBuilder.toString());
    }

    public String toWhereClause() {
        StringBuilder stringBuilder = new StringBuilder(this.whereTokens.size() * 5);
        Iterator iterator = this.whereTokens.iterator();
        while (iterator.hasNext()) {
            stringBuilder.append(iterator.next());
            if (!iterator.hasNext()) continue;
            stringBuilder.append(' ');
        }
        return stringBuilder.toString();
    }

    public SimpleSelect setOrderBy(String string) {
        this.orderBy = string;
        return this;
    }

    public SimpleSelect setComment(String string) {
        this.comment = string;
        return this;
    }
}

