/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql;

import java.util.ArrayList;
import java.util.HashSet;
import org.hibernate.dialect.Dialect;
import org.jboss.logging.Logger;

public class SelectValues {
    private static final Logger log = Logger.getLogger(SelectValues.class);
    private final Dialect dialect;
    private final ArrayList<SelectValue> selectValueList = new ArrayList();

    public SelectValues(Dialect dialect) {
        this.dialect = dialect;
    }

    public SelectValues addColumns(String string, String[] stringArray, String[] stringArray2) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null) continue;
            this.addColumn(string, stringArray[i], stringArray2[i]);
        }
        return this;
    }

    public SelectValues addColumn(String string, String string2, String string3) {
        this.selectValueList.add(new SelectValue(string, string2, string3));
        return this;
    }

    public SelectValues addParameter(int n, int n2) {
        String string = this.dialect.requiresCastingOfParametersInSelectClause() ? this.dialect.cast("?", n, n2) : "?";
        this.selectValueList.add(new SelectValue(null, string, null));
        return this;
    }

    public SelectValues addParameter(int n, int n2, int n3) {
        String string = this.dialect.requiresCastingOfParametersInSelectClause() ? this.dialect.cast("?", n, n2, n3) : "?";
        this.selectValueList.add(new SelectValue(null, string, null));
        return this;
    }

    public String render() {
        StringBuilder stringBuilder = new StringBuilder(this.selectValueList.size() * 10);
        HashSet<String> hashSet = new HashSet<String>();
        boolean bl = true;
        for (SelectValue selectValue : this.selectValueList) {
            if (selectValue.alias != null && !hashSet.add(selectValue.alias)) {
                log.debug("Skipping select-value with non-unique alias");
                continue;
            }
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(", ");
            }
            if (selectValue.qualifier != null) {
                stringBuilder.append(selectValue.qualifier).append('.');
            }
            stringBuilder.append(selectValue.value);
            if (selectValue.alias == null) continue;
            stringBuilder.append(" as ").append(selectValue.alias);
        }
        return stringBuilder.toString();
    }

    private static class SelectValue {
        private final String qualifier;
        private final String value;
        private final String alias;

        private SelectValue(String string, String string2, String string3) {
            this.qualifier = string;
            this.value = string2;
            this.alias = string3;
        }
    }
}

